import type { Logger } from '../types';
/**
 * Default console-based logger implementation for the i18next toolkit.
 * Provides basic logging functionality with different severity levels.
 *
 * @example
 * ```typescript
 * const logger = new ConsoleLogger()
 * logger.info('Extraction started')
 * logger.warn('Deprecated configuration option used')
 * logger.error('Failed to parse file')
 * ```
 */
export declare class ConsoleLogger implements Logger {
    /**
     * Logs an informational message to the console.
     *
     * @param message - The message to log
     */
    info(message: string): void;
    /**
     * Logs a warning message to the console.
     *
     * @param message - The warning message to log
     */
    warn(message: string): void;
    /**
     * Logs an error message to the console.
     *
     * @param message - The error message to log
     */
    error(message: string): void;
}
//# sourceMappingURL=logger.d.ts.map