// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
type ExponentialHistogramDataPoint struct {
	Positive          ExponentialHistogramDataPointBuckets
	Negative          ExponentialHistogramDataPointBuckets
	Attributes        []KeyValue
	Exemplars         []Exemplar
	StartTimeUnixNano uint64
	TimeUnixNano      uint64
	Count             uint64
	Sum               float64
	ZeroCount         uint64
	Min               float64
	Max               float64
	ZeroThreshold     float64
	metadata          [1]uint64
	Scale             int32
	Flags             uint32
}

var (
	protoPoolExponentialHistogramDataPoint = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPoint{}
		},
	}
)

func NewExponentialHistogramDataPoint() *ExponentialHistogramDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &ExponentialHistogramDataPoint{}
	}
	return protoPoolExponentialHistogramDataPoint.Get().(*ExponentialHistogramDataPoint)
}

func DeleteExponentialHistogramDataPoint(orig *ExponentialHistogramDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	DeleteExponentialHistogramDataPointBuckets(&orig.Positive, false)
	DeleteExponentialHistogramDataPointBuckets(&orig.Negative, false)

	for i := range orig.Exemplars {
		DeleteExemplar(&orig.Exemplars[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogramDataPoint.Put(orig)
	}
}

func CopyExponentialHistogramDataPoint(dest, src *ExponentialHistogramDataPoint) *ExponentialHistogramDataPoint {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExponentialHistogramDataPoint()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Count = src.Count
	if src.HasSum() {
		dest.SetSum(src.Sum)
	} else {
		dest.RemoveSum()
	}

	dest.Scale = src.Scale
	dest.ZeroCount = src.ZeroCount
	CopyExponentialHistogramDataPointBuckets(&dest.Positive, &src.Positive)

	CopyExponentialHistogramDataPointBuckets(&dest.Negative, &src.Negative)

	dest.Flags = src.Flags
	dest.Exemplars = CopyExemplarSlice(dest.Exemplars, src.Exemplars)

	if src.HasMin() {
		dest.SetMin(src.Min)
	} else {
		dest.RemoveMin()
	}

	if src.HasMax() {
		dest.SetMax(src.Max)
	} else {
		dest.RemoveMax()
	}

	dest.ZeroThreshold = src.ZeroThreshold

	return dest
}

func CopyExponentialHistogramDataPointSlice(dest, src []ExponentialHistogramDataPoint) []ExponentialHistogramDataPoint {
	var newDest []ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]ExponentialHistogramDataPoint, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPoint(&dest[i], false)
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPoint(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExponentialHistogramDataPointPtrSlice(dest, src []*ExponentialHistogramDataPoint) []*ExponentialHistogramDataPoint {
	var newDest []*ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*ExponentialHistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPoint()
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExponentialHistogramDataPoint) Reset() {
	*orig = ExponentialHistogramDataPoint{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExponentialHistogramDataPoint) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig.HasSum() {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if orig.Scale != int32(0) {
		dest.WriteObjectField("scale")
		dest.WriteInt32(orig.Scale)
	}
	if orig.ZeroCount != uint64(0) {
		dest.WriteObjectField("zeroCount")
		dest.WriteUint64(orig.ZeroCount)
	}
	dest.WriteObjectField("positive")
	orig.Positive.MarshalJSON(dest)
	dest.WriteObjectField("negative")
	orig.Negative.MarshalJSON(dest)
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		orig.Exemplars[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			orig.Exemplars[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.HasMin() {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min)
	}
	if orig.HasMax() {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max)
	}
	if orig.ZeroThreshold != float64(0) {
		dest.WriteObjectField("zeroThreshold")
		dest.WriteFloat64(orig.ZeroThreshold)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExponentialHistogramDataPoint) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			orig.SetSum(iter.ReadFloat64())

		case "scale":
			orig.Scale = iter.ReadInt32()
		case "zeroCount", "zero_count":
			orig.ZeroCount = iter.ReadUint64()
		case "positive":

			orig.Positive.UnmarshalJSON(iter)
		case "negative":

			orig.Negative.UnmarshalJSON(iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, Exemplar{})
				orig.Exemplars[len(orig.Exemplars)-1].UnmarshalJSON(iter)
			}

		case "min":
			orig.SetMin(iter.ReadFloat64())

		case "max":
			orig.SetMax(iter.ReadFloat64())

		case "zeroThreshold", "zero_threshold":
			orig.ZeroThreshold = iter.ReadFloat64()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExponentialHistogramDataPoint) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.TimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.Count != uint64(0) {
		n += 9
	}
	if orig.HasSum() {
		n += 9
	}
	if orig.Scale != int32(0) {
		n += 1 + proto.Soz(uint64(orig.Scale))
	}
	if orig.ZeroCount != uint64(0) {
		n += 9
	}
	l = orig.Positive.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.Negative.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	for i := range orig.Exemplars {
		l = orig.Exemplars[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.HasMin() {
		n += 9
	}
	if orig.HasMax() {
		n += 9
	}
	if orig.ZeroThreshold != float64(0) {
		n += 9
	}
	return n
}

func (orig *ExponentialHistogramDataPoint) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.StartTimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig.HasSum() {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	if orig.Scale != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Scale)<<1)^uint32(orig.Scale>>31)))
		pos--
		buf[pos] = 0x30
	}
	if orig.ZeroCount != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ZeroCount))
		pos--
		buf[pos] = 0x39
	}
	l = orig.Positive.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x42

	l = orig.Negative.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	if orig.Flags != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = orig.Exemplars[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig.HasMin() {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min))
		pos--
		buf[pos] = 0x61
	}
	if orig.HasMax() {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max))
		pos--
		buf[pos] = 0x69
	}
	if orig.ZeroThreshold != float64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ZeroThreshold))
		pos--
		buf[pos] = 0x71
	}
	return len(buf) - pos
}

func (orig *ExponentialHistogramDataPoint) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.SetSum(math.Float64frombits(num))

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Scale = int32(uint32(num>>1) ^ uint32(int32((num&1)<<31)>>31))

		case 7:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ZeroCount = uint64(num)

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Positive", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Positive.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Negative", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Negative.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Flags = uint32(num)

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, Exemplar{})
			err = orig.Exemplars[len(orig.Exemplars)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.SetMin(math.Float64frombits(num))

		case 13:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.SetMax(math.Float64frombits(num))

		case 14:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroThreshold", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.ZeroThreshold = math.Float64frombits(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

const fieldBlockExponentialHistogramDataPointSum = uint64(0 >> 6)
const fieldBitExponentialHistogramDataPointSum = uint64(1 << 0 & 0x3F)

func (m *ExponentialHistogramDataPoint) SetSum(value float64) {
	m.Sum = value
	m.metadata[fieldBlockExponentialHistogramDataPointSum] |= fieldBitExponentialHistogramDataPointSum
}

func (m *ExponentialHistogramDataPoint) RemoveSum() {
	m.Sum = float64(0)
	m.metadata[fieldBlockExponentialHistogramDataPointSum] &^= fieldBitExponentialHistogramDataPointSum
}

func (m *ExponentialHistogramDataPoint) HasSum() bool {
	return m.metadata[fieldBlockExponentialHistogramDataPointSum]&fieldBitExponentialHistogramDataPointSum != 0
}

const fieldBlockExponentialHistogramDataPointMin = uint64(1 >> 6)
const fieldBitExponentialHistogramDataPointMin = uint64(1 << 1 & 0x3F)

func (m *ExponentialHistogramDataPoint) SetMin(value float64) {
	m.Min = value
	m.metadata[fieldBlockExponentialHistogramDataPointMin] |= fieldBitExponentialHistogramDataPointMin
}

func (m *ExponentialHistogramDataPoint) RemoveMin() {
	m.Min = float64(0)
	m.metadata[fieldBlockExponentialHistogramDataPointMin] &^= fieldBitExponentialHistogramDataPointMin
}

func (m *ExponentialHistogramDataPoint) HasMin() bool {
	return m.metadata[fieldBlockExponentialHistogramDataPointMin]&fieldBitExponentialHistogramDataPointMin != 0
}

const fieldBlockExponentialHistogramDataPointMax = uint64(2 >> 6)
const fieldBitExponentialHistogramDataPointMax = uint64(1 << 2 & 0x3F)

func (m *ExponentialHistogramDataPoint) SetMax(value float64) {
	m.Max = value
	m.metadata[fieldBlockExponentialHistogramDataPointMax] |= fieldBitExponentialHistogramDataPointMax
}

func (m *ExponentialHistogramDataPoint) RemoveMax() {
	m.Max = float64(0)
	m.metadata[fieldBlockExponentialHistogramDataPointMax] &^= fieldBitExponentialHistogramDataPointMax
}

func (m *ExponentialHistogramDataPoint) HasMax() bool {
	return m.metadata[fieldBlockExponentialHistogramDataPointMax]&fieldBitExponentialHistogramDataPointMax != 0
}

func GenTestExponentialHistogramDataPoint() *ExponentialHistogramDataPoint {
	orig := NewExponentialHistogramDataPoint()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.StartTimeUnixNano = uint64(13)
	orig.TimeUnixNano = uint64(13)
	orig.Count = uint64(13)
	orig.SetSum(float64(3.1415926))
	orig.Scale = int32(13)
	orig.ZeroCount = uint64(13)
	orig.Positive = *GenTestExponentialHistogramDataPointBuckets()
	orig.Negative = *GenTestExponentialHistogramDataPointBuckets()
	orig.Flags = uint32(13)
	orig.Exemplars = []Exemplar{{}, *GenTestExemplar()}
	orig.SetMin(float64(3.1415926))
	orig.SetMax(float64(3.1415926))
	orig.ZeroThreshold = float64(3.1415926)
	return orig
}

func GenTestExponentialHistogramDataPointPtrSlice() []*ExponentialHistogramDataPoint {
	orig := make([]*ExponentialHistogramDataPoint, 5)
	orig[0] = NewExponentialHistogramDataPoint()
	orig[1] = GenTestExponentialHistogramDataPoint()
	orig[2] = NewExponentialHistogramDataPoint()
	orig[3] = GenTestExponentialHistogramDataPoint()
	orig[4] = NewExponentialHistogramDataPoint()
	return orig
}

func GenTestExponentialHistogramDataPointSlice() []ExponentialHistogramDataPoint {
	orig := make([]ExponentialHistogramDataPoint, 5)
	orig[1] = *GenTestExponentialHistogramDataPoint()
	orig[3] = *GenTestExponentialHistogramDataPoint()
	return orig
}
