# Contributing to asciinema

First, if you're opening a GitHub issue make sure it goes to the correct
repository:

- [asciinema/asciinema](https://github.com/asciinema/asciinema/issues) - command-line recorder
- [asciinema/asciinema-server](https://github.com/asciinema/asciinema-server/issues) - public website hosting recordings
- [asciinema/asciinema-player](https://github.com/asciinema/asciinema-player/issues) - player

## Reporting bugs

Open an issue in GitHub issue tracker.

Tell us what's the problem and include steps to reproduce it (reliably).
Including your OS/browser/terminal name and version in the report would be
great.

## Submitting patches with bug fixes

If you found a bug and made a patch for it:

1. Make sure all tests pass. If you add new functionality, add new tests.
1. Send us a pull request, including a description of the fix (referencing an
   existing issue if there's one).

## Requesting new features

We welcome all ideas.

If you believe most asciinema users would benefit from implementing your idea
then feel free to open a GitHub issue. However, as this is an open-source
project maintained by a small team of volunteers we simply can't implement all
of them due to limited resources. Please keep that in mind.

## Proposing features/changes (pull requests)

If you want to propose code change, either introducing a new feature or
improving an existing one, please first discuss this with asciinema team. You
can simply open a separate issue for a discussion or join #asciinema IRC
channel on Libera.Chat.

## Reporting security issues

If you found a security issue in asciinema please contact us at
admin@asciinema.org. For the benefit of all asciinema users please **do
not** publish details of the vulnerability in a GitHub issue.
