// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -std=c23 -Wno-error=odr -triple x86_64-unknown-unknown -emit-llvm -o - %s | FileCheck %s

// This tests the codegen behavior of redefined tag types to ensure the
// generated code looks reasonable.

enum E {
  One = 1,
  Zero = 0,
  Two = 2
};

struct S {
  int x;
  int y;
};

struct S func(struct S s, enum E e);

struct S {
  int x, y;
} what();

// CHECK-LABEL: define dso_local i64 @func(
// CHECK-SAME: i64 [[S_COERCE:%.*]], i32 noundef [[E:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK-NEXT:    [[S:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK-NEXT:    [[E_ADDR:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store i64 [[S_COERCE]], ptr [[S]], align 4
// CHECK-NEXT:    store i32 [[E]], ptr [[E_ADDR]], align 4
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[E_ADDR]], align 4
// CHECK-NEXT:    [[X:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[S]], i32 0, i32 0
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[X]], align 4
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[RETVAL]], ptr align 4 [[S]], i64 8, i1 false)
// CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[RETVAL]], align 4
// CHECK-NEXT:    ret i64 [[TMP1]]
//
struct S func(struct S s, enum E e) {
  s.x = (int)e;
  return s;
}

enum E {
  Zero,
  One,
  Two
};

// Ensure that ignoring the incompatibility due to attributes does not cause a
// crash. Note, this is undefined behavior in Clang until we implement
// attribute structural compatibility logic, so this is not intended to verify
// any particular behavior beyond "don't crash."
struct T {
  _Alignas(double) int x;
};

// CHECK-LABEL: define dso_local i32 @foo(
// CHECK-SAME: i32 [[T_COERCE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[T:%.*]] = alloca [[STRUCT_T:%.*]], align 8
// CHECK-NEXT:    [[COERCE_DIVE:%.*]] = getelementptr inbounds nuw [[STRUCT_T]], ptr [[T]], i32 0, i32 0
// CHECK-NEXT:    store i32 [[T_COERCE]], ptr [[COERCE_DIVE]], align 8
// CHECK-NEXT:    [[X:%.*]] = getelementptr inbounds nuw [[STRUCT_T]], ptr [[T]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[X]], align 8
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int foo(struct T t) {
  return t.x;
}

struct T {
  int x;
};

// CHECK-LABEL: define dso_local i32 @bar(
// CHECK-SAME: i32 [[T_COERCE:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[T:%.*]] = alloca [[STRUCT_T:%.*]], align 8
// CHECK-NEXT:    [[COERCE_DIVE:%.*]] = getelementptr inbounds nuw [[STRUCT_T]], ptr [[T]], i32 0, i32 0
// CHECK-NEXT:    store i32 [[T_COERCE]], ptr [[COERCE_DIVE]], align 8
// CHECK-NEXT:    [[X:%.*]] = getelementptr inbounds nuw [[STRUCT_T]], ptr [[T]], i32 0, i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[X]], align 8
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int bar(struct T t) {
  return t.x;
}
