﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/ChatMessage.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {

ChatMessage::ChatMessage(JsonView jsonValue) { *this = jsonValue; }

ChatMessage& ChatMessage::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ContentType")) {
    m_contentType = jsonValue.GetString("ContentType");
    m_contentTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Content")) {
    m_content = jsonValue.GetString("Content");
    m_contentHasBeenSet = true;
  }
  return *this;
}

JsonValue ChatMessage::Jsonize() const {
  JsonValue payload;

  if (m_contentTypeHasBeenSet) {
    payload.WithString("ContentType", m_contentType);
  }

  if (m_contentHasBeenSet) {
    payload.WithString("Content", m_content);
  }

  return payload;
}

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
