/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.SourceReaderModule;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.KeydefFilter;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.DebugFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class GenMapAndTopicListModule
extends SourceReaderModule {
    public static final String ELEMENT_STUB = "stub";
    private boolean genDebugInfo;
    private Configuration.Mode processingMode;
    private final Map<URI, Job.FileInfo> fileinfos = new HashMap<URI, Job.FileInfo>();
    private final Set<URI> fullTopicSet;
    private final Set<URI> fullMapSet;
    private final Set<URI> hrefTopicSet;
    private final Set<URI> conrefSet;
    private final Set<URI> coderefSet;
    private final Set<GenListModuleReader.Reference> formatSet;
    private final Set<URI> flagImageSet;
    private final SetMultimap<String, URI> htmlSet;
    private final Set<URI> hrefTargetSet;
    private Set<URI> conrefTargetSet;
    private final Set<URI> nonConrefCopytoTargetSet;
    private final Set<URI> coderefTargetSet;
    private final Set<URI> relFlagImagesSet;
    private final NavigableMap<URI, GenListModuleReader.Reference> waitList;
    private final Set<URI> doneList;
    private final Set<URI> failureList;
    private final Set<URI> outDitaFilesSet;
    private final Set<URI> conrefpushSet;
    private final Set<URI> keyrefSet;
    private final Set<URI> resourceOnlySet;
    private URI baseInputDir;
    private boolean profilingEnabled;
    private File ditavalFile;
    private int uplevels = 0;
    private GenListModuleReader listFilter;
    private KeydefFilter keydefFilter;
    private ContentHandler nullHandler;
    private FilterUtils filterUtils;
    private TempFileNameScheme tempFileNameScheme;
    private URI rootFile;
    private List<URI> resources;
    private URI currentFile;
    private Map<String, KeyDef> schemekeydefMap;
    private final Set<URI> schemeSet;
    private final Map<URI, Set<URI>> schemeDictionary;
    private final Map<URI, URI> copyTo = new HashMap<URI, URI>();
    private String transtype;
    private boolean setSystemid = true;
    private final Map<URI, String> sourceFormat = new HashMap<URI, String>();

    public GenMapAndTopicListModule() {
        this.fullTopicSet = new HashSet<URI>(128);
        this.fullMapSet = new HashSet<URI>(128);
        this.hrefTopicSet = new HashSet<URI>(128);
        this.schemeSet = new HashSet<URI>(128);
        this.conrefSet = new HashSet<URI>(128);
        this.formatSet = new HashSet<GenListModuleReader.Reference>();
        this.flagImageSet = new LinkedHashSet<URI>(128);
        this.htmlSet = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        this.hrefTargetSet = new HashSet<URI>(128);
        this.coderefTargetSet = new HashSet<URI>(16);
        this.waitList = new ConcurrentSkipListMap<URI, GenListModuleReader.Reference>();
        this.doneList = ConcurrentHashMap.newKeySet();
        this.failureList = ConcurrentHashMap.newKeySet();
        this.conrefTargetSet = new HashSet<URI>(128);
        this.nonConrefCopytoTargetSet = new HashSet<URI>(128);
        this.outDitaFilesSet = new HashSet<URI>(128);
        this.relFlagImagesSet = new LinkedHashSet<URI>(128);
        this.conrefpushSet = new HashSet<URI>(128);
        this.keyrefSet = new HashSet<URI>(128);
        this.coderefSet = new HashSet<URI>(128);
        this.schemeDictionary = new HashMap<URI, Set<URI>>();
        this.resourceOnlySet = new HashSet<URI>(128);
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        try {
            this.parseInputParameters(input);
            this.initFilters();
            this.initXmlReader();
            this.readResourceFiles();
            this.readStartFile();
            this.processWaitList();
            this.updateBaseDirectory();
            this.handleConref();
            this.outputResult();
        }
        catch (DITAOTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    private void readResourceFiles() throws DITAOTException {
        if (!this.resources.isEmpty()) {
            for (URI resource : this.resources) {
                this.addToWaitList(new GenListModuleReader.Reference(resource));
            }
            this.processWaitList();
            this.resourceOnlySet.addAll(this.hrefTargetSet);
            this.resourceOnlySet.addAll(this.conrefTargetSet);
            this.resourceOnlySet.addAll(this.nonConrefCopytoTargetSet);
            this.resourceOnlySet.addAll(this.outDitaFilesSet);
            this.resourceOnlySet.addAll(this.conrefpushSet);
            this.resourceOnlySet.addAll(this.keyrefSet);
            this.resourceOnlySet.addAll(this.resourceOnlySet);
            this.resourceOnlySet.addAll(this.fullTopicSet);
            this.resourceOnlySet.addAll(this.fullMapSet);
            this.resourceOnlySet.addAll(this.conrefSet);
        }
    }

    private void readStartFile() throws DITAOTException {
        this.addToWaitList(new GenListModuleReader.Reference(this.rootFile, this.getFormatFromPath(this.rootFile)));
    }

    private String getFormatFromPath(URI file) {
        String ext = FileUtils.getExtension(file.getPath());
        if (Configuration.parserMap.containsKey(ext)) {
            return ext;
        }
        return null;
    }

    private void initFilters() {
        this.listFilter = new GenListModuleReader();
        this.listFilter.setLogger(this.logger);
        this.listFilter.setPrimaryDitamap(this.rootFile);
        this.listFilter.setJob(this.job);
        if (this.profilingEnabled) {
            this.filterUtils = this.parseFilterFile();
        }
        this.keydefFilter = new KeydefFilter();
        this.keydefFilter.setLogger(this.logger);
        this.keydefFilter.setCurrentFile(this.rootFile);
        this.keydefFilter.setJob(this.job);
        this.nullHandler = new DefaultHandler();
    }

    private void parseInputParameters(AbstractPipelineInput input) {
        this.ditavalFile = new File(this.job.tempDir, "ditaot.generated.ditaval");
        this.validate = Boolean.parseBoolean(input.getAttribute("validate"));
        if (!this.validate) {
            String msg = MessageUtils.getMessage("DOTJ037W", new String[0]).toString();
            this.logger.warn(msg);
        }
        this.transtype = input.getAttribute("transtype");
        this.gramcache = "yes".equalsIgnoreCase(input.getAttribute("gramcache"));
        this.setSystemid = "yes".equalsIgnoreCase(input.getAttribute("setsystemid"));
        String mode = input.getAttribute("processing-mode");
        this.processingMode = mode != null ? Configuration.Mode.valueOf(mode.toUpperCase()) : Configuration.Mode.LAX;
        this.genDebugInfo = Boolean.parseBoolean(input.getAttribute("generate-debug-attributes"));
        this.job.setGeneratecopyouter(input.getAttribute("generatecopyouter"));
        this.job.setOutterControl(input.getAttribute("outercontrol"));
        this.job.setOnlyTopicInMap(Boolean.parseBoolean(input.getAttribute("onlytopicinmap")));
        this.job.setCrawl(input.getAttribute("crawl"));
        File path = URLUtils.toFile(input.getAttribute("outputdir"));
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Output directory " + String.valueOf(path) + " must be absolute");
        }
        this.job.setOutputDir(path);
        File basedir = URLUtils.toFile(input.getAttribute("basedir"));
        URI ditaInputDir = URLUtils.toURI(input.getAttribute("inputdir"));
        if (ditaInputDir != null) {
            this.baseInputDir = ditaInputDir.isAbsolute() ? ditaInputDir : (ditaInputDir.getPath() != null && ditaInputDir.getPath().startsWith("/") ? URLUtils.setScheme(ditaInputDir, "file") : basedir.toURI().resolve(ditaInputDir));
            assert (this.baseInputDir.isAbsolute());
        }
        this.resources = input.getAttribute("resources") != null ? Stream.of(input.getAttribute("resources").split(File.pathSeparator)).map(resource -> new File((String)resource).toURI()).collect(Collectors.toList()) : Collections.emptyList();
        URI ditaInput = URLUtils.toURI(input.getAttribute("inputmap"));
        this.rootFile = ditaInput.isAbsolute() ? ditaInput : (ditaInput.getPath() != null && ditaInput.getPath().startsWith("/") ? URLUtils.setScheme(ditaInput, "file") : Objects.requireNonNullElseGet(this.baseInputDir, () -> basedir.toURI()).resolve(ditaInput));
        assert (this.rootFile.isAbsolute());
        if (this.baseInputDir == null) {
            this.baseInputDir = this.rootFile.resolve(".");
        }
        assert (this.baseInputDir.isAbsolute());
        this.profilingEnabled = true;
        if (input.getAttribute("profiling.enable") != null) {
            this.profilingEnabled = Boolean.parseBoolean(input.getAttribute("profiling.enable"));
        }
        this.schemekeydefMap = new HashMap<String, KeyDef>();
        this.job.setInputFile(this.rootFile);
    }

    private void processWaitList() throws DITAOTException {
        Map.Entry<URI, GenListModuleReader.Reference> entry = this.waitList.pollFirstEntry();
        while (entry != null) {
            this.processFile(entry.getValue());
            entry = this.waitList.pollFirstEntry();
        }
    }

    @Override
    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        assert (fileToParse.isAbsolute());
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.genDebugInfo) {
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.setLogger(this.logger);
            debugFilter.setCurrentFile(this.currentFile);
            pipe.add(debugFilter);
        }
        if (this.filterUtils != null) {
            ProfilingFilter profilingFilter = new ProfilingFilter(false);
            profilingFilter.setLogger(this.logger);
            profilingFilter.setJob(this.job);
            profilingFilter.setFilterUtils(this.filterUtils);
            profilingFilter.setCurrentFile(fileToParse);
            pipe.add(profilingFilter);
        }
        this.keydefFilter.setCurrentDir(fileToParse.resolve("."));
        this.keydefFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger, this.processingMode));
        pipe.add(this.keydefFilter);
        this.listFilter.setCurrentFile(fileToParse);
        this.listFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger, this.processingMode));
        pipe.add(this.listFilter);
        return pipe;
    }

    private void processFile(GenListModuleReader.Reference ref) throws DITAOTException {
        this.currentFile = ref.filename;
        assert (this.currentFile.isAbsolute());
        this.logger.info("Processing " + String.valueOf(this.currentFile));
        String[] params = new String[]{this.currentFile.toString()};
        try {
            XMLReader xmlSource = XMLUtils.getXmlReader(ref.format, this.processingMode).orElse(this.reader);
            for (XMLFilter f : this.getProcessingPipe(this.currentFile)) {
                f.setParent(xmlSource);
                f.setEntityResolver((EntityResolver)this.xmlUtils.getCatalogResolver());
                xmlSource = f;
            }
            xmlSource.setContentHandler(this.nullHandler);
            xmlSource.parse(this.currentFile.toString());
            if (this.listFilter.isValidInput()) {
                this.processParseResult(this.currentFile);
                this.categorizeCurrentFile(ref);
            } else if (!this.currentFile.equals(this.rootFile)) {
                this.logger.error(MessageUtils.getMessage("DOTJ021E", params).toString());
                this.failureList.add(this.currentFile);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SAXParseException sax) {
            Exception inner = sax.getException();
            if (inner != null && inner instanceof DITAOTException) {
                throw (DITAOTException)inner;
            }
            if (this.currentFile.equals(this.rootFile)) {
                throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ012F", params)) + ": " + sax.getMessage(), sax);
            }
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ013E", params)) + ": " + sax.getMessage(), sax);
            }
            this.logger.error(String.valueOf(MessageUtils.getMessage("DOTJ013E", params)) + ": " + sax.getMessage(), sax);
            this.failureList.add(this.currentFile);
        }
        catch (FileNotFoundException e) {
            if (!URLUtils.exists(this.currentFile)) {
                if (this.currentFile.equals(this.rootFile)) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTA069F", params).toString(), e);
                }
                if (this.processingMode == Configuration.Mode.STRICT) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTX008E", params).toString(), e);
                }
                this.logger.error(MessageUtils.getMessage("DOTX008E", params).toString());
            } else {
                if (this.currentFile.equals(this.rootFile)) {
                    throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ078F", params)) + " Cannot load file: " + e.getMessage(), e);
                }
                if (this.processingMode == Configuration.Mode.STRICT) {
                    throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ079E", params)) + " Cannot load file: " + e.getMessage(), e);
                }
                this.logger.error(String.valueOf(MessageUtils.getMessage("DOTJ079E", params)) + " Cannot load file: " + e.getMessage());
            }
            this.failureList.add(this.currentFile);
        }
        catch (Exception e) {
            if (this.currentFile.equals(this.rootFile)) {
                throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ012F", params)) + ": " + e.getMessage(), e);
            }
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new DITAOTException(String.valueOf(MessageUtils.getMessage("DOTJ013E", params)) + ": " + e.getMessage(), e);
            }
            this.logger.error(String.valueOf(MessageUtils.getMessage("DOTJ013E", params)) + ": " + e.getMessage(), e);
            this.failureList.add(this.currentFile);
        }
        if (!this.listFilter.isValidInput() && this.currentFile.equals(this.rootFile)) {
            if (this.validate) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ022F", params).toString());
            }
            throw new DITAOTException(MessageUtils.getMessage("DOTJ034F", params).toString());
        }
        this.doneList.add(this.currentFile);
        this.listFilter.reset();
        this.keydefFilter.reset();
    }

    private void processParseResult(URI currentFile) {
        LinkedHashSet<GenListModuleReader.Reference> nonCopytoResult = new LinkedHashSet<GenListModuleReader.Reference>(128);
        nonCopytoResult.addAll(this.listFilter.getNonConrefCopytoTargets());
        for (URI uRI : this.listFilter.getConrefTargets()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI), this.getFormatFromPath(URLUtils.stripFragment(uRI))));
        }
        for (URI uRI : this.listFilter.getCopytoMap().values()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (URI uRI : this.listFilter.getIgnoredCopytoSourceSet()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (URI uRI : this.listFilter.getCoderefTargetSet()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (GenListModuleReader.Reference reference : nonCopytoResult) {
            this.categorizeReferenceFile(reference);
            this.updateUplevels(reference.filename);
        }
        for (Map.Entry entry : this.listFilter.getCopytoMap().entrySet()) {
            URI source = (URI)entry.getValue();
            URI target = (URI)entry.getKey();
            this.copyTo.put(target, source);
            this.updateUplevels(target);
        }
        for (URI uRI : this.resources) {
            this.updateUplevels(uRI);
        }
        HashSet<URI> nonTopicrefReferenceSet = new HashSet<URI>();
        nonTopicrefReferenceSet.addAll(this.listFilter.getNonTopicrefReferenceSet());
        nonTopicrefReferenceSet.removeAll(this.listFilter.getNormalProcessingRoleSet());
        nonTopicrefReferenceSet.removeAll(this.listFilter.getResourceOnlySet());
        for (URI file : nonTopicrefReferenceSet) {
            this.updateUplevels(file);
        }
        this.schemeSet.addAll(this.listFilter.getSchemeRefSet());
        for (Map.Entry<String, KeyDef> e : this.keydefFilter.getKeysDMap().entrySet()) {
            String key = e.getKey();
            KeyDef value = e.getValue();
            if (!this.schemeSet.contains(currentFile)) continue;
            this.schemekeydefMap.put(key, new KeyDef(key, value.href, value.scope, value.format, currentFile, null, value.version));
        }
        this.hrefTargetSet.addAll(this.listFilter.getHrefTargets());
        this.conrefTargetSet.addAll(this.listFilter.getConrefTargets());
        Set set = this.listFilter.getNonConrefCopytoTargets().stream().map(r -> r.filename).collect(Collectors.toSet());
        this.nonConrefCopytoTargetSet.addAll(set);
        this.coderefTargetSet.addAll(this.listFilter.getCoderefTargets());
        this.outDitaFilesSet.addAll(this.listFilter.getOutDitaFilesSet());
        Set<URI> schemeSet = this.listFilter.getSchemeSet();
        if (schemeSet != null && !schemeSet.isEmpty()) {
            Set<URI> children = this.schemeDictionary.get(currentFile);
            if (children == null) {
                children = new HashSet<URI>();
            }
            children.addAll(schemeSet);
            this.schemeDictionary.put(currentFile, children);
            Set<URI> hrfSet = this.listFilter.getHrefTargets();
            for (URI filename : hrfSet) {
                children = this.schemeDictionary.get(filename);
                if (children == null) {
                    children = new HashSet<URI>();
                }
                children.addAll(schemeSet);
                this.schemeDictionary.put(filename, children);
            }
        }
    }

    private void categorizeCurrentFile(GenListModuleReader.Reference ref) {
        URI currentFile = ref.filename;
        if (this.listFilter.hasConaction()) {
            this.conrefpushSet.add(currentFile);
        }
        if (this.listFilter.hasConRef()) {
            this.conrefSet.add(currentFile);
        }
        if (this.listFilter.hasKeyRef()) {
            this.keyrefSet.add(currentFile);
        }
        if (this.listFilter.hasCodeRef()) {
            this.coderefSet.add(currentFile);
        }
        if (this.listFilter.isDitaTopic()) {
            if (ref.format != null && !ref.format.equals("dita")) {
                assert (currentFile.getFragment() == null);
                if (!this.sourceFormat.containsKey(currentFile)) {
                    this.sourceFormat.put(currentFile, ref.format);
                }
            }
            this.fullTopicSet.add(currentFile);
            this.hrefTargetSet.add(currentFile);
            if (this.listFilter.hasHref()) {
                this.hrefTopicSet.add(currentFile);
            }
        } else if (this.listFilter.isDitaMap()) {
            if (ref.format != null && !ref.format.equals("ditamap")) {
                assert (currentFile.getFragment() == null);
                if (!this.sourceFormat.containsKey(currentFile)) {
                    this.sourceFormat.put(currentFile, ref.format);
                }
            }
            this.fullMapSet.add(currentFile);
        }
    }

    private void categorizeReferenceFile(GenListModuleReader.Reference file) {
        if (this.listFilter.getCoderefTargets().contains(file.filename)) {
            return;
        }
        if (!GenListModuleReader.isFormatDita(file.format) || !this.listFilter.isDitaTopic() || this.job.crawlTopics() || this.listFilter.getConrefTargets().contains(file.filename)) {
            if (GenListModuleReader.isFormatDita(file.format) || "ditamap".equals(file.format)) {
                this.addToWaitList(file);
            } else if ("image".equals(file.format)) {
                this.formatSet.add(file);
                if (!URLUtils.exists(file.filename)) {
                    this.logger.warn(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toString());
                }
            } else if ("ditaval".equals(file.format)) {
                this.formatSet.add(file);
            } else {
                this.htmlSet.put((Object)file.format, (Object)file.filename);
            }
        }
    }

    private void updateUplevels(URI file) {
        URI f;
        URI relative;
        int lastIndex;
        assert (file.isAbsolute());
        if (file.getPath() != null && (lastIndex = (relative = URLUtils.getRelativePath(this.rootFile, f = file.toString().contains("|") ? URLUtils.toURI(file.toString().substring(0, file.toString().indexOf("|"))) : file).normalize()).getPath().lastIndexOf("../")) != -1) {
            int newUplevels = lastIndex / 3 + 1;
            this.uplevels = Math.max(newUplevels, this.uplevels);
        }
    }

    private void addToWaitList(GenListModuleReader.Reference ref) {
        URI file = ref.filename;
        assert (file.isAbsolute() && file.getFragment() == null);
        if (this.doneList.contains(file) || this.waitList.containsKey(ref.filename) || file.equals(this.currentFile)) {
            return;
        }
        this.waitList.put(ref.filename, ref);
    }

    private void updateBaseDirectory() {
        for (int i = this.uplevels; i > 0; --i) {
            this.baseInputDir = this.baseInputDir.resolve("..");
        }
    }

    private String getLevelsPath(URI rootTemp) {
        int u = rootTemp.toString().split("/").length - 1;
        if (u == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (int current = u; current > 0; --current) {
            buff.append("..").append(File.separator);
        }
        return buff.toString();
    }

    private FilterUtils parseFilterFile() {
        FilterUtils filterUtils;
        if (this.ditavalFile.exists()) {
            DitaValReader ditaValReader = new DitaValReader();
            ditaValReader.setLogger(this.logger);
            ditaValReader.setJob(this.job);
            ditaValReader.read(this.ditavalFile.toURI());
            this.flagImageSet.addAll(ditaValReader.getImageList());
            this.relFlagImagesSet.addAll(ditaValReader.getRelFlagImageList());
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype), ditaValReader.getFilterMap(), ditaValReader.getForegroundConflictColor(), ditaValReader.getBackgroundConflictColor());
        } else {
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype));
        }
        filterUtils.setLogger(this.logger);
        return filterUtils;
    }

    private void handleConref() {
        HashSet<URI> pureConrefTargets = new HashSet<URI>();
        for (URI target : this.conrefTargetSet) {
            if (this.nonConrefCopytoTargetSet.contains(target)) continue;
            pureConrefTargets.add(target);
        }
        this.conrefTargetSet = pureConrefTargets;
        this.fullTopicSet.removeAll(pureConrefTargets);
        this.resourceOnlySet.addAll(pureConrefTargets);
    }

    private void outputResult() throws DITAOTException {
        Object f;
        Job.FileInfo ff;
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(this.job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(this.baseInputDir);
        URI rootTemp = this.tempFileNameScheme.generateTempFileName(this.rootFile);
        File relativeRootFile = URLUtils.toFile(rootTemp);
        this.job.setInputDir(this.baseInputDir);
        this.job.setInputMap(rootTemp);
        this.resourceOnlySet.remove(this.rootFile);
        this.job.setProperty("user.input.file.listfile", "usr.input.file.list");
        File inputfile = new File(this.job.tempDir, "usr.input.file.list");
        this.writeListFile(inputfile, relativeRootFile.toString());
        this.job.setProperty("tempdirToinputmapdir.relative.value", StringUtils.escapeRegExp(this.getPrefix(relativeRootFile)));
        this.job.setProperty("uplevels", this.getLevelsPath(rootTemp));
        this.resourceOnlySet.addAll(this.resources);
        HashSet<URI> res = new HashSet<URI>();
        res.addAll(this.listFilter.getResourceOnlySet());
        res.removeAll(this.listFilter.getNormalProcessingRoleSet());
        this.resourceOnlySet.addAll(res);
        if (this.job.getOnlyTopicInMap() || !this.job.crawlTopics()) {
            Iterator<Object> res1 = new HashSet<URI>();
            res1.addAll(this.listFilter.getNonTopicrefReferenceSet());
            res1.removeAll(this.listFilter.getNormalProcessingRoleSet());
            res1.removeAll(this.listFilter.getResourceOnlySet());
            this.resourceOnlySet.addAll((Collection<URI>)((Object)res1));
        }
        for (URI uRI : this.outDitaFilesSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).isOutDita = true;
        }
        for (URI uRI : this.fullTopicSet) {
            ff = this.getOrCreateFileInfo(this.fileinfos, uRI);
            if (ff.format != null) continue;
            ff.format = this.sourceFormat.getOrDefault(ff.src, "dita");
        }
        for (URI uRI : this.fullMapSet) {
            ff = this.getOrCreateFileInfo(this.fileinfos, uRI);
            if (ff.format != null) continue;
            ff.format = this.sourceFormat.getOrDefault(ff.src, "ditamap");
        }
        for (URI uRI : this.hrefTopicSet) {
            f = this.getOrCreateFileInfo(this.fileinfos, uRI);
            ((Job.FileInfo)f).hasLink = true;
            if (((Job.FileInfo)f).format != null || !this.sourceFormat.containsKey(((Job.FileInfo)f).src)) continue;
            ((Job.FileInfo)f).format = this.sourceFormat.get(((Job.FileInfo)f).src);
        }
        for (URI uRI : this.conrefSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).hasConref = true;
        }
        for (GenListModuleReader.Reference reference : this.formatSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)reference.filename).format = reference.format;
        }
        for (URI uRI : this.flagImageSet) {
            f = this.getOrCreateFileInfo(this.fileinfos, uRI);
            ((Job.FileInfo)f).isFlagImage = true;
            ((Job.FileInfo)f).format = "image";
        }
        for (String string : this.htmlSet.keySet()) {
            for (URI file : this.htmlSet.get((Object)string)) {
                this.getOrCreateFileInfo(this.fileinfos, (URI)file).format = string;
            }
        }
        for (URI uRI : this.hrefTargetSet) {
            f = this.getOrCreateFileInfo(this.fileinfos, uRI);
            ((Job.FileInfo)f).isTarget = true;
            if (((Job.FileInfo)f).format != null || !this.sourceFormat.containsKey(((Job.FileInfo)f).src)) continue;
            ((Job.FileInfo)f).format = this.sourceFormat.get(((Job.FileInfo)f).src);
        }
        for (URI uRI : this.schemeSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).isSubjectScheme = true;
        }
        for (URI uRI : this.coderefTargetSet) {
            f = this.getOrCreateFileInfo(this.fileinfos, uRI);
            ((Job.FileInfo)f).isSubtarget = true;
            if (((Job.FileInfo)f).format != null) continue;
            ((Job.FileInfo)f).format = Constants.PR_D_CODEREF.localName;
        }
        for (URI uRI : this.conrefpushSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).isConrefPush = true;
        }
        for (URI uRI : this.keyrefSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).hasKeyref = true;
        }
        for (URI uRI : this.coderefSet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).hasCoderef = true;
        }
        for (URI uRI : this.resourceOnlySet) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).isResourceOnly = true;
        }
        for (URI uRI : this.resources) {
            this.getOrCreateFileInfo(this.fileinfos, (URI)uRI).isInputResource = true;
        }
        this.addFlagImagesSetToProperties(this.job, this.relFlagImagesSet);
        Map<URI, URI> filteredCopyTo = this.filterConflictingCopyTo(this.copyTo, this.fileinfos.values());
        for (Job.FileInfo fs : this.fileinfos.values()) {
            if (this.failureList.contains(fs.src)) continue;
            URI src = filteredCopyTo.get(fs.src);
            if (src != null) {
                Job.FileInfo corr = new Job.FileInfo.Builder(fs).src(src).build();
                this.job.add(corr);
                continue;
            }
            this.job.add(fs);
        }
        for (URI target : filteredCopyTo.keySet()) {
            URI tmp = this.tempFileNameScheme.generateTempFileName(target);
            Job.FileInfo fi = new Job.FileInfo.Builder().result(target).uri(tmp).build();
            this.job.add(fi);
        }
        Job.FileInfo fileInfo = this.job.getFileInfo(this.rootFile);
        if (fileInfo == null) {
            throw new RuntimeException("Unable to set input file to job configuration");
        }
        this.job.add(new Job.FileInfo.Builder(fileInfo).isInput(true).build());
        try {
            this.logger.debug("Serializing job specification");
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration files: " + e.getMessage(), e);
        }
        try {
            SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
            subjectSchemeReader.setLogger(this.logger);
            subjectSchemeReader.setJob(this.job);
            subjectSchemeReader.writeMapToXML(this.addMapFilePrefix(this.listFilter.getRelationshipGrap()), new File(this.job.tempDir, "subrelation.xml"));
            subjectSchemeReader.writeMapToXML(this.addMapFilePrefix(this.schemeDictionary), new File(this.job.tempDir, "subject_scheme.dictionary"));
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize subject scheme files: " + e.getMessage(), e);
        }
    }

    private Map<URI, URI> filterConflictingCopyTo(Map<URI, URI> copyTo, Collection<Job.FileInfo> fileInfos) {
        Set fileinfoTargets = fileInfos.stream().filter(fi -> fi.src.equals(fi.result)).map(fi -> fi.result).collect(Collectors.toSet());
        return copyTo.entrySet().stream().filter(e -> !fileinfoTargets.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void writeListFile(File inputfile, String relativeRootFile) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.job.getStore().getOutputStream(inputfile.toURI())));){
            bufferedWriter.write(relativeRootFile);
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private String getPrefix(File relativeRootFile) {
        File p = relativeRootFile.getParentFile();
        Object res = p != null ? String.valueOf(p) + File.separator : "";
        return res;
    }

    private Job.FileInfo getOrCreateFileInfo(Map<URI, Job.FileInfo> fileInfos, URI file) {
        assert (file.getFragment() == null);
        URI f = file.normalize();
        Job.FileInfo.Builder b = fileInfos.containsKey(f) ? new Job.FileInfo.Builder(fileInfos.get(f)) : new Job.FileInfo.Builder().src(file);
        b = b.uri(this.tempFileNameScheme.generateTempFileName(file));
        Job.FileInfo i = b.build();
        fileInfos.put(i.src, i);
        return i;
    }

    private Map<URI, Set<URI>> addMapFilePrefix(Map<URI, Set<URI>> map) {
        HashMap<URI, Set<URI>> res = new HashMap<URI, Set<URI>>();
        for (Map.Entry<URI, Set<URI>> e : map.entrySet()) {
            URI key = e.getKey();
            HashSet<URI> newSet = new HashSet<URI>();
            for (URI file : e.getValue()) {
                newSet.add(this.tempFileNameScheme.generateTempFileName(file));
            }
            res.put(key.equals(GenListModuleReader.ROOT_URI) ? key : this.tempFileNameScheme.generateTempFileName(key), newSet);
        }
        return res;
    }

    private Map<URI, URI> addFilePrefix(Map<URI, URI> set) {
        HashMap<URI, URI> newSet = new HashMap<URI, URI>();
        for (Map.Entry<URI, URI> file : set.entrySet()) {
            URI key = this.tempFileNameScheme.generateTempFileName(file.getKey());
            URI value = this.tempFileNameScheme.generateTempFileName(file.getValue());
            newSet.put(key, value);
        }
        return newSet;
    }

    private Collection<KeyDef> addFilePrefix(Collection<KeyDef> keydefs) {
        ArrayList<KeyDef> res = new ArrayList<KeyDef>(keydefs.size());
        for (KeyDef k : keydefs) {
            URI source = this.tempFileNameScheme.generateTempFileName(k.source);
            res.add(new KeyDef(k.keys, k.href, k.scope, k.format, source, null, k.version));
        }
        return res;
    }

    private void addFlagImagesSetToProperties(Job prop, Set<URI> set) {
        LinkedHashSet<URI> newSet = new LinkedHashSet<URI>(128);
        for (URI file : set) {
            if (file.isAbsolute()) {
                newSet.add(file.normalize());
                continue;
            }
            newSet.add(file.normalize());
        }
        String fileKey = "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + "file";
        prop.setProperty(fileKey, "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + ".list");
        File list = this.job.tempDir.toPath().resolve(prop.getProperty(fileKey)).toFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.job.getStore().getOutputStream(list.toURI())));){
            Iterator it = newSet.iterator();
            while (it.hasNext()) {
                bufferedWriter.write(((URI)it.next()).getPath());
                if (!it.hasNext()) continue;
                bufferedWriter.write("\n");
            }
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        prop.setProperty("relflagimagelist", newSet.stream().map(URI::toString).collect(Collectors.joining(",")));
    }
}

