# Packaging Frescobaldi

## Versioning and release best practices

Release versioning should follow
[Python versioning recommendations](https://packaging.python.org/en/latest/discussions/versioning/).

The version number should be bumped right after a release and have a
`.dev1` suffix to mark it as a developmental release.
For example, after 4.0.0 release the version will be bumped to
4.0.1.dev1 so any package built during the development will have
a version different from the actual releases. Right before the
release the `.dev1` suffix can be removed.

Before creating a new release on GitHub make sure to review this
**release checklist**:

- Update the version in `frescobaldi/appinfo.py` and `pyproject.toml`.
- Check that project.dependencies and tool.briefcase.requires versions
  in `pyproject.toml` are correct and up-to-date.
- Make sure that the `CHANGELOG.md` has a complete list of features
  and bug fixes for the new release. Set the release date and add
  a link to the release list of commits.
- Add a new release entry in `linux/org.frescobaldi.Frescobaldi.metainfo.xml.in`.
- Check if the list of contributors in `frescobaldi/userguide/credits.md`
  should be updated.

You can manually run the GitHub Action release workflow on the master
branch just before making a new release in order to test the packages.


## Tarball for Linux distros

The tarball automatically created by GitHub for every release
is missing some files generated by tox: the .mo files containing
the translations for all platforms; the desktop and metainfo
files used for Linux packaging.

The maintainers of Frescobaldi packages for Linux distros don't want
to run build commands to generate the missing files, so we have to
provide a tarball with all the needed files already available.
This tarball is automatically generated for every release.
The link for Linux packagers will be:

```
https://github.com/frescobaldi/frescobaldi/releases/download/v%{version}/frescobaldi-%{version}.tar.gz
```


## Briefcase

[Briefcase](https://briefcase.readthedocs.io/) is a tool for
converting a Python project into a standalone native application.
We use it to build an MSI installer for Windows and the standalone
apps for macOS (one specific for Intel and another one for the other
architectures).

The build details are defined in the [GitHub workflow file](.github/workflows/release.yml).
The workflow is automatically run when a new release is published
and the package files are uploaded on GitHub Releases. But it can
be run manually whenever is needed, for example to test a specific
branch/PR:
https://github.com/frescobaldi/frescobaldi/actions/workflows/release.yml

Some notes for those who want to run Briefcase on their computers.

Install Python on your system, then install Briefcase from PyPI:

```
pip install --user briefcase
```

Enter the frescobaldi git repository and run these commands:

```
briefcase create
briefcase build
```

Now you can test the build without installing it:

```
briefcase run
```

A better command to *debug* a build is:

```
briefcase dev
```

If you want to create a package for your current platform, run:

```
briefcase package
```

The file is saved in the `dist/` directory.

