//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(tracing::Level::INFO, ident = 3); // DEBUG:event,-,-,-,-,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,-,-,p,-,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,-,-,f,-,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,-,-,pf,-,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,-,-,-,m,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,-,-,p,m,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","3"
    tracing::event!(tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","3"
    tracing::event!(tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","3"
    tracing::event!(tracing::Level::INFO, ident = false); // DEBUG:event,-,-,-,-,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,-,-,p,-,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,-,-,f,-,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,-,-,pf,-,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,-,-,-,m,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,-,-,p,m,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","false"
    tracing::event!(tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","false"
    tracing::event!(tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","false"
    tracing::event!(tracing::Level::INFO, ident = ?3); // DEBUG:event,-,-,-,-,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,-,-,p,-,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,-,-,f,-,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,-,-,pf,-,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,-,-,-,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,-,-,p,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","?3"
    tracing::event!(tracing::Level::INFO, ident = %3); // DEBUG:event,-,-,-,-,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,-,-,p,-,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,-,-,f,-,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,-,-,pf,-,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,-,-,-,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,-,-,p,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","%3"
    tracing::event!(tracing::Level::INFO, ident = ?deb); // DEBUG:event,-,-,-,-,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,-,-,p,-,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,-,-,f,-,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,-,-,pf,-,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,-,-,-,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,-,-,p,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","?deb"
    tracing::event!(tracing::Level::INFO, ident = %disp); // DEBUG:event,-,-,-,-,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,-,-,p,-,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,-,-,f,-,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,-,-,pf,-,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,-,-,-,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,-,-,p,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","%disp"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,-,-,-,-,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,-,-,p,-,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","?sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field); // DEBUG:event,-,-,-,-,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,-,-,p,-,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,-,-,f,-,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","%sub.field"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,-,-,-,-,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,-,-,p,-,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,-,-,f,-,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,-,-,pf,-,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,-,-,-,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,-,-,p,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,-,-,-,-,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,-,-,p,-,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,-,-,f,-,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,-,-,pf,-,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,-,-,-,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,-,-,p,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,-,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,-,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,-,-,-,-,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,-,-,p,-,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","3"
    tracing::event!(tracing::Level::INFO, dotted.ident = false); // DEBUG:event,-,-,-,-,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,-,-,p,-,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","false"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,-,-,-,-,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,-,-,p,-,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","?3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,-,-,-,-,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,-,-,p,-,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","%3"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,-,-,-,-,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,-,-,p,-,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,-,-,-,-,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,-,-,p,-,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,-,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,-,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,-,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,-,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = 3); // DEBUG:event,-,-,-,-,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,-,-,p,-,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","3"
    tracing::event!(tracing::Level::INFO, "literal" = false); // DEBUG:event,-,-,-,-,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,-,-,p,-,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","false"
    tracing::event!(tracing::Level::INFO, "literal" = ?3); // DEBUG:event,-,-,-,-,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,-,-,p,-,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","?3"
    tracing::event!(tracing::Level::INFO, "literal" = %3); // DEBUG:event,-,-,-,-,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,-,-,p,-,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","%3"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,-,-,-,-,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,-,-,p,-,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(tracing::Level::INFO, "literal" = %disp); // DEBUG:event,-,-,-,-,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,-,-,p,-,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,-,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,-,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,-,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,-,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = 3); // DEBUG:event,-,-,-,-,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,-,-,p,-,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,-,-,f,-,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","3"
    tracing::event!(tracing::Level::INFO, r#type = false); // DEBUG:event,-,-,-,-,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,-,-,p,-,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,-,-,f,-,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","false"
    tracing::event!(tracing::Level::INFO, r#type = ?3); // DEBUG:event,-,-,-,-,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,-,-,p,-,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,-,-,f,-,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","?3"
    tracing::event!(tracing::Level::INFO, r#type = %3); // DEBUG:event,-,-,-,-,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,-,-,p,-,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,-,-,f,-,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","%3"
    tracing::event!(tracing::Level::INFO, r#type = ?deb); // DEBUG:event,-,-,-,-,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,-,-,p,-,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,-,-,f,-,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","?deb"
    tracing::event!(tracing::Level::INFO, r#type = %disp); // DEBUG:event,-,-,-,-,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,-,-,p,-,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,-,-,f,-,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","%disp"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,-,-,-,-,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,-,-,p,-,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","?sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,-,-,-,-,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,-,-,p,-,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,-,-,f,-,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","%sub.field"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,-,-,-,-,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,-,-,p,-,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,-,-,f,-,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,-,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,-,-,-,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,-,-,p,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,-,-,-,-,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,-,-,p,-,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,-,-,f,-,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,-,-,pf,-,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,-,-,-,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,-,-,p,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(tracing::Level::INFO, var); // DEBUG:event,-,-,-,-,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var); // DEBUG:event,-,-,p,-,-,"var"
    tracing::event!(tracing::Level::INFO, var, qux = 3); // DEBUG:event,-,-,f,-,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,-,-,pf,-,-,"var"
    tracing::event!(tracing::Level::INFO, var, "msg without args"); // DEBUG:event,-,-,-,m,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,-,-,p,m,-,"var"
    tracing::event!(tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"var"
    tracing::event!(tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,-,{},-,m,-,"var"
    tracing::event!(tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,-,{},p,m,-,"var"
    tracing::event!(tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"var"
    tracing::event!(tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"var"
    tracing::event!(tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"var"
    tracing::event!(tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"var"
    tracing::event!(tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"var"
    tracing::event!(tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"var"
    tracing::event!(tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"var"
    tracing::event!(tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"var"
    tracing::event!(tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"var"
    tracing::event!(tracing::Level::INFO, sub.field); // DEBUG:event,-,-,-,-,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,-,-,p,-,-,"sub.field"
    tracing::event!(tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,-,-,f,-,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,-,-,pf,-,-,"sub.field"
    tracing::event!(tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,-,-,-,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,-,-,p,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"sub.field"
    tracing::event!(tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"sub.field"
    tracing::event!(tracing::Level::INFO, %disp); // DEBUG:event,-,-,-,-,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp); // DEBUG:event,-,-,p,-,-,"%disp"
    tracing::event!(tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,-,-,f,-,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,-,-,pf,-,-,"%disp"
    tracing::event!(tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,-,-,-,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,-,-,p,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,-,{},-,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,-,{},p,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"%disp"
    tracing::event!(tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"%disp"
    tracing::event!(tracing::Level::INFO, ?deb); // DEBUG:event,-,-,-,-,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,-,-,p,-,-,"?deb"
    tracing::event!(tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,-,-,f,-,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,-,-,pf,-,-,"?deb"
    tracing::event!(tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,-,-,-,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,-,-,p,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,-,{},-,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,-,{},p,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"?deb"
    tracing::event!(tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"?deb"
    tracing::event!(tracing::Level::INFO, %sub.field); // DEBUG:event,-,-,-,-,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,-,-,p,-,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,-,-,f,-,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,-,-,pf,-,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,-,-,-,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,-,-,p,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"%sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field); // DEBUG:event,-,-,-,-,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,-,-,p,-,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,-,-,f,-,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,-,-,pf,-,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,-,-,-,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,-,-,p,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,f,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,-,-,pf,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,-,{},-,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,-,{},p,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},f,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,-,{},pf,m,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,-,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,-,-,p,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,f,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,-,-,pf,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},-,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},p,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},f,ma,-,"?sub.field"
    tracing::event!(tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,-,{},pf,ma,-,"?sub.field"
}
