// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/models"
)

type DescribeActionLogRequest struct {
	core.JDCloudRequest

	/* 地域ID  */
	RegionId string `json:"regionId"`

	/* 分页参数，页的序号，默认是1  */
	PageNumber int `json:"pageNumber"`

	/* 分页参数，每页含有的结果的数目，默认是10  */
	PageSize int `json:"pageSize"`

	/* 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z  */
	StartTime string `json:"startTime"`

	/* 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z  */
	EndTime string `json:"endTime"`

	/* 日志需要匹配的关键词 (Optional) */
	KeyWord *string `json:"keyWord"`

	/* 日志里面的结果是成功还是失败 (Optional) */
	Success *bool `json:"success"`

	/* 日志的类型 (Optional) */
	Type *int `json:"type"`
}

/*
 * param regionId: 地域ID (Required)
 * param pageNumber: 分页参数，页的序号，默认是1 (Required)
 * param pageSize: 分页参数，每页含有的结果的数目，默认是10 (Required)
 * param startTime: 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z (Required)
 * param endTime: 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeActionLogRequest(
	regionId string,
	pageNumber int,
	pageSize int,
	startTime string,
	endTime string,
) *DescribeActionLogRequest {

	return &DescribeActionLogRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/actionLog",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		PageNumber: pageNumber,
		PageSize:   pageSize,
		StartTime:  startTime,
		EndTime:    endTime,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param pageNumber: 分页参数，页的序号，默认是1 (Required)
 * param pageSize: 分页参数，每页含有的结果的数目，默认是10 (Required)
 * param startTime: 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z (Required)
 * param endTime: 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z (Required)
 * param keyWord: 日志需要匹配的关键词 (Optional)
 * param success: 日志里面的结果是成功还是失败 (Optional)
 * param type_: 日志的类型 (Optional)
 */
func NewDescribeActionLogRequestWithAllParams(
	regionId string,
	pageNumber int,
	pageSize int,
	startTime string,
	endTime string,
	keyWord *string,
	success *bool,
	type_ *int,
) *DescribeActionLogRequest {

	return &DescribeActionLogRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/actionLog",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		PageNumber: pageNumber,
		PageSize:   pageSize,
		StartTime:  startTime,
		EndTime:    endTime,
		KeyWord:    keyWord,
		Success:    success,
		Type:       type_,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeActionLogRequestWithoutParam() *DescribeActionLogRequest {

	return &DescribeActionLogRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/actionLog",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 地域ID(Required) */
func (r *DescribeActionLogRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param pageNumber: 分页参数，页的序号，默认是1(Required) */
func (r *DescribeActionLogRequest) SetPageNumber(pageNumber int) {
	r.PageNumber = pageNumber
}

/* param pageSize: 分页参数，每页含有的结果的数目，默认是10(Required) */
func (r *DescribeActionLogRequest) SetPageSize(pageSize int) {
	r.PageSize = pageSize
}

/* param startTime: 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z(Required) */
func (r *DescribeActionLogRequest) SetStartTime(startTime string) {
	r.StartTime = startTime
}

/* param endTime: 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z(Required) */
func (r *DescribeActionLogRequest) SetEndTime(endTime string) {
	r.EndTime = endTime
}

/* param keyWord: 日志需要匹配的关键词(Optional) */
func (r *DescribeActionLogRequest) SetKeyWord(keyWord string) {
	r.KeyWord = &keyWord
}

/* param success: 日志里面的结果是成功还是失败(Optional) */
func (r *DescribeActionLogRequest) SetSuccess(success bool) {
	r.Success = &success
}

/* param type_: 日志的类型(Optional) */
func (r *DescribeActionLogRequest) SetType(type_ int) {
	r.Type = &type_
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeActionLogRequest) GetRegionId() string {
	return r.RegionId
}

type DescribeActionLogResponse struct {
	RequestID string                  `json:"requestId"`
	Error     core.ErrorResponse      `json:"error"`
	Result    DescribeActionLogResult `json:"result"`
}

type DescribeActionLogResult struct {
	DataList     []domainservice.Actionlog `json:"dataList"`
	CurrentCount int                       `json:"currentCount"`
	TotalCount   int                       `json:"totalCount"`
	TotalPage    int                       `json:"totalPage"`
}
