/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.StringPattern;
import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.List;
import org.relaxng.datatype.Datatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataPattern
extends StringPattern {
    private final Datatype dt;
    private final Name dtName;
    private final List<String> params;

    DataPattern(Datatype datatype, Name name, List<String> list) {
        super(DataPattern.combineHashCode(31, datatype.hashCode()));
        this.dt = datatype;
        this.dtName = name;
        this.params = list;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (pattern.getClass() != this.getClass()) {
            return false;
        }
        return this.dt.equals(((DataPattern)pattern).dt);
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseData(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Name getDatatypeName() {
        return this.dtName;
    }

    List<String> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    boolean allowsAnyString() {
        return this.dt instanceof Datatype2 && ((Datatype2)this.dt).alwaysValid();
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_data");
            }
        }
    }
}

