/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLCopy
extends StyleElement {
    private String use;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.USE_ATTRIBUTE_SETS) {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.findAttributeSets(this.use);
        }
    }

    public void process(Context context) throws TransformerException {
        NodeInfo nodeInfo = context.getCurrentNodeInfo();
        Outputter outputter = context.getOutputter();
        switch (nodeInfo.getNodeType()) {
            case 1: {
                outputter.writeStartTag(nodeInfo.getNameCode());
                nodeInfo.outputNamespaceNodes(outputter, true);
                this.processAttributeSets(context);
                this.processChildren(context);
                outputter.writeEndTag(nodeInfo.getNameCode());
                break;
            }
            case 2: {
                int n = nodeInfo.getNameCode();
                if ((n >> 20 & 0xFF) != 0) {
                    n = outputter.checkAttributePrefix(n);
                }
                outputter.writeAttribute(n, nodeInfo.getStringValue());
                break;
            }
            case 3: {
                outputter.writeContent(nodeInfo.getStringValue());
                break;
            }
            case 7: {
                outputter.writePI(nodeInfo.getDisplayName(), nodeInfo.getStringValue());
                break;
            }
            case 8: {
                outputter.writeComment(nodeInfo.getStringValue());
                break;
            }
            case 13: {
                nodeInfo.copy(outputter);
                break;
            }
            case 9: {
                this.processChildren(context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type " + nodeInfo.getNodeType());
            }
        }
    }
}

