/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

final class CaseInsensitiveMap {
    private static int CHUNK_SHIFT = 10;
    private static int CHUNK_SIZE = 1 << CHUNK_SHIFT;
    private static int CHUNK_MASK = CHUNK_SIZE - 1;
    private static int INITIAL_CHUNK_COUNT = 64;
    private static int[][][] caseInsensitiveMap;
    private static int LOWER_CASE_MATCH;
    private static int UPPER_CASE_MATCH;

    CaseInsensitiveMap() {
    }

    public static int[] get(int n) {
        return n < 65536 ? CaseInsensitiveMap.getMapping(n) : null;
    }

    private static int[] getMapping(int n) {
        int n2 = n >>> CHUNK_SHIFT;
        int n3 = n & CHUNK_MASK;
        return caseInsensitiveMap[n2][n3];
    }

    private static void buildCaseInsensitiveMap() {
        caseInsensitiveMap = new int[INITIAL_CHUNK_COUNT][CHUNK_SIZE][];
        int n = 0;
        while (n < 65536) {
            char c;
            int n2 = Character.toLowerCase((char)n);
            if (n2 != (c = Character.toUpperCase((char)n)) || n2 != n) {
                int[] nArray;
                int[] nArray2 = new int[2];
                int n3 = 0;
                if (n2 != n) {
                    nArray2[n3++] = n2;
                    nArray2[n3++] = LOWER_CASE_MATCH;
                    nArray = CaseInsensitiveMap.getMapping(n2);
                    if (nArray != null) {
                        nArray2 = CaseInsensitiveMap.updateMap(n, nArray2, n2, nArray, LOWER_CASE_MATCH);
                    }
                }
                if (c != n) {
                    if (n3 == nArray2.length) {
                        nArray2 = CaseInsensitiveMap.expandMap(nArray2, 2);
                    }
                    nArray2[n3++] = c;
                    nArray2[n3++] = UPPER_CASE_MATCH;
                    nArray = CaseInsensitiveMap.getMapping(c);
                    if (nArray != null) {
                        nArray2 = CaseInsensitiveMap.updateMap(n, nArray2, c, nArray, UPPER_CASE_MATCH);
                    }
                }
                CaseInsensitiveMap.set(n, nArray2);
            }
            ++n;
        }
    }

    private static int[] expandMap(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + n];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private static void set(int n, int[] nArray) {
        int n2 = n >>> CHUNK_SHIFT;
        int n3 = n & CHUNK_MASK;
        CaseInsensitiveMap.caseInsensitiveMap[n2][n3] = nArray;
    }

    private static int[] updateMap(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = 0;
        while (n4 < nArray2.length) {
            int n5 = nArray2[n4];
            int[] nArray3 = CaseInsensitiveMap.getMapping(n5);
            if (nArray3 != null && CaseInsensitiveMap.contains(nArray3, n2, n3)) {
                if (!CaseInsensitiveMap.contains(nArray3, n)) {
                    nArray3 = CaseInsensitiveMap.expandAndAdd(nArray3, n, n3);
                    CaseInsensitiveMap.set(n5, nArray3);
                }
                if (!CaseInsensitiveMap.contains(nArray, n5)) {
                    nArray = CaseInsensitiveMap.expandAndAdd(nArray, n5, n3);
                }
            }
            n4 += 2;
        }
        if (!CaseInsensitiveMap.contains(nArray2, n)) {
            nArray2 = CaseInsensitiveMap.expandAndAdd(nArray2, n, n3);
            CaseInsensitiveMap.set(n2, nArray2);
        }
        return nArray;
    }

    private static boolean contains(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    private static boolean contains(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n && nArray[n3 + 1] == n2) {
                return true;
            }
            n3 += 2;
        }
        return false;
    }

    private static int[] expandAndAdd(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + 2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        nArray2[n3] = n;
        nArray2[n3 + 1] = n2;
        return nArray2;
    }

    static {
        LOWER_CASE_MATCH = 1;
        UPPER_CASE_MATCH = 2;
        CaseInsensitiveMap.buildCaseInsensitiveMap();
    }
}

