'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetUpdatedMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetUpdatedMap \-  Update the client or server map information in an existing
keyboard description
.SH SYNOPSIS
.HP
.B Status XkbGetUpdatedMap
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to X server
.TP
.I which
mask selecting subcomponents to populate
.TP
.I xkb
keyboard description to be updated
.SH DESCRIPTION
.LP
The
.I which
parameter is a bitwise inclusive OR of the masks in Table 1. If the needed
components of the
.I xkb
structure are not already allocated,
.I XkbGetUpdatedMap
allocates them.
.I XkbGetUpdatedMap
fetches the requested information for the device specified in the XkbDescRec
passed in the
.I xkb
parameter.

.TS
c s s s s
c s s s s
l l l l l
l l l l l
lw(3i) l l lw(1i) lw(3i).
Table 1 Xkb Mapping Component Masks
and Convenience Functions
_
Mask	Value	Map	Fields	Convenience
				Functions
_
T{
XkbKeyTypesMask
T}	(1<<0)	client	T{
types
.br
size_types
.br
num_types
T}	T{
XkbGetKeyTypes
.br
XkbResizeKeyType
.br
XkbCopyKeyType
.br
XkbCopyKeyTypes
T}
T{
XkbKeySymsMask
T}	(1<<1)	client	T{
syms
.br
size_syms
.br
num_syms
.br
key_sym_map
T}	T{
XkbGetKeySyms
.br
XkbResizeKeySyms
.br
XkbChangeTypesOfKey
T}
T{
XkbModifierMapMask
T}	(1<<2)	client	modmap	T{
XkbGetKeyModifierMap
T}
T{
XkbExplicitComponentsMask
T}	(1<<3)	server	T{
explicit
T}	T{
XkbGetKeyExplicitComponents
T}
T{
XkbKeyActionsMask
T}	(1<<4)	server	T{
key_acts
.br
acts
.br
num_acts
.br
size_acts
T}	T{
XkbGetKeyActions
.br
XkbResizeKeyActions
T}
T{
XkbKeyBehaviorsMask
T}	(1<<5)	server	T{
behaviors
T}	T{
XkbGetKeyBehaviors
T}
T{
XkbVirtualModsMask
T}	(1<<6)	server	T{
vmods
T}	T{
XkbGetVirtualMods
T}
T{
XkbVirtualModMapMask
T}	(1<<7)	server	T{
vmodmap
T}	T{
XkbGetVirtualModMap
T}
.TE

.I XkbGetUpdatedMap
is synchronous; it queries the server for the desired information, waits for a
reply, and then returns. If successful,
.I XkbGetUpdatedMap
returns Success. If unsuccessful,
.I XkbGetUpdatedMap
returns one of the following: BadAlloc (unable to allocate a component in the
XkbDescRec structure), BadValue (some mask bits in
.I which
are undefined), BadImplementation (a compatible version of the Xkb extension is
not available in the server or the reply from the server was invalid).
.SH "RETURN VALUES"
.TP 15
Success
The
.I XkbGetUpdatedMap
function returns Success if a reply is received to the server query for the desired information.
.SH STRUCTURES
.LP
The complete description of an Xkb keyboard is given by an XkbDescRec. The
component
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\&* connection to X server */
   unsigned short     flags;        /\&* private to Xkb, do not modify */
   unsigned short     device_spec;  /\&* device of interest */
   KeyCode            min_key_code; /\&* minimum keycode for device */
   KeyCode            max_key_code; /\&* maximum keycode for device */
   XkbControlsPtr     ctrls;        /\&* controls */
   XkbServerMapPtr    server;       /\&* server keymap */
   XkbClientMapPtr    map;          /\&* client keymap */
   XkbIndicatorPtr    indicators;   /\&* indicator map */
   XkbNamesPtr        names;        /\&* names for all components */
   XkbCompatMapPtr    compat;       /\&* compatibility map */
   XkbGeometryPtr     geom;         /\&* physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The
.I display
field points to an X display structure. The
.I flags
field is private to the library: modifying
.I flags
may yield unpredictable results. The
.I device_spec
field specifies the device identifier of the keyboard input device, or
XkbUseCoreKeyboard, which specifies the core keyboard device. The
.I min_key_code
and
.I max_key_code
fields specify the least and greatest keycode that can be returned by the
keyboard.

Each structure component has a corresponding mask bit that is used in function
calls to
indicate that the structure should be manipulated in some manner, such as
allocating it
or freeing it. These masks and their relationships to the fields in the
XkbDescRec are
shown in Table 2.
.bp
.TS
c s s
l l l
l l l.
Table 2 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadImplementation
Invalid reply from server
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbChangeTypesOfKey (__libmansuffix__),
.BR XkbCopyKeyType (__libmansuffix__),
.BR XkbCopyKeyTypes (__libmansuffix__),
.BR XkbGetKeyActions (__libmansuffix__),
.BR XkbGetKeyBehaviors (__libmansuffix__),
.BR XkbGetKeyExplicitComponents (__libmansuffix__),
.BR XkbGetKeyModifierMap (__libmansuffix__),
.BR XkbGetKeySyms (__libmansuffix__),
.BR XkbGetKeyTypes (__libmansuffix__),
.BR XkbResizeKeyActions (__libmansuffix__),
.BR XkbResizeKeySyms (__libmansuffix__),
.BR XkbResizeKeyType (__libmansuffix__),
.BR XkbGetVirtualModMap (__libmansuffix__),
.BR XkbGetVirtualMods (__libmansuffix__)
