/*

+
 Copyright (c) 1987, 1994 Digital Equipment Corporation

 The X Consortium, and any party obtaining a copy of these files from
 the X Consortium, directly or indirectly, is granted, free of charge, a
 full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 nonexclusive right and license to deal in this software and
 documentation files (the "Software"), including without limitation the
 rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons who receive
 copies from any such party to do so.  This license includes without
 limitation a license to do the foregoing actions under any patents of
 the party supplying this software to the X Consortium.

 Digital Equipment Corporation make no representations about the
 suitability of this software for any purpose.  It is provided "as
 is" without express or implied warranty.
-
*/

static u_char Terminal_8x13_data[];

static struct wsdisplay_font Terminal_8x13 = {
	"Terminal",			/* typeface name */
	32,				/* firstchar */
	224,				/* numchars */
	0,				/* encoding */
	8,				/* fontwidth */
	13,				/* fontheight */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	Terminal_8x13_data		/* data */
};

static u_char Terminal_8x13_data[] = {
	/* 32 space */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 33 exclam */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 34 quotedbl */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 35 numbersign */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x7e, /* . [][][][][][].  */
0x24, /* . . []. . []. .  */
0x7e, /* . [][][][][][].  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 36 dollar */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x1c, /* . . . [][][]. .  */
0x2a, /* . . []. []. [].  */
0x18, /* . . . [][]. . .  */
0x0c, /* . . . . [][]. .  */
0x2a, /* . . []. []. [].  */
0x1c, /* . . . [][][]. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 37 percent */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x5c, /* . []. [][][]. .  */
0x28, /* . . []. []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x14, /* . . . []. []. .  */
0x2a, /* . . []. []. [].  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 38 ampersand */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x28, /* . . []. []. . .  */
0x28, /* . . []. []. . .  */
0x10, /* . . . []. . . .  */
0x2a, /* . . []. []. [].  */
0x44, /* . []. . . []. .  */
0x44, /* . []. . . []. .  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 39 quoteright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 40 parenleft */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
	/* 41 parenright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
	/* 42 asterisk */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x2a, /* . . []. []. [].  */
0x1c, /* . . . [][][]. .  */
0x1c, /* . . . [][][]. .  */
0x2a, /* . . []. []. [].  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 43 plus */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 44 comma */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
	/* 45 minus */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 46 period */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 47 slash */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
	/* 48 zero */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 49 one */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x18, /* . . . [][]. . .  */
0x28, /* . . []. []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 50 two */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x02, /* . . . . . . [].  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 51 three */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x02, /* . . . . . . [].  */
0x0c, /* . . . . [][]. .  */
0x02, /* . . . . . . [].  */
0x02, /* . . . . . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 52 four */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x0c, /* . . . . [][]. .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x24, /* . . []. . []. .  */
0x3e, /* . . [][][][][].  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 53 five */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x22, /* . . []. . . [].  */
0x02, /* . . . . . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 54 six */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x0c, /* . . . . [][]. .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 55 seven */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x02, /* . . . . . . [].  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 56 eight */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 57 nine */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1e, /* . . . [][][][].  */
0x02, /* . . . . . . [].  */
0x04, /* . . . . . []. .  */
0x18, /* . . . [][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 58 colon */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 59 semicolon */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
	/* 60 less */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 61 equal */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 62 greater */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 63 question */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x38, /* . . [][][]. . .  */
0x44, /* . []. . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 64 at */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x4e, /* . []. . [][][].  */
0x52, /* . []. []. . [].  */
0x52, /* . []. []. . [].  */
0x4e, /* . []. . [][][].  */
0x40, /* . []. . . . . .  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 65 A */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 66 B */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 67 C */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 68 D */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 69 E */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 70 F */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 71 G */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x4e, /* . []. . [][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 72 H */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 73 I */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 74 J */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1e, /* . . . [][][][].  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x44, /* . []. . . []. .  */
0x38, /* . . [][][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 75 K */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x22, /* . . []. . . [].  */
0x24, /* . . []. . []. .  */
0x28, /* . . []. []. . .  */
0x30, /* . . [][]. . . .  */
0x30, /* . . [][]. . . .  */
0x28, /* . . []. []. . .  */
0x24, /* . . []. . []. .  */
0x22, /* . . []. . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 76 L */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 77 M */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x63, /* . [][]. . . [][] */
0x55, /* . []. []. []. [] */
0x55, /* . []. []. []. [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 78 N */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x62, /* . [][]. . . [].  */
0x52, /* . []. []. . [].  */
0x52, /* . []. []. . [].  */
0x4a, /* . []. . []. [].  */
0x4a, /* . []. . []. [].  */
0x46, /* . []. . . [][].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 79 O */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 80 P */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 81 Q */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x52, /* . []. []. . [].  */
0x4a, /* . []. . []. [].  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x00, /* . . . . . . . .  */
	/* 82 R */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x48, /* . []. . []. . .  */
0x44, /* . []. . . []. .  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 83 S */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x02, /* . . . . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 84 T */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 85 U */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 86 V */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 87 W */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x36, /* . . [][]. [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 88 X */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x63, /* . [][]. . . [][] */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x14, /* . . . []. []. .  */
0x22, /* . . []. . . [].  */
0x63, /* . [][]. . . [][] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 89 Y */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 90 Z */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x02, /* . . . . . . [].  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x40, /* . []. . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 91 bracketleft */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
	/* 92 backslash */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
	/* 93 bracketright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x38, /* . . [][][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x38, /* . . [][][]. . .  */
0x00, /* . . . . . . . .  */
	/* 94 asciicircum */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x14, /* . . . []. []. .  */
0x22, /* . . []. . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 95 underscore */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 96 quoteleft */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 97 a */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 98 b */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x5c, /* . []. [][][]. .  */
0x62, /* . [][]. . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 99 c */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 100 d */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x02, /* . . . . . . [].  */
0x02, /* . . . . . . [].  */
0x3a, /* . . [][][]. [].  */
0x46, /* . []. . . [][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 101 e */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 102 f */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x0e, /* . . . . [][][].  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x3c, /* . . [][][][]. .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 103 g */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x38, /* . . [][][]. . .  */
0x44, /* . []. . . []. .  */
0x44, /* . []. . . []. .  */
0x38, /* . . [][][]. . .  */
0x40, /* . []. . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
	/* 104 h */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x5c, /* . []. [][][]. .  */
0x62, /* . [][]. . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 105 i */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x38, /* . . [][][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 106 j */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x04, /* . . . . . []. .  */
0x44, /* . []. . . []. .  */
0x38, /* . . [][][]. . .  */
	/* 107 k */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x44, /* . []. . . []. .  */
0x48, /* . []. . []. . .  */
0x70, /* . [][][]. . . .  */
0x48, /* . []. . []. . .  */
0x44, /* . []. . . []. .  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 108 l */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x38, /* . . [][][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 109 m */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x76, /* . [][][]. [][].  */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 110 n */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x5c, /* . []. [][][]. .  */
0x62, /* . [][]. . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 111 o */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 112 p */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x5c, /* . []. [][][]. .  */
0x62, /* . [][]. . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
	/* 113 q */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x02, /* . . . . . . [].  */
0x02, /* . . . . . . [].  */
	/* 114 r */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x6e, /* . [][]. [][][].  */
0x32, /* . . [][]. . [].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 115 s */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 116 t */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x3c, /* . . [][][][]. .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x12, /* . . . []. . [].  */
0x0c, /* . . . . [][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 117 u */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 118 v */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 119 w */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x49, /* . []. . []. . [] */
0x36, /* . . [][]. [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 120 x */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x66, /* . [][]. . [][].  */
0x24, /* . . []. . []. .  */
0x18, /* . . . [][]. . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x66, /* . [][]. . [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 121 y */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x63, /* . [][]. . . [][] */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x0c, /* . . . . [][]. .  */
0x08, /* . . . . []. . .  */
0x48, /* . []. . []. . .  */
0x30, /* . . [][]. . . .  */
	/* 122 z */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 123 braceleft */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x0c, /* . . . . [][]. .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x30, /* . . [][]. . . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x0c, /* . . . . [][]. .  */
0x00, /* . . . . . . . .  */
	/* 124 bar */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
	/* 125 braceright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x30, /* . . [][]. . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x0c, /* . . . . [][]. .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x30, /* . . [][]. . . .  */
0x00, /* . . . . . . . .  */
	/* 126 asciitilde */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x32, /* . . [][]. . [].  */
0x4c, /* . []. . [][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 127 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 128 OE */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3f, /* . . [][][][][][] */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x4e, /* . []. . [][][].  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x3f, /* . . [][][][][][] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 129 oe */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x36, /* . . [][]. [][].  */
0x49, /* . []. . []. . [] */
0x4f, /* . []. . [][][][] */
0x48, /* . []. . []. . .  */
0x49, /* . []. . []. . [] */
0x36, /* . . [][]. [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 130 Ydieresis */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 131 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 132 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 133 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 134 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 135 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 136 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 137 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 138 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 139 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 140 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 141 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 142 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 143 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 144 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 145 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 146 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 147 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 148 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 149 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 150 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 151 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 152 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 153 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 154 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 155 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 156 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 157 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 158 */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 159 Error */
0x3c, /* . . [][][][]. .  */
0x66, /* . [][]. . [][].  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x60, /* . [][]. . . . .  */
0x30, /* . . [][]. . . .  */
0x18, /* . . . [][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
	/* 160 space */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 161 exclamdown */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
	/* 162 cent */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x1c, /* . . . [][][]. .  */
0x2a, /* . . []. []. [].  */
0x28, /* . . []. []. . .  */
0x2a, /* . . []. []. [].  */
0x1c, /* . . . [][][]. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 163 sterling */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x0c, /* . . . . [][]. .  */
0x12, /* . . . []. . [].  */
0x12, /* . . . []. . [].  */
0x10, /* . . . []. . . .  */
0x3c, /* . . [][][][]. .  */
0x10, /* . . . []. . . .  */
0x31, /* . . [][]. . . [] */
0x6e, /* . [][]. [][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 164 currency */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 165 yen */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 166 brokenbar */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
	/* 167 section */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x20, /* . . []. . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x02, /* . . . . . . [].  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
	/* 168 dieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 169 copyright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x41, /* . []. . . . . [] */
0x4d, /* . []. . [][]. [] */
0x51, /* . []. []. . . [] */
0x51, /* . []. []. . . [] */
0x4d, /* . []. . [][]. [] */
0x41, /* . []. . . . . [] */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 170 ordfeminine */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x30, /* . . [][]. . . .  */
0x08, /* . . . . []. . .  */
0x38, /* . . [][][]. . .  */
0x48, /* . []. . []. . .  */
0x38, /* . . [][][]. . .  */
0x00, /* . . . . . . . .  */
0x78, /* . [][][][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 171 guillemotleft */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x12, /* . . . []. . [].  */
0x24, /* . . []. . []. .  */
0x48, /* . []. . []. . .  */
0x24, /* . . []. . []. .  */
0x12, /* . . . []. . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 172 logicalnot */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x02, /* . . . . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 173 hyphen */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 174 registered */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x41, /* . []. . . . . [] */
0x59, /* . []. [][]. . [] */
0x55, /* . []. []. []. [] */
0x59, /* . []. [][]. . [] */
0x55, /* . []. []. []. [] */
0x41, /* . []. . . . . [] */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 175 macron */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7e, /* . [][][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 176 degree */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x28, /* . . []. []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 177 plusminus */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 178 twosuperior */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 179 threesuperior */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x08, /* . . . . []. . .  */
0x04, /* . . . . . []. .  */
0x24, /* . . []. . []. .  */
0x18, /* . . . [][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 180 acute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 181 mu */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x12, /* . . . []. . [].  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0xb6, /* []. [][]. [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 182 paragraph */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x74, /* . [][][]. []. .  */
0x74, /* . [][][]. []. .  */
0x74, /* . [][][]. []. .  */
0x34, /* . . [][]. []. .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
	/* 183 periodcentered */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 184 cedilla */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x18, /* . . . [][]. . .  */
	/* 185 onesuperior */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x30, /* . . [][]. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x10, /* . . . []. . . .  */
0x38, /* . . [][][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 186 ordmasculine */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x30, /* . . [][]. . . .  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x30, /* . . [][]. . . .  */
0x00, /* . . . . . . . .  */
0x78, /* . [][][][]. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 187 guillemotright */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x48, /* . []. . []. . .  */
0x24, /* . . []. . []. .  */
0x12, /* . . . []. . [].  */
0x24, /* . . []. . []. .  */
0x48, /* . []. . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 188 onequarter */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x60, /* . [][]. . . . .  */
0x22, /* . . []. . . [].  */
0x24, /* . . []. . []. .  */
0x78, /* . [][][][]. . .  */
0x12, /* . . . []. . [].  */
0x26, /* . . []. . [][].  */
0x4a, /* . []. . []. [].  */
0x1f, /* . . . [][][][][] */
0x02, /* . . . . . . [].  */
0x00, /* . . . . . . . .  */
	/* 189 onehalf */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x20, /* . . []. . . . .  */
0x60, /* . [][]. . . . .  */
0x22, /* . . []. . . [].  */
0x24, /* . . []. . []. .  */
0x78, /* . [][][][]. . .  */
0x16, /* . . . []. [][].  */
0x29, /* . . []. []. . [] */
0x42, /* . []. . . . [].  */
0x04, /* . . . . . []. .  */
0x0f, /* . . . . [][][][] */
0x00, /* . . . . . . . .  */
	/* 190 threequarters */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x30, /* . . [][]. . . .  */
0x48, /* . []. . []. . .  */
0x10, /* . . . []. . . .  */
0x4a, /* . []. . []. [].  */
0x34, /* . . [][]. []. .  */
0x0a, /* . . . . []. [].  */
0x16, /* . . . []. [][].  */
0x2a, /* . . []. []. [].  */
0x5f, /* . []. [][][][][] */
0x02, /* . . . . . . [].  */
0x00, /* . . . . . . . .  */
	/* 191 questiondown */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
	/* 192 Agrave */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 193 Aacute */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 194 Acircumflex */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 195 Atilde */
0x32, /* . . [][]. . [].  */
0x4c, /* . []. . [][]. .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 196 Adieresis */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 197 Aring */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x18, /* . . . [][]. . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 198 AE */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1f, /* . . . [][][][][] */
0x28, /* . . []. []. . .  */
0x28, /* . . []. []. . .  */
0x4e, /* . []. . [][][].  */
0x78, /* . [][][][]. . .  */
0x48, /* . []. . []. . .  */
0x48, /* . []. . []. . .  */
0x4f, /* . []. . [][][][] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 199 Ccedilla */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
	/* 200 Egrave */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 201 Eacute */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 202 Ecircumflex */
0x0c, /* . . . . [][]. .  */
0x12, /* . . . []. . [].  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 203 Edieresis */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x20, /* . . []. . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 204 Igrave */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 205 Iacute */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 206 Icircumflex */
0x08, /* . . . . []. . .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 207 Idieresis */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 208 Eth */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x7c, /* . [][][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0xf2, /* [][][][]. . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x7c, /* . [][][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 209 Ntilde */
0x32, /* . . [][]. . [].  */
0x4c, /* . []. . [][]. .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x62, /* . [][]. . . [].  */
0x52, /* . []. []. . [].  */
0x52, /* . []. []. . [].  */
0x4a, /* . []. . []. [].  */
0x4a, /* . []. . []. [].  */
0x46, /* . []. . . [][].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 210 Ograve */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 211 Oacute */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 212 Ocircumflex */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 213 Otilde */
0x32, /* . . [][]. . [].  */
0x4c, /* . []. . [][]. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 214 Odieresis */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 215 multiply */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x14, /* . . . []. []. .  */
0x22, /* . . []. . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 216 Oslash */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3d, /* . . [][][][]. [] */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x4a, /* . []. . []. [].  */
0x4a, /* . []. . []. [].  */
0x52, /* . []. []. . [].  */
0x62, /* . [][]. . . [].  */
0x7c, /* . [][][][][]. .  */
0x80, /* []. . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 217 Ugrave */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 218 Uacute */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 219 Ucircumflex */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 220 Udieresis */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 221 Yacute */
0x0c, /* . . . . [][]. .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x41, /* . []. . . . . [] */
0x41, /* . []. . . . . [] */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 222 Thorn */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x70, /* . [][][]. . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x70, /* . [][][]. . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 223 germandbls */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x64, /* . [][]. . []. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x6c, /* . [][]. [][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 224 agrave */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 225 aacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 226 acircumflex */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 227 atilde */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1a, /* . . . [][]. [].  */
0x2c, /* . . []. [][]. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 228 adieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x12, /* . . . []. . [].  */
0x12, /* . . . []. . [].  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 229 aring */
0x00, /* . . . . . . . .  */
0x1c, /* . . . [][][]. .  */
0x22, /* . . []. . . [].  */
0x1c, /* . . . [][][]. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x02, /* . . . . . . [].  */
0x3e, /* . . [][][][][].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3d, /* . . [][][][]. [] */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 230 ae */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x76, /* . [][][]. [][].  */
0x09, /* . . . . []. . [] */
0x3f, /* . . [][][][][][] */
0x48, /* . []. . []. . .  */
0x49, /* . []. . []. . [] */
0x36, /* . . [][]. [][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 231 ccedilla */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x40, /* . []. . . . . .  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x10, /* . . . []. . . .  */
0x20, /* . . []. . . . .  */
	/* 232 egrave */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 233 eacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 234 ecircumflex */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 235 edieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x7e, /* . [][][][][][].  */
0x40, /* . []. . . . . .  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 236 igrave */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 237 iacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 238 icircumflex */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 239 idieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 240 eth */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x48, /* . []. . []. . .  */
0x30, /* . . [][]. . . .  */
0x30, /* . . [][]. . . .  */
0x48, /* . []. . []. . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 241 ntilde */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1a, /* . . . [][]. [].  */
0x2c, /* . . []. [][]. .  */
0x00, /* . . . . . . . .  */
0x5c, /* . []. [][][]. .  */
0x62, /* . [][]. . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 242 ograve */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 243 oacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 244 ocircumflex */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 245 otilde */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x1a, /* . . . [][]. [].  */
0x2c, /* . . []. [][]. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 246 odieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x3c, /* . . [][][][]. .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x3c, /* . . [][][][]. .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 247 divide */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x3e, /* . . [][][][][].  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 248 oslash */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x01, /* . . . . . . . [] */
0x3e, /* . . [][][][][].  */
0x46, /* . []. . . [][].  */
0x4a, /* . []. . []. [].  */
0x52, /* . []. []. . [].  */
0x62, /* . [][]. . . [].  */
0x7c, /* . [][][][][]. .  */
0x80, /* []. . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 249 ugrave */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x10, /* . . . []. . . .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 250 uacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x08, /* . . . . []. . .  */
0x10, /* . . . []. . . .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 251 ucircumflex */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x18, /* . . . [][]. . .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 252 udieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x24, /* . . []. . []. .  */
0x24, /* . . []. . []. .  */
0x00, /* . . . . . . . .  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x42, /* . []. . . . [].  */
0x46, /* . []. . . [][].  */
0x3a, /* . . [][][]. [].  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
	/* 253 yacute */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x04, /* . . . . . []. .  */
0x08, /* . . . . []. . .  */
0x00, /* . . . . . . . .  */
0x63, /* . [][]. . . [][] */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x0c, /* . . . . [][]. .  */
0x08, /* . . . . []. . .  */
0x48, /* . []. . []. . .  */
0x30, /* . . [][]. . . .  */
	/* 254 thorn */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x70, /* . [][][]. . . .  */
0x20, /* . . []. . . . .  */
0x3c, /* . . [][][][]. .  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x3c, /* . . [][][][]. .  */
0x20, /* . . []. . . . .  */
0x70, /* . [][][]. . . .  */
	/* 255 ydieresis */
0x00, /* . . . . . . . .  */
0x00, /* . . . . . . . .  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x00, /* . . . . . . . .  */
0x63, /* . [][]. . . [][] */
0x22, /* . . []. . . [].  */
0x22, /* . . []. . . [].  */
0x14, /* . . . []. []. .  */
0x14, /* . . . []. []. .  */
0x08, /* . . . . []. . .  */
0x48, /* . []. . []. . .  */
0x30, /* . . [][]. . . .  */
};
