.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Error-Msg XtApp-Set-Error-Msg-Handler
.hw XtApp-Set-Warning-Msg-Handler XtApp-Warning-Msg wid-get
.na
.TH XtAppErrorMsg __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppErrorMsg, XtAppSetErrorMsgHandler, XtAppSetWarningMsgHandler, XtAppWarningMsg \- high-level error handlers
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
_X_NORETURN void XtAppErrorMsg(XtAppContext \fIapp_context\fP, const char *\fIname\fP,
const char *\fItype\fP, const char *\fIclass\fP, const char *\fIdefaultMsg\fP,
String *\fIparams\fP, Cardinal *\fInum_params\fP);
.HP
XtErrorMsgHandler XtAppSetErrorMsgHandler(XtAppContext \fIapp_context\fP, _X_NORETURN XtErrorMsgHandler
\fImsg_handler\fP);
.HP
XtErrorMsgHandler XtAppSetWarningMsgHandler(XtAppContext \fIapp_context\fP,
XtErrorMsgHandler \fImsg_handler\fP);
.HP
void XtAppWarningMsg(XtAppContext \fIapp_context\fP, const char *\fIname\fP,
const char *\fItype\fP, const char *\fIclass\fP, const char *\fIdefaultMsg\fP,
String *\fIparams\fP, Cardinal *\fInum_params\fP);
.SH ARGUMENTS
.IP \fIapp_context\fP 1i
Specifies the application context.
.IP \fIclass\fP 1i
Specifies the resource class of the error message.
.IP \fIdefaultMsg\fP 1i
Specifies the default message to use.
.IP \fIname\fP 1i
Specifies the general kind of error.
.IP \fItype\fP 1i
Specifies the detailed name of the error.
.IP \fImsg_handler\fP 1i
Specifies the new fatal error procedure, which should not return \
or the nonfatal error procedure, which usually returns.
.IP \fInum_params\fP 1i
Specifies the number of values in the parameter list.
.IP \fIparams\fP 1i
Specifies a pointer to a list of values to be stored in the message.
.SH DESCRIPTION
The
.B XtAppErrorMsg
function calls the high-level error handler and passes the specified
information.
.LP
The
.B XtAppSetErrorMsgHandler
function registers the specified  procedure,
which is called when a fatal error occurs.
.LP
The
.B XtAppSetWarningMsgHandler
function registers the specified procedure,
which is called when a nonfatal error condition occurs.
.LP
The
.B XtAppWarningMsg
function calls the high-level error handler and passes the specified
information.
.SH "SEE ALSO"
XtAppGetErrorDatabase(__libmansuffix__),
XtAppError(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
