/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.util.NoSuchElementException;

public class FlatteningPathIterator
implements PathIterator {
    private final PathIterator srcIter;
    private final double flatnessSq;
    private final int recursionLimit;
    private double[] stack;
    private int stackSize;
    private int[] recLevel;
    private final double[] scratch;
    private int srcSegType;
    private double srcPosX;
    private double srcPosY;
    private boolean done;

    private /* synthetic */ void finit$() {
        this.scratch = new double[6];
    }

    public FlatteningPathIterator(PathIterator src, double flatness) {
        this(src, flatness, 10);
    }

    public FlatteningPathIterator(PathIterator src, double flatness, int limit) {
        this.finit$();
        if (flatness < 0.0 || limit < 0) {
            throw new IllegalArgumentException();
        }
        this.srcIter = src;
        double d = flatness;
        this.flatnessSq = d * d;
        this.recursionLimit = limit;
        this.fetchSegment();
    }

    public double getFlatness() {
        return Math.sqrt(this.flatnessSq);
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    public int getWindingRule() {
        return this.srcIter.getWindingRule();
    }

    public boolean isDone() {
        return this.done;
    }

    public void next() {
        if (this.stackSize > 0) {
            --this.stackSize;
            if (this.stackSize > 0) {
                switch (this.srcSegType) {
                    case 2: {
                        this.subdivideQuadratic();
                        return;
                    }
                    case 3: {
                        this.subdivideCubic();
                        return;
                    }
                }
                throw new IllegalStateException();
            }
        }
        this.srcIter.next();
        this.fetchSegment();
    }

    public int currentSegment(double[] coords) {
        if (this.done) {
            throw new NoSuchElementException();
        }
        switch (this.srcSegType) {
            case 4: {
                return this.srcSegType;
            }
            case 0: 
            case 1: {
                coords[0] = this.srcPosX;
                coords[1] = this.srcPosY;
                return this.srcSegType;
            }
            case 2: {
                if (this.stackSize == 0) {
                    coords[0] = this.srcPosX;
                    coords[1] = this.srcPosY;
                } else {
                    int sp = this.stack.length - 4 * this.stackSize;
                    coords[0] = this.stack[sp + 2];
                    coords[1] = this.stack[sp + 3];
                }
                return 1;
            }
            case 3: {
                if (this.stackSize == 0) {
                    coords[0] = this.srcPosX;
                    coords[1] = this.srcPosY;
                } else {
                    int sp = this.stack.length - 6 * this.stackSize;
                    coords[0] = this.stack[sp + 4];
                    coords[1] = this.stack[sp + 5];
                }
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    public int currentSegment(float[] coords) {
        if (this.done) {
            throw new NoSuchElementException();
        }
        switch (this.srcSegType) {
            case 4: {
                return this.srcSegType;
            }
            case 0: 
            case 1: {
                coords[0] = (float)this.srcPosX;
                coords[1] = (float)this.srcPosY;
                return this.srcSegType;
            }
            case 2: {
                if (this.stackSize == 0) {
                    coords[0] = (float)this.srcPosX;
                    coords[1] = (float)this.srcPosY;
                } else {
                    int sp = this.stack.length - 4 * this.stackSize;
                    coords[0] = (float)this.stack[sp + 2];
                    coords[1] = (float)this.stack[sp + 3];
                }
                return 1;
            }
            case 3: {
                if (this.stackSize == 0) {
                    coords[0] = (float)this.srcPosX;
                    coords[1] = (float)this.srcPosY;
                } else {
                    int sp = this.stack.length - 6 * this.stackSize;
                    coords[0] = (float)this.stack[sp + 4];
                    coords[1] = (float)this.stack[sp + 5];
                }
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    private void fetchSegment() {
        if (this.srcIter.isDone()) {
            this.done = true;
            return;
        }
        this.srcSegType = this.srcIter.currentSegment(this.scratch);
        switch (this.srcSegType) {
            case 4: {
                return;
            }
            case 0: 
            case 1: {
                this.srcPosX = this.scratch[0];
                this.srcPosY = this.scratch[1];
                return;
            }
            case 2: {
                if (this.recursionLimit == 0) {
                    this.srcPosX = this.scratch[2];
                    this.srcPosY = this.scratch[3];
                    this.stackSize = 0;
                    return;
                }
                int sp = 4 * this.recursionLimit;
                this.stackSize = 1;
                if (this.stack == null) {
                    this.stack = new double[sp + 6];
                    this.recLevel = new int[this.recursionLimit + 1];
                }
                this.recLevel[0] = 0;
                this.stack[sp] = this.srcPosX;
                this.stack[sp + 1] = this.srcPosY;
                this.stack[sp + 2] = this.scratch[0];
                this.stack[sp + 3] = this.scratch[1];
                double d = this.scratch[2];
                this.stack[sp + 4] = d;
                this.srcPosX = d;
                double d2 = this.scratch[3];
                this.stack[sp + 5] = d2;
                this.srcPosY = d2;
                this.subdivideQuadratic();
                break;
            }
            case 3: {
                if (this.recursionLimit == 0) {
                    this.srcPosX = this.scratch[4];
                    this.srcPosY = this.scratch[5];
                    this.stackSize = 0;
                    return;
                }
                int sp = 6 * this.recursionLimit;
                this.stackSize = 1;
                if (this.stack == null || this.stack.length < sp + 8) {
                    this.stack = new double[sp + 8];
                    this.recLevel = new int[this.recursionLimit + 1];
                }
                this.recLevel[0] = 0;
                this.stack[sp] = this.srcPosX;
                this.stack[sp + 1] = this.srcPosY;
                this.stack[sp + 2] = this.scratch[0];
                this.stack[sp + 3] = this.scratch[1];
                this.stack[sp + 4] = this.scratch[2];
                this.stack[sp + 5] = this.scratch[3];
                double d = this.scratch[4];
                this.stack[sp + 6] = d;
                this.srcPosX = d;
                double d3 = this.scratch[5];
                this.stack[sp + 7] = d3;
                this.srcPosY = d3;
                this.subdivideCubic();
                return;
            }
        }
    }

    private void subdivideQuadratic() {
        int sp = this.stack.length - 4 * this.stackSize - 2;
        int level = this.recLevel[this.stackSize - 1];
        while (level < this.recursionLimit && QuadCurve2D.getFlatnessSq(this.stack, sp) >= this.flatnessSq) {
            int n = ++level;
            this.recLevel[this.stackSize - 1] = n;
            this.recLevel[this.stackSize] = n;
            QuadCurve2D.subdivide(this.stack, sp, this.stack, sp - 4, this.stack, sp);
            ++this.stackSize;
            sp -= 4;
        }
    }

    private void subdivideCubic() {
        int sp = this.stack.length - 6 * this.stackSize - 2;
        int level = this.recLevel[this.stackSize - 1];
        while (level < this.recursionLimit && CubicCurve2D.getFlatnessSq(this.stack, sp) >= this.flatnessSq) {
            int n = ++level;
            this.recLevel[this.stackSize - 1] = n;
            this.recLevel[this.stackSize] = n;
            CubicCurve2D.subdivide(this.stack, sp, this.stack, sp - 6, this.stack, sp);
            ++this.stackSize;
            sp -= 6;
        }
    }
}

