/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.util.DoubleEnumeration;
import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassLoader {
    final Map loadedClasses;
    final Map definedPackages;
    private final ClassLoader parent;
    private final boolean initialized;
    static final ClassLoader systemClassLoader = VMClassLoader.getSystemClassLoader();
    static final ProtectionDomain defaultProtectionDomain;
    boolean defaultAssertionStatus;
    static final Map systemPackageAssertionStatus;
    Map packageAssertionStatus;
    static final Map systemClassAssertionStatus;
    Map classAssertionStatus;

    private /* synthetic */ void finit$() {
        this.loadedClasses = new HashMap();
        this.definedPackages = new HashMap();
        this.defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
    }

    protected ClassLoader() throws SecurityException {
        this(systemClassLoader);
    }

    protected ClassLoader(ClassLoader parent) {
        this.finit$();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.parent = parent;
        this.initialized = true;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c;
        block6: {
            c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try {
                if (this.parent == null) {
                    c = VMClassLoader.loadClass(name, resolve);
                    if (c != null) {
                        return c;
                    }
                    break block6;
                }
                return this.parent.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        c = this.findClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected final Class defineClass(byte[] data, int offset, int len) throws ClassFormatError {
        return this.defineClass(null, data, offset, len);
    }

    protected final Class defineClass(String name, byte[] data, int offset, int len) throws ClassFormatError {
        return this.defineClass(name, data, offset, len, null);
    }

    protected final synchronized Class defineClass(String name, byte[] data, int offset, int len, ProtectionDomain domain) throws ClassFormatError {
        if (domain == null) {
            domain = defaultProtectionDomain;
        }
        if (!this.initialized) {
            throw new SecurityException("attempt to define class from uninitialized class loader");
        }
        Class retval = VMClassLoader.defineClass(this, name, data, offset, len, domain);
        this.loadedClasses.put(retval.getName(), retval);
        return retval;
    }

    protected final void resolveClass(Class c) {
        VMClassLoader.resolveClass(c);
    }

    protected final Class findSystemClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, systemClassLoader);
    }

    public final ClassLoader getParent() {
        Class c;
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cl = (c = VMSecurityManager.getClassContext()[1]).getClassLoader()) != null && !cl.isAncestorOf(this)) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.parent;
    }

    protected final void setSigners(Class c, Object[] signers) {
        c.setSigners(signers);
    }

    protected final synchronized Class findLoadedClass(String name) {
        return (Class)this.loadedClasses.get(name);
    }

    public URL getResource(String name) {
        URL result = this.parent == null ? VMClassLoader.getResource(name) : this.parent.getResource(name);
        if (result == null) {
            result = this.findResource(name);
        }
        return result;
    }

    public final Enumeration getResources(String name) throws IOException {
        Enumeration parentResources = this.parent == null ? VMClassLoader.getResources(name) : this.parent.getResources(name);
        return new DoubleEnumeration(parentResources, this.findResources(name));
    }

    protected Enumeration findResources(String name) throws IOException {
        return EmptyEnumeration.getInstance();
    }

    protected URL findResource(String name) {
        return null;
    }

    public static final URL getSystemResource(String name) {
        return systemClassLoader.getResource(name);
    }

    public static Enumeration getSystemResources(String name) throws IOException {
        return systemClassLoader.getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final InputStream getSystemResourceAsStream(String name) {
        try {
            URL url = ClassLoader.getSystemResource(name);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        Class c;
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (cl = (c = VMSecurityManager.getClassContext()[1]).getClassLoader()) != null && cl != systemClassLoader) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return systemClassLoader;
    }

    protected Package definePackage(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        if (this.getPackage(name) != null) {
            throw new IllegalArgumentException("Package " + name + " already defined");
        }
        Package p = new Package(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, sealed);
        Map map = this.definedPackages;
        synchronized (map) {
            Package package_;
            try {
                this.definedPackages.put(name, p);
            }
            finally {
                package_ = null;
            }
            package_ = p;
            return package_;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Package getPackage(String name) {
        Package p = this.parent == null ? VMClassLoader.getPackage(name) : this.parent.getPackage(name);
        if (p != null) return p;
        Map map = this.definedPackages;
        synchronized (map) {
            try {
                p = (Package)this.definedPackages.get(name);
                return p;
            }
            finally {
                Package package_ = null;
            }
        }
    }

    protected Package[] getPackages() {
        Map map = this.definedPackages;
        synchronized (map) {
            Object[] packages;
            try {
                packages = new Package[this.definedPackages.size()];
                this.definedPackages.values().toArray(packages);
            }
            finally {
                Object var3_3 = null;
            }
            Package[] parentPackages = this.parent == null ? VMClassLoader.getPackages() : this.parent.getPackages();
            Package[] allPackages = new Package[parentPackages.length + packages.length];
            System.arraycopy(parentPackages, 0, allPackages, 0, parentPackages.length);
            System.arraycopy(packages, 0, allPackages, parentPackages.length, packages.length);
            Package[] packageArray = allPackages;
            return packageArray;
        }
    }

    protected String findLibrary(String name) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.defaultAssertionStatus = enabled;
    }

    public synchronized void setPackageAssertionStatus(String name, boolean enabled) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(name, enabled);
    }

    public synchronized void setClassAssertionStatus(String name, boolean enabled) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(name.toString(), enabled);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    final boolean isAncestorOf(ClassLoader loader) {
        while (loader != null) {
            if (this == loader) {
                return true;
            }
            loader = loader.parent;
        }
        return false;
    }

    static {
        CodeSource cs = new CodeSource(null, null);
        PermissionCollection perm = Policy.getPolicy().getPermissions(cs);
        defaultProtectionDomain = new ProtectionDomain(cs, perm);
        systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
        systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
    }
}

