/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public final class Array {
    private Array() {
    }

    public static native Object newInstance(Class var0, int var1);

    public static native Object newInstance(Class var0, int[] var1);

    public static native int getLength(Object var0);

    public static native Object get(Object var0, int var1);

    public static native boolean getBoolean(Object var0, int var1);

    public static native byte getByte(Object var0, int var1);

    public static native char getChar(Object var0, int var1);

    public static native short getShort(Object var0, int var1);

    public static native int getInt(Object var0, int var1);

    public static native long getLong(Object var0, int var1);

    public static native float getFloat(Object var0, int var1);

    public static native double getDouble(Object var0, int var1);

    private static native Class getElementType(Object var0, int var1);

    private static native void set(Object var0, int var1, Object var2, Class var3);

    public static void set(Object array, int index, Object value) {
        Class elType = Array.getElementType(array, index);
        if (!elType.isPrimitive()) {
            Array.set(array, index, value, elType);
        } else if (value instanceof Byte) {
            Array.setByte(array, index, (Byte)value);
        } else if (value instanceof Short) {
            Array.setShort(array, index, (Short)value);
        } else if (value instanceof Integer) {
            Array.setInt(array, index, (Integer)value);
        } else if (value instanceof Long) {
            Array.setLong(array, index, (Long)value);
        } else if (value instanceof Float) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            Array.setDouble(array, index, (Double)value);
        } else if (value instanceof Character) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (value instanceof Boolean) {
            Array.setBoolean(array, index, (Boolean)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static native void setBoolean(Object var0, int var1, boolean var2);

    public static native void setByte(Object var0, int var1, byte var2);

    public static native void setChar(Object var0, int var1, char var2);

    public static native void setShort(Object var0, int var1, short var2);

    public static native void setInt(Object var0, int var1, int var2);

    public static native void setLong(Object var0, int var1, long var2);

    public static native void setFloat(Object var0, int var1, float var2);

    public static native void setDouble(Object var0, int var1, double var2);
}

