/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock;
    protected boolean newNode;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed;
    private HashMap childCache;

    private /* synthetic */ void finit$() {
        this.lock = new Object();
        this.newNode = false;
        this.removed = false;
        this.childCache = new HashMap();
    }

    protected AbstractPreferences(AbstractPreferences parent, String name) {
        this.finit$();
        if (name == null || name.length() > 80 || parent == null && name.length() != 0 || parent != null && name.length() == 0 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + name + "' (parent is " + parent == null ? "" : "not null)");
        }
        this.parent = parent;
        this.name = name;
    }

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return this.parent.path() + '/' + this.name;
    }

    private String path() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.path() + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root == Preferences.userRoot();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        return (AbstractPreferences[])this.childCache.values().toArray();
    }

    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                TreeSet childrenNames = new TreeSet();
                childrenNames.addAll(this.childCache.keySet());
                String[] names = this.childrenNamesSpi();
                for (int i = 0; i < names.length; ++i) {
                    childrenNames.add(names[i]);
                }
                Object[] children = new String[childrenNames.size()];
                childrenNames.toArray(children);
                Object[] objectArray = children;
                Object var6_7 = null;
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
        }
    }

    public Preferences node(String path) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.isRemoved()) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (path.startsWith("/")) break block5;
                    if (path.indexOf("//") != -1 || path.endsWith("/")) {
                        throw new IllegalArgumentException(path);
                    }
                    Preferences preferences = this.getNode(path);
                    Object var4_5 = null;
                    return preferences;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            Object var4_6 = null;
        }
        Preferences root = this.isUserNode() ? Preferences.userRoot() : Preferences.systemRoot();
        Preferences preferences = root.node(path.substring(1));
        return preferences;
    }

    private Preferences getNode(String path) {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return this;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = (AbstractPreferences)this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.childSpi(childName);
            this.childCache.put(childName, child);
        }
        Object object = child.lock;
        synchronized (object) {
            try {
                Preferences preferences = child.getNode(childPath);
                Object var8_8 = null;
                return preferences;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.isRemoved() && path.length() != 0) {
                        throw new IllegalStateException("Node removed");
                    }
                    if (path.startsWith("/")) break block5;
                    if (path.indexOf("//") != -1 || path.endsWith("/")) {
                        throw new IllegalArgumentException(path);
                    }
                    boolean bl = this.existsNode(path);
                    Object var4_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            Object var4_6 = null;
        }
        Preferences root = this.isUserNode() ? Preferences.userRoot() : Preferences.systemRoot();
        boolean bl = root.nodeExists(path.substring(1));
        return bl;
    }

    private boolean existsNode(String path) throws BackingStoreException {
        String childPath;
        String childName;
        if (path.length() == 0) {
            return this.isRemoved() ^ true;
        }
        int nextSlash = path.indexOf(47);
        if (nextSlash == -1) {
            childName = path;
            childPath = "";
        } else {
            childName = path.substring(0, nextSlash);
            childPath = path.substring(nextSlash + 1);
        }
        AbstractPreferences child = (AbstractPreferences)this.childCache.get(childName);
        if (child == null) {
            if (childName.length() > 80) {
                throw new IllegalArgumentException(childName);
            }
            child = this.getChild(childName);
            if (child == null) {
                return false;
            }
            this.childCache.put(childName, child);
        }
        Object object = child.lock;
        synchronized (object) {
            try {
                boolean bl = child.existsNode(childPath);
                Object var8_8 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    protected AbstractPreferences getChild(String name) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences;
            try {
                String[] names = this.childrenNamesSpi();
                for (int i = 0; i < names.length; ++i) {
                    if (!name.equals(names[i])) continue;
                    AbstractPreferences abstractPreferences2 = this.childSpi(name);
                    Object var6_7 = null;
                    return abstractPreferences2;
                }
                abstractPreferences = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                throw throwable;
            }
            Object var6_8 = null;
            return abstractPreferences;
        }
    }

    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean bl = this.removed;
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                AbstractPreferences abstractPreferences = this.parent;
                Object var3_3 = null;
                return abstractPreferences;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public void exportNode(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, os);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream os) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter((Preferences)this, os);
        nodeWriter.writePrefsTree();
    }

    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                String[] stringArray = this.keysSpi();
                Object var3_3 = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public String get(String key, String defaultVal) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            String string;
            try {
                String value;
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                try {
                    value = this.getSpi(key);
                }
                catch (Throwable t) {
                    value = null;
                }
                if (value != null) {
                    String string2 = value;
                    Object var6_8 = null;
                    return string2;
                }
                string = defaultVal;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                throw throwable;
            }
            Object var6_9 = null;
            return string;
        }
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String value = this.get(key, null);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultVal;
    }

    public byte[] getByteArray(String key, byte[] defaultVal) {
        String value = this.get(key, null);
        byte[] b = null;
        if (value != null) {
            b = AbstractPreferences.decode64(value);
        }
        if (b != null) {
            return b;
        }
        return defaultVal;
    }

    private static byte[] decode64(String s) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(s.length() / 4 * 3);
        char[] c = new char[s.length()];
        s.getChars(0, s.length(), c, 0);
        int endchar = -1;
        for (int j = 0; j < c.length && endchar == -1; ++j) {
            if (c[j] >= 'A' && c[j] <= 'Z') {
                c[j] = (char)(c[j] - 65);
                continue;
            }
            if (c[j] >= 'a' && c[j] <= 'z') {
                c[j] = (char)(c[j] + 26 - 97);
                continue;
            }
            if (c[j] >= '0' && c[j] <= '9') {
                c[j] = (char)(c[j] + 52 - 48);
                continue;
            }
            if (c[j] == '+') {
                c[j] = 62;
                continue;
            }
            if (c[j] == '/') {
                c[j] = 63;
                continue;
            }
            if (c[j] == '=') {
                endchar = j;
                continue;
            }
            return null;
        }
        int i = 0;
        for (int remaining = endchar == -1 ? c.length : endchar; remaining > 0; remaining -= 4) {
            int b0 = c[i] << 2;
            if (remaining >= 2) {
                b0 += (byte)((c[i + 1] & 0x30) >> 4);
            }
            bs.write(b0);
            if (remaining >= 3) {
                int b1 = (c[i + 1] & 0xF) << 4;
                bs.write(b1 += (byte)((c[i + 2] & 0x3C) >> 2));
            }
            if (remaining >= 4) {
                int b2 = (c[i + 2] & 3) << 6;
                bs.write(b2 += (byte)c[i + 3]);
            }
            i += 4;
        }
        return bs.toByteArray();
    }

    public double getDouble(String key, double defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public float getFloat(String key, float defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public int getInt(String key, int defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public long getLong(String key, long defaultVal) {
        String value = this.get(key, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public void put(String key, String value) {
        if (key.length() > 80 || value.length() > 8192) {
            throw new IllegalArgumentException("key (" + key.length() + ")" + " or value (" + value.length() + ")" + " to large");
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                this.putSpi(key, value);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, AbstractPreferences.encode64(value));
    }

    private static String encode64(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length / 3 * 4);
        int i = 0;
        char[] c = new char[4];
        for (int remaining = b.length; remaining > 0; remaining -= 3) {
            c[0] = (char)((b[i] & 0xFC) >> 2);
            c[1] = (char)((b[i] & 3) << 4);
            if (remaining >= 2) {
                c[1] = (char)(c[1] + (char)((b[i + 1] & 0xF0) >> 4));
                c[2] = (char)((b[i + 1] & 0xF) << 2);
                if (remaining >= 3) {
                    c[2] = (char)(c[2] + (char)((b[i + 2] & 0xC0) >> 6));
                    c[3] = (char)b[i + 2] & 0x3F;
                } else {
                    c[3] = 64;
                }
            } else {
                c[2] = 64;
                c[3] = 64;
            }
            for (int j = 0; j < 4; ++j) {
                c[j] = c[j] < '\u001a' ? (int)(c[j] + 65) : (c[j] < '4' ? (int)(c[j] - 26 + 97) : (c[j] < '>' ? (int)(c[j] - 52 + 48) : (c[j] == '>' ? 43 : (c[j] == '?' ? 47 : 61))));
            }
            sb.append(c);
            i += 3;
        }
        return sb.toString();
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void remove(String key) {
        if (key.length() > 80) {
            throw new IllegalArgumentException(key);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node removed");
                }
                this.removeSpi(key);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                String[] keys = this.keys();
                for (int i = 0; i < keys.length; ++i) {
                    this.removeSpi(keys[i]);
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void flushNode(boolean sync) throws BackingStoreException {
        String[] keys = null;
        Object object = this.lock;
        // MONITORENTER : object
        try {
            if (sync) {
                this.syncSpi();
            } else {
                this.flushSpi();
            }
            keys = (String[])this.childCache.keySet().toArray();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            // MONITOREXIT : object
            throw throwable;
        }
        Object var4_4 = null;
        // MONITOREXIT : object
        if (keys == null) return;
        int i = 0;
        while (i < keys.length) {
            block9: {
                Object var7_10;
                AbstractPreferences subNode;
                AbstractPreferences abstractPreferences = this;
                // MONITORENTER : abstractPreferences
                try {
                    subNode = (AbstractPreferences)this.childCache.get(keys[i]);
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    // MONITOREXIT : abstractPreferences
                    throw throwable;
                }
                var7_10 = null;
                // MONITOREXIT : abstractPreferences
                if (subNode == null) break block9;
                subNode.flushNode(sync);
            }
            ++i;
        }
    }

    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        AbstractPreferences abstractPreferences = this.parent;
        synchronized (abstractPreferences) {
            Object var3_3;
            try {
                AbstractPreferences abstractPreferences2 = this;
                synchronized (abstractPreferences2) {
                    try {
                        if (this.isRemoved()) {
                            throw new IllegalStateException("Node Removed");
                        }
                        this.purge();
                    }
                    finally {
                        var3_3 = null;
                    }
                    this.parent.childCache.remove(this.name);
                }
            }
            finally {
                var3_3 = null;
            }
            {
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void purge() throws BackingStoreException {
        children = this.childrenNamesSpi();
        for (i = 0; i < children.length; ++i) {
            if (this.childCache.get(children[i]) != null) continue;
            this.childCache.put(children[i], this.childSpi(children[i]));
        }
        i = this.childCache.values().iterator();
        while (true) lbl-1000:
        // 2 sources

        {
            if (!i.hasNext()) {
                this.childCache.clear();
                this.removeNodeSpi();
                this.removed = true;
                return;
            }
            *.LJv17 = node = (AbstractPreferences)i.next();
            // MONITORENTER : *.LJv17
            node.purge();
            break;
        }
        catch (Throwable var6_7) {
            var5_6 = null;
            // MONITOREXIT : *.LJv17
            throw var6_7;
        }
        {
            var5_6 = null;
            // MONITOREXIT : *.LJv17
            ** while (true)
        }
    }

    public void addNodeChangeListener(NodeChangeListener listener) {
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
    }

    public void removeNodeChangeListener(NodeChangeListener listener) {
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;
}

