.\"
.\" Copyright 2001-2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH Xdmx 1 __vendorversion__
.SH NAME
Xdmx - Distributed Multi-head X server
.SH SYNOPSIS
.B Xdmx
[:display] [option ...]
.SH DESCRIPTION
.I Xdmx
is a proxy X server that uses one or more other X servers as its display
devices.  It provides multi-head X functionality for displays that might
be located on different machines.
.I Xdmx
functions as a front-end X server that acts as a proxy to a set of
back-end X servers.  All of the visible rendering is passed to the
back-end X servers.  Clients connect to the
.I Xdmx
front-end, and everything appears as it would in a regular multi-head
configuration.  If Xinerama is enabled (e.g., with
.B +xinerama
on the command line), the clients see a single large screen.
.PP
.I Xdmx
communicates to the back-end X servers using the standard X11 protocol,
and standard and/or commonly available X server extensions.
.SH OPTIONS
In addition to the normal X server options described in the
.I Xserver(__appmansuffix__)
manual page,
.I Xdmx
accepts the following command line switches:
.TP 8
.BI "\-display " display-name
This specifies the name(s) of the back-end X server display(s) to connect
to.  This option may be specified multiple times to connect to more than
one back-end display.  The first is used as screen 0, the second as screen 1,
etc.  If this option is omitted, the
.B $DISPLAY
environment variable is used as the single back-end X server display.
.sp
.TP 8
.BI "\-xinput " input-source
This specifies the source to use for XInput extension devices.  The
choices are the same as for
.BR "\-input " ,
described below, except that core devices on backend servers cannot be
treated as XInput extension devices.  (Although extension devices on
backend and console servers are supported as extension devices under
.IR Xdmx ).
.sp
.TP 8
.BI "\-input " input-source
This specifies the source to use for the core input devices.  The choices are:
.RS
.TP 4
.B dummy
A set of dummy core input drivers are used.  These never generate any
input events.
.sp
.TP 4
.B local
The raw keyboard and pointer from the local computer are used.  A
comma-separated list of driver names can be appended.  For example, to
select the example Linux keyboard and PS/2 mouse driver use:
.BR "-input local,kbd,ps2" .
The following drivers have been implemented for Linux: kbd, ms (a
two-button Microsoft mouse driver), ps2 (a PS/2 mouse driver), usb-mou
(a USB mouse driver), usb-kbd (a USB keyboard driver), and usb-oth (a
USB non-keyboard, non-mouse driver).  Additional drivers may be
implemented in the future.  Appropriate defaults will be used if no
comma-separated list is provided.
.sp
.TP 4
.I display-name
If the display-name is a back-end server, then core input events are
taken from the server specified.  Otherwise, a console window will be
opened on the specified display.
.sp
If the
.I display-name
is followed by ",xi" then XInput extension devices on the display will
be used as
.I Xdmx
XInput extension devices.  If the
.I display-name
is followed by ",noxi" then XInput extension devices on the display will
.B not
be used as
.I Xdmx
XInput extension devices.  Currently, the default is ",xi".
.sp
If the
.I display-name
is followed by ",console" and the
.I display-name
refers to a display that is used as a backend display, then a console
window will be opened on that display
.B and
that display will be treated as a backend display.  Otherwise (or if
",noconsole" is used), the display will be treated purely as a backend
or a console display, as described above.
.sp
If the
.I display-name
is followed by ",windows", then outlines of the windows on the backend
will be displayed inside the console window.  Otherwise (or if
",nowindows" is used), the console window will not display the outlines
of backend windows.  (This option only applies to console input.)
.sp
If the
.I display-name
is followed by ",xkb", then the next 1 to 3 comma-separated parameters
will specify the keycodes, symbols, and geometry of the keyboard for
this input device.  For example, ",xkb,xfree86,pc104" will specify that
the "xfree86" keycodes and the "pc104" symbols should be used to
initialize the keyboard.  For an SGI keyboard, ",xkb,sgi/indy(pc102)"
might be useful.  A list of keycodes, symbols, and geometries can be
found in
.IR __xkbdir__ .
Use of keycodes, symbols and geometries for XKB configuration is
deprecated in favor of the rules, layout, model, variant and options
settings available via the -param command line switch.
If this option is not specified, the input device will be queried,
perhaps using the XKEYBOARD extension.
.RE
.sp
.RS
If this option isn't specified, the default input source is the first
back-end server (the one used for screen 0).  The console window shows
the layout of the back-end display(s) and pointer movements and key
presses within the console window will be used as core input devices.
.sp
Several special function keys are active, depending on the input
source:
.sp
.RS
.B Ctrl-Alt-q
will terminate the
.I Xdmx
server in all modes.
.sp
.B Ctrl-Alt-g
will toggle a
server grab in console mode (a special cursor, currently a spider, is
used to indicate an active server grab).
.sp
.B Ctrl-Alt-f
will toggle fine-grain motion in console mode (a special cursor,
currently a cross hair, is used to indicate this mode).  If this mode is
combined with a server grab, then the cursor will have 4 lines instead
of only 2.
.sp
.BR Ctrl-Alt-F1 " through " Ctrl-Alt-F12
will switch to another VC in local (raw) mode.
.RE
.RE
.sp
.TP 8
.BI "-shadowfb"
This option turns on (legacy) support for the shadow frame buffer.
.sp
.TP 8
.BI "-noshadowfb"
This option turns off (legacy) support for the shadow frame buffer.
Note that this option has been deprecated and will be removed in the
next release.
.sp
.TP 8
.BI "-nomulticursor"
This option turns off support for displaying multiple cursors on
overlapped back-end displays.  This option is available for testing and
benchmarking purposes.
.sp
.TP 8
.BI "-fontpath"
This option sets the
.I Xdmx
server's default font path.  This option can be specified multiple times
to accommodate multiple font paths.  See the
.B "FONT PATHS"
section below for very important information regarding setting the
default font path.
.sp
.TP 8
.BI "-configfile " filename
Specify the configuration file that should be read.  Note that if the
.B \-display
command-line option is used, then the configuration file will be
ignored.
.sp
.TP 8
.BI "-config " name
Specify a configuration to use.  The
.I name
will be the name following the
.B virtual
keyword in the configuration file.
.sp
.TP 8
.BI "-stat " "interval screens"
This option enables the display of performance statistics.  The interval
is in seconds.  The screens is a count of the number of back-end screens
for which data is printed each interval.  Specifying 0 for screens will
display data for all screens.
.sp
For each screen, the following information is printed: the screen
number, an absolute count of the number of XSync() calls made
(SyncCount), the rate of these calls during the previous interval
(Sync/s), the average round-trip time (in microseconds) of the last 10
XSync() calls (avSync), the maximum round-trip time (in microseconds) of
the last 10 XSync calls (mxSync), the average number of XSync() requests
that were pending but not yet processed for each of the last 10
processed XSync() calls, the maximum number of XSync() requests that
were pending but not yet processed for each of the last 10 processed
XSync() calls, and a histogram showing the distribution of the times of
all of the XSync() calls that were made during the previous interval.
.sp
(The length of the moving average and the number and value of histogram
bins are configurable at compile time in the
.B dmxstat.h
header file.)
.sp
.TP 8
.BI "-syncbatch " interval
This option sets the
.I interval
in milliseconds for XSync() batching.  An
.I interval
less than or equal to 0 will disable XSync() batching.  The default
.I interval
is 100 ms.
.sp
.TP 8
.BI "-nooffscreenopt"
This option disables the offscreen optimization.  Since the lazy window
creation optimization requires the offscreen optimization to be enabled,
this option will also disable the lazy window creation optimization.
.sp
.TP 8
.BI "-nowindowopt"
This option disables the lazy window creation optimization.
.sp
.TP 8
.BI "-nosubdivprims"
This option disables the primitive subdivision optimization.
.sp
.TP 8
.BI "-noxkb"
Disable use of the XKB extension for communication with the back end
displays.  (Combine with
.B "-kb"
to disable all use of XKB.)
.sp
.TP 8
.BI "-depth " int
This option sets the root window's default depth.  When choosing a
default visual from those available on the back-end X server, the first
visual with that matches the depth specified is used.
.sp
This option can be combined with the
.BI "-cc"
option, which specifies the default color visual class, to force the use
of a specific depth and color class for the root window.
.sp
.TP 8
.BI "-norender"
This option disables the RENDER extension.
.sp
.TP 8
.BI "-noglxproxy"
This option disables GLX proxy -- the build-in GLX extension
implementation that is DMX aware.
.sp
.TP 8
.BI "-noglxswapgroup"
This option disables the swap group and swap barrier extensions in GLX
proxy.
.sp
.TP 8
.BI "-glxsyncswap"
This option enables synchronization after a swap buffers call by waiting
until all X protocol has been processed.  When a client issues a
glXSwapBuffers request, Xdmx relays that request to each back-end X
server, and those requests are buffered along with all other protocol
requests.  However, in systems that have large network buffers, this
buffering can lead to the set of back-end X servers handling the swap
buffers request asynchronously.  With this option, an XSync() request is
issued to each back-end X server after sending the swap buffers request.
The XSync() requests will flush all buffered protocol (including the
swap buffers requests) and wait until the back-end X servers have
processed those requests before continuing.  This option does not wait
until all GL commands have been processed so there might be previously
issued commands that are still being processed in the GL pipe when the
XSync() request returns.  See the
.BI "-glxfinishswap"
option below if Xdmx should wait until the GL commands have been
processed.
.sp
.TP 8
.BI "-glxfinishswap"
This option enables synchronization after a swap buffers call by waiting
until all GL commands have been completed.  It is similar to the
.BI "-glxsyncswap"
option above; however, instead of issuing an XSync(), it issues a
glFinish() request to each back-end X server after sending the swap
buffers requests.  The glFinish() request will flush all buffered
protocol requests, process both X and GL requests, and wait until all
previously called GL commands are complete before returning.
.sp
.TP 8
.BI "-ignorebadfontpaths"
This option ignores font paths that are not available on all back-end
servers by removing the bad font path(s) from the default font path
list.  If no valid font paths are left after removing the bad paths, an
error to that effect is printed in the log.
.sp
.TP 8
.BI "-addremovescreens"
This option enables the dynamic addition and removal of screens, which
is disabled by default.  Note that GLXProxy and Render do not yet
support dynamic addition and removal of screens, and must be disabled
via the
.BI "-noglxproxy"
and
.BI "-norender"
command line options described above.
.sp
.TP 8
.BI "-param"
This option specifies parameters on the command line.  Currently, only
parameters dealing with XKEYBOARD configuration are supported.  These
parameters apply only to the core keyboard.  Parameter values are
installation-dependent.  Please see
.I __xkbdir__
or a similar directory for complete information.
.RS
.TP 8
.B XkbRules
Defaults to "__XKB_DFLT_RULES__".  Other values may include "sgi" and "sun".
.sp
.TP 8
.B XkbModel
Defaults to "__XKB_DFLT_MODEL__".  When used with "base" rules, other values
may include "pc102", "pc104", "microsoft", and many others.  When
used with "sun" rules, other values may include "type4" and "type5".
.sp
.TP 8
.B XkbLayout
Defaults to "__XKB_DFLT_LAYOUT__".  Other country codes and "dvorak" are usually
available.
.sp
.TP 8
.B XkbVariant
Defaults to "__XKB_DFLT_VARIANT__".
.sp
.TP 8
.B XkbOptions
Defaults to "__XKB_DFLT_OPTIONS__".
.RE
.SH "CONFIGURATION FILE GRAMMAR"
The following words and tokens are reserved:
.RS
.B virtual
.B display
.B wall
.B option
.B param
.B {
.B }
.B ;
.B #
.RE
.PP
Comments start with a
.B #
mark and extend to the end of the line.  They may appear anywhere.  If a
configuration file is read into
.BR xdmxconfig ,
the comments in that file will be preserved, but will not be editable.
.PP
The grammar is as follows:
.RS
virtual-list ::= [ virtual-list ] | virtual

virtual ::=
.B virtual
[ name ] [ dim ]
.B {
dw-list
.B }

dw-list ::= [ dw-list ] | dw

dw ::= display | wall | option

display ::=
.B display
name [ geometry ] [ / geometry ] [ origin ]
.B ;

wall ::=
.B wall
[ dim ] [ dim ] name-list
.B ;

option ::=
.B option
name-list
.B ;

param ::=
.B param
name-list
.B ;

param ::=
.B param {
param-list
.B }

param-list ::= [ param-list ] | name-list
.B ;

name-list ::= [ name-list ] | name

name ::= string | double-quoted-string

dim ::= integer
.B x
integer

geometry ::= [ integer
.B x
integer ] [ signed-integer signed-integer ]

origin ::=
.B @
integer
.B x
integer
.RE
.PP
The name following
.B virtual
is used as an identifier for the configuration, and may be passed to
.B Xdmx
using the
.B \-config
command line option.  The name of a display should be standard X display
name, although no checking is performed (e.g., "machine:0").
.PP
For names, double quotes are optional unless the name is reserved or
contains spaces.
.PP
The first dimension following
.B wall
is the dimension for tiling (e.g., 2x4 or 4x4).  The second dimension
following
.B wall
is the dimension of each display in the wall (e.g., 1280x1024).
.PP
The first geometry following
.B display
is the geometry of the screen window on the backend server.  The second
geometry, which is always preceeded by a slash, is the geometry of the
root window.  By default, the root window has the same geometry as the
screen window.
.PP
The
.B option
line can be used to specify any command-line options (e.g.,
.BR \-input ).
(It cannot be used to specify the name of the front-end display.)  The
option line is processed once at server startup, just line command line
options.  This behavior may be unexpected.
.SH "CONFIGURATION FILE EXAMPLES"
Two displays being used for a desktop may be specified in any of the
following formats:
.RS
.nf
virtual example0 {
    display d0:0 1280x1024 @0x0;
    display d1:0 1280x1024 @1280x0;
}
.sp
virtual example1 {
    display d0:0 1280x1024;
    display d1:0 @1280x0;
}
.sp
virtual example2 {
    display "d0:0";
    display "d1:0" @1280x0;
}
.sp
virtual example3 { wall 2x1 d0:0 d1:0; }
.fi
.RE
A 4x4 wall of 16 total displays could be specified as follows (if no
tiling dimension is specified, an approximate square is used):
.RS
.nf
virtual example4 {
    wall d0:0 d1:0 d2:0 d3:0
         d4:0 d5:0 d6:0 d7:0
         d8:0 d9:0 da:0 db:0
         dc:0 dd:0 de:0 df:0;
}
.fi
.RE
.SH "FONT PATHS"
The font path used by the
.I Xdmx
front-end server will be propagated to each back-end server,which
requires that each back-end server have access to the exact same font
paths as the front-end server.  This can be most easily handled by
either using a font server (e.g., xfs) or by remotely mounting the font
paths on each back-end server, and then setting the
.I Xdmx
server's default font path with the
-I "-fontpath"
command line option described above.
.PP
For example, if you specify a font path with the following command line:
.RS
Xdmx :1 -display d0:0 -fontpath /usr/fonts/75dpi/ -fontpath /usr/fonts/Type1/ +xinerama
.RE
Then, /usr/fonts/75dpi/ and /usr/fonts/Type1/ must be valid font paths
on the
.I Xdmx
server and all back-end server, which is d0 in this example.
.PP
Font servers can also be specified with the
.I "-fontpath"
option.  For example, let's assume that a properly configured font
server is running on host d0.  Then, the following command line
.RS
Xdmx :1 -display d0:0 -display d1:0 -fontpath tcp/d0:7100 +xinerama
.RE
will initialize the front-end
.I Xdmx
server and each of the back-end servers to use the font server on d0.
.PP
Some fonts might not be supported by either the front-end or the
back-end servers.  For example, let's assume the front-end
.I Xdmx
server includes support Type1 fonts, but one of the back-end servers
does not.  Let's also assume that the default font path for
.I Xdmx
includes Type1 fonts in its font path.  Then, when
.I Xdmx
initializes the default font path to load the default font, the font
path that includes Type1 fonts (along with the other default font paths
that are used by the
.I Xdmx
server) is sent to the back-end server that cannot handle Type1 fonts.
That back-end server then rejects the font path and sends an error back
to the
.I Xdmx
server.
.I Xdmx
then prints an error message and exits because it failed to set the
default font path and was unable load the default font.
.PP
To fix this error, the offending font path must be removed from the
default font path by using a different
.I "-fontpath"
command line option.
.PP
The
.I "-fontpath"
option can also be added to the configuration file as described above.
.SH "COMMAND-LINE EXAMPLES"
The back-end machines are d0 and d1, core input is from the pointer and
keyboard attached to d0, clients will refer to :1 when opening windows:
.RS
Xdmx :1 -display d0:0 -display d1:0 +xinerama
.RE
.PP
As above, except with core input from d1:
.RS
Xdmx :1 -display d0:0 -display d1:0 -input d1:0 +xinerama
.RE
.PP
As above, except with core input from a console window on the local
display:
.RS
Xdmx :1 -display d0:0 -display d1:0 -input :0 +xinerama
.RE
.PP
As above, except with core input from the local keyboard and mouse:
.RS
Xdmx :1 -display d0:0 -display d1:0 -input local,kbd,ps2 +xinerama
.RE
Note that local input can be used under Linux while another X session is
running on :0 (assuming the user can access the Linux console tty and
mouse devices): a new (blank) VC will be used for keyboard input on the
local machine and the Ctrl-Alt-F* sequence will be available to change
to another VC (possibly back to another X session running on the local
machine).  Using Ctrl-Alt-Backspace on the blank VC will terminate the
Xdmx session and return to the original VC.
.PP
This example uses the configuration file shown in the previous section:
.RS
Xdmx :1 -input :0 +xinerama -configfile filename -config example2
.RE
With this configuration file line:
.RS
option -input :0 +xinerama;
.RE
the command line can be shortened to:
.RS
Xdmx :1 -configfile filename -config example2
.RE
.SH "USING THE USB DEVICE DRIVERS"
.P
The USB device drivers use the devices called
.IR /dev/input/event0 ", " /dev/input/event1 ", etc."
under Linux.  These devices are driven using the
.I evdev
Linux kernel module, which is part of the hid suite.  Please note that
if you load the
.I mousedev
or
.I kbddev
Linux kernel modules, then USB devices will appear as core Linux input
devices and you will not be able to select between using the device only
as an
.I Xdmx
core device or an
.I Xdmx
XInput extension device.  Further, you may be unable to unload the
.I mousedev
Linux kernel module if
.I XFree86
is configured to use
.I /dev/input/mice
as an input device (this is quite helpful for laptop users and is set up
by default under some Linux distributions, but should be changed if USB
devices are to be used with
.IR Xdmx ).
.PP
The USB device drivers search through the Linux devices for the first
mouse, keyboard, or non-mouse-non-keyboard Linux device and use that
device.
.SH "KEYBOARD INITIALIZATION"
.PP
If
.I Xdmx
was invoked with
.I \-xkb
or was
.B not
compiled to use the XKEYBOARD extension, then a keyboard on a backend or
console will be initialized using the map that the host X server
provides.
.PP
If the XKEYBOARD extension is used for both
.I Xdmx
and the host X server for the keyboard (i.e., the backend or console X
server), then the type of the keyboard will
be obtained from the host X server and the keyboard under
.I Xdmx
will be initialized with that information.  Otherwise, the default type
of keyboard will be initialized.  In both cases, the map from the host X
server will
.B not
be used.  This means that different initial behavior may be noted with
and without XKEYBOARD.  Consistent and expected results will be obtained
by running XKEYBOARD on all servers and by avoiding the use of
.I xmodmap
on the backend or console X servers prior to starting
.IR Xdmx .
.PP
If
.I \-xkbmap
is specified on the
.I Xdmx
command line, then that map will currently be used for all keyboards.
.SH "MULTIPLE CORE KEYBOARDS"
X was not designed to support multiple core keyboards.  However,
.I Xdmx
provides some support for multiple core keyboards.  Best results will be
obtained if all of the keyboards are of the same type and are using the
same keyboard map.  Because the X server passes raw key code information
to the X client, key symbols for keyboards with different key maps would
be different if the key code for each keyboard was sent without
translation to the client.  Therefore,
.I Xdmx
will attempt to translate the key code from a core keyboard to the key
code for the key with the same key symbol of the
.B first
core keyboard that was loaded.  If the key symbol appears in both maps,
the results will be expected.  Otherwise, the second core keyboard will
return a NoSymbol key symbol for some keys that would have been
translated if it was the first core keyboard.
.ig
.SH ENVIRONMENT
..
.ig
.SH FILES
..
.SH "SEE ALSO"
.BR DMX "(__libmansuffix__), " X "(__miscmansuffix__), "
.BR Xserver "(__appmansuffix__), " xdmxconfig "(__appmansuffix__), "
.BR vdltodmx "(__appmansuffix__), " xfs "(__appmansuffix__), "
.BR xkbcomp "(__appmansuffix__), " xkeyboard-config "(__miscmansuffix__)"
.SH AUTHORS
Kevin E. Martin
.I <kem@redhat.com>,
David H. Dawes
.I <dawes@xfree86.org>,
and
Rickard E. (Rik) Faith
.IR <faith@redhat.com> .
.PP
Portions of
.I Xdmx
are based on code from The XFree86 Project
.RI ( http://www.xfree86.org )
and X.Org
.RI ( http://www.x.org ).
