dnl Tests for miscellaneous 
AC_DEFUN(ST_DECL_SVC_REGISTER,
[AC_CACHE_CHECK([for svc_register declaration in rpc/rpc.h],
  st_cv_decl_svc_register,
[AC_TRY_COMPILE([#include <rpc/rpc.h>
#if HAVE_RPC_SVC_SOC_H
#include <rpc/svc_soc.h>
#endif
],
[extern double svc_register(double); /* bogus declaration */
],st_cv_decl_svc_register=no, st_cv_decl_svc_register=yes)])
if test $st_cv_decl_svc_register = yes; then
  AC_DEFINE(SVC_REGISTER_DECLARED)
fi
])

AC_DEFUN(ST_HAS_SVC_GETCALLER,
[AC_MSG_CHECKING(whether rpc/rpc.h defines svc_getcaller)
AC_CACHE_VAL(ac_cv_has_svc_getcaller,
[AC_EGREP_CPP(has_svc_getcaller,
[#include <rpc/rpc.h>
#if HAVE_RPC_SVC_SOC_H
#include <rpc/svc_soc.h>
#endif
#ifdef svc_getcaller
has_svc_getcaller
#endif], ac_found=yes, ac_found=no)
if test $ac_found = no; then
  AC_EGREP_HEADER(svc_getcaller, rpc/rpc.h, ac_found=yes, ac_found=no)
fi
eval ac_cv_has_svc_getcaller=$ac_found
])
AC_MSG_RESULT($ac_cv_has_svc_getcaller)
if test $ac_cv_has_svc_getcaller = yes; then
  AC_DEFINE(HAS_SVC_GETCALLER)
  AC_DEFINE(SVC_GETCALLER_DECLARED)
else
  AC_CHECK_FUNC(svc_getcaller, AC_DEFINE(HAS_SVC_GETCALLER))
  if test $ac_cv_has_svc_getcaller = no; then
    # svc_getcaller is not in the default libraries.
    # See if it's in some other.
    for lib in nsl socket inet bsd; do
      AC_CHECK_LIB($lib, svc_getcaller, [AC_DEFINE(HAS_SVC_GETCALLER)
        LIBS="$LIBS $lib"; break])
    done
  fi
fi
])

