/***************************************************************************
                            KColorDrag.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A drag-and-drop object for colors. The according MIME type
 is set to application/x-color.

 See the Qt drag'n'drop documentation.
 
 See {@link KColorDragSignals} for signals emitted by KColorDrag.

 

 @short *
 A drag-and-drop object for colors.
*/
public class KColorDrag extends QStoredDrag  {
	protected KColorDrag(Class dummy){super((Class) null);}

	private native void newKColorDrag( QWidget dragsource, String name);

/** 
 Constructs a color drag with a white color.
     
*/
	public KColorDrag( QWidget dragsource, String name) {
		super((Class) null);
		newKColorDrag( dragsource, name);
	}
	private native void newKColorDrag();
	public KColorDrag() {
		super((Class) null);
		newKColorDrag();
	}
	private native void newKColorDrag( QColor col, QWidget dragsource, String name);

/** 
 Constructs a color drag with the color @p.
     
*/
	public KColorDrag( QColor col, QWidget dragsource, String name) {
		super((Class) null);
		newKColorDrag( col, dragsource, name);
	}
	private native void newKColorDrag( QColor col);
	public KColorDrag( QColor col) {
		super((Class) null);
		newKColorDrag( col);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the color of the drag to <code>col.</code>
     
*/
	public native void setColor( QColor col);

/** 
 Returns true if the MIME source <code>e</code> contains a color object.
     
*/
	public static native boolean canDecode( QMimeSourceInterface e);

/** 
 Decodes the MIME source <code>e</code> and puts the resulting color into <code>col.</code>
     
*/
	public static native boolean decode( QMimeSourceInterface e, QColor col);

/** 

     
*/
	public static native KColorDrag makeDrag( QColor arg1, QWidget dragsource);
	protected native void virtual_hook( int identifier, int data);
}
