/***************************************************************************
                            KHTMLPart.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is khtml's main class. It features an almost complete
 web browser, and html renderer.

 The easiest way to use this class (if you just want to display a an HTML
 page at some URL) is the following:

 <pre>
 KURL url = "http://www.kde.org";
 KHTMLPart w = new KHTMLPart();
 w.openURL(url);
 w.view().resize(500, 400);
 w.show();
 </pre>

 By default Java and JavaScript support are disabled. You can enable them by
 using the {@link #setJavaEnabled} and {@link #setJScriptEnabled} methods.

 Some apps want to write their HTML code directly into the widget instead of
 it opening an url. You can also do that in the following way:

 <pre>
 String myHTMLCode = ...;
 KHTMLPart w = new KHTMLPart();
 w.begin();
 w.write(myHTMLCode);
 ...
 w.end();
 </pre>

 You can do as many calls to write as you want. But there are two
 {@link #write} methods, one accepting a {@link String} one accepting a
 <code>char</code> <code>argument.</code> You should use one or the other
 (but not both) since the method using
 the <code>char</code> <code>argument</code> does an additional decoding step to convert the
 written data to Unicode.

 See {@link KHTMLPartSignals} for signals emitted by KHTMLPart.

 

 @author Lars Knoll (knoll@kde.org)

 @version $Id: KHTMLPart.java,v 1.10 2002/11/26 04:17:32 rdale Exp $
 
 @short HTML Browser Widget.
*/
public class KHTMLPart extends ReadOnlyPart  {
	protected KHTMLPart(Class dummy){super((Class) null);}

	private native void newKHTMLPart( QWidget parentWidget, String widgetname, QObject parent, String name, int prof);

/** 
 Constructs a new KHTMLPart.

 KHTML basically consists of two objects: The KHTMLPart itself,
 holding the document data (DOM document), and the {@link KHTMLView},
 derived from {@link QScrollView}, in which the document content is
 rendered in. You can specify two different parent objects for a
 KHTMLPart, one parent for the KHTMLPart document and on parent
 for the {@link KHTMLView}. If the second <code>parent</code> argument is null, then
 <code>parentWidget</code> is used as parent for both objects, the part and
 the view.
   
*/
	public KHTMLPart( QWidget parentWidget, String widgetname, QObject parent, String name, int prof) {
		super((Class) null);
		newKHTMLPart( parentWidget, widgetname, parent, name, prof);
	}
   public KHTMLPart( QWidget parentWidget) {
      this(parentWidget,null,null,null,DefaultGUI);
   }
   public KHTMLPart( QWidget parentWidget, String widgetname) {
      this(parentWidget,widgetname,null,null,DefaultGUI);
   }
   public KHTMLPart( QWidget parentWidget, String widgetname, QObject parent) {
      this(parentWidget,widgetname,parent,null,DefaultGUI);
   }
   public KHTMLPart( QWidget parentWidget, String widgetname, QObject parent, String name) {
      this(parentWidget,widgetname,parent,name,DefaultGUI);
   }
	private native void newKHTMLPart();
	public KHTMLPart() {
		super((Class) null);
		newKHTMLPart();
	}
	private native void newKHTMLPart( KHTMLView view, QObject parent, String name, int prof);
	public KHTMLPart( KHTMLView view, QObject parent, String name, int prof) {
		super((Class) null);
		newKHTMLPart( view, parent, name, prof);
	}
	private native void newKHTMLPart( KHTMLView view);
	public KHTMLPart( KHTMLView view) {
		super((Class) null);
		newKHTMLPart( view);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Opens the specified URL <code>url.</code>

 Reimplemented from {@link KParts#ReadOnlyPart}.openURL .
   
*/
	public native boolean openURL( KURL url);

/** 
 Stops loading the document and kill all data requests (for images, etc.)
   
*/
	public native boolean closeURL();

/** 
 is called when a certain error situation (i.e. connection timed out) occured.
 default implementation either shows a KIO error dialog or loads a more verbose
 error description a as page, depending on the users configuration.
 <code>job</code> is the job that signaled the error situation
   
*/
	public native void showError( Job job);

/** 
 Returns a reference to the DOM HTML document (for non-HTML documents, returns null)
   
*/
	public native HTMLDocument htmlDocument();

/** 
 Returns a reference to the DOM document.
   
*/
	public native DOMDocument document();

/** 
 Returns the node that has the keyboard focus.
   
*/
	public native DOMNode activeNode();

/** 
 Returns a pointer to the {@link KParts#BrowserExtension}.
   
*/
	public native BrowserExtension browserExtension();
	public native int liveConnectExtension( int arg1);

/** 
 Returns a pointer to the HTML document's view.
   
*/
	public native KHTMLView view();

/** 
 Enable/disable Javascript support. Note that this will
 in either case permanently override the default usersetting.
 If you want to have the default UserSettings, don't call this
 method.
   
*/
	public native void setJScriptEnabled( boolean enable);

/** 
 Returns <code>true</code> if Javascript support is enabled or <code>false</code>
 otherwise.
   
*/
	public native boolean jScriptEnabled();

/** 
 Enable/disable the automatic forwarding by <meta http-equiv="refresh" ....>
   
*/
	public native void setMetaRefreshEnabled( boolean enable);

/** 
 Returns <code>true</code> if automtaic forwarding is enabled.
   
*/
	public native boolean metaRefreshEnabled();

/** 
 Execute the specified snippet of JavaScript code.

 Returns <code>true</code> if JavaScript was enabled, no error occured
 and the code returned true itself or <code>false</code> otherwise.

   
*/
	public native QVariant executeScript( String script);

/** 
 Same as above except the Node parameter specifying the 'this' value.
   
*/
	public native QVariant executeScript( DOMNode n, String script);

/** 
 Enables or disables Drag'n'Drop support. A drag operation is started if
 the users drags a link.
   
*/
	public native void setDNDEnabled( boolean b);

/** 
 Returns whether Dragn'n'Drop support is enabled or not.
   
*/
	public native boolean dndEnabled();

/** 
 Enables/disables Java applet support. Note that calling this function
 will permanently override the User settings about Java applet support.
 Not calling this function is the only way to let the default settings
 apply.
   
*/
	public native void setJavaEnabled( boolean enable);

/** 
 Return if Java applet support is enabled/disabled.
   
*/
	public native boolean javaEnabled();

/** 
 Returns the java context of the applets. If no applet exists, 0 is returned.
   
*/
//	public native KJavaAppletContext javaContext();

/** 
 Returns the java context of the applets. If no context exists yet, a new one is
 created.
   
*/
//	public native KJavaAppletContext createJavaContext();

/** 
 Enables or disables plugins via, default is enabled
   
*/
	public native void setPluginsEnabled( boolean enable);

/** 
 Returns trie if plugins are enabled/disabled.
   
*/
	public native boolean pluginsEnabled();

/** 
 Specifies whether images contained in the document should be loaded
 automatically or not.

 @note Request will be ignored if called before {@link #begin}.
   
*/
	public native void setAutoloadImages( boolean enable);

/** 
 Returns whether images contained in the document are loaded automatically
 or not.
 @note that the returned information is unrelieable as long as no begin()
 was called.
   
*/
	public native boolean autoloadImages();

/** 
 Security option.

 Specify whether only local references ( stylesheets, images, scripts, subdocuments )
 should be loaded. ( default false - everything is loaded, if the more specific
 options allow )
   
*/
	public native void setOnlyLocalReferences( boolean enable);

/** 
 Returnd whether references should be loaded ( default false )

*/
	public native boolean onlyLocalReferences();
	public native void enableJScript( boolean e);
	public native void enableJava( boolean e);
	public native void enablePlugins( boolean e);
	public native void autoloadImages( boolean e);
	public native void enableMetaRefresh( boolean e);
	public native boolean setCharset( String arg1, boolean arg2);
	public native KURL baseURL();
	public native String baseTarget();

/** 
 Returns the URL for the background Image (used by save background)
   
*/
	public native KURL backgroundURL();

/** 
 Schedules a redirection after <code>delay</code> seconds.
   
*/
	public native void scheduleRedirection( int delay, String url, boolean lockHistory);
	public native void scheduleRedirection( int delay, String url);

/** 
 Clears the widget and prepares it for new content.

 If you want {@link #url} to return
 for example "file:/tmp/test.html", you can use the following code:
 <PRE>
 view.begin( KURL("file:/tmp/test.html" ) );
 </PRE>

 All child frames and the old document are removed if you call
 this method.
   
*/
	public native void begin( KURL url, int xOffset, int yOffset);
	public native void begin();

/** 
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.

 The HTML code is send through a decoder which decodes the stream to
 Unicode.

 The <code>len</code> parameter is needed for streams encoded in utf-16,
 since these can have \0 chars in them. In case the encoding
 you're using isn't utf-16, you can safely leave out the length
 parameter.

 Attention: Don't mix calls to {@link #write} with calls
 to {@link #write}.

 The result might not be what you want.
   
*/
	public native void write( String str, int len);
	public native void write( String str);

/** 
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.
   
*/
//	public native void write( String str);

/** 
 Call this after your last call to {@link #write}.
   
*/
	public native void end();

/** 
 Paints the HTML page to a QPainter. See {@link KHTMLView#paint} for details
   
*/
	public native void paint( QPainter arg1, QRect arg2, int arg3, boolean[] arg4);
	public native void paint( QPainter arg1, QRect arg2);

/** 
 Sets the encoding the page uses.

 This can be different from the charset. The widget will try to reload the current page in the new
 encoding, if url() is not empty.
   
*/
	public native boolean setEncoding( String name, boolean override);
	public native boolean setEncoding( String name);

/** 
 Returns the encoding the page currently uses.

 Note that the encoding might be different from the charset.
   
*/
	public native String encoding();

/** 
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
	public native void setUserStyleSheet( KURL url);

/** 
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
	public native void setUserStyleSheet( String styleSheet);

/** 
 Sets the standard font style.

*/
	public native void setStandardFont( String name);

/** 
 Sets the fixed font style.

*/
	public native void setFixedFont( String name);

/** 
 Finds the anchor named <code>name.</code>

 If the anchor is found, the widget
 scrolls to the closest position. Returns <code>if</code> the anchor has
 been found.
   
*/
	public native boolean gotoAnchor( String name);

/** 
 Sets the cursor to use when the cursor is on a link.
   
*/
	public native void setURLCursor( QCursor c);

/** 
 Returns the cursor which is used when the cursor is on a link.
   
*/
	public native QCursor urlCursor();

/** 
 Initiates a text search.
   
*/
	public native void findTextBegin();

/** 
 Finds the next occurence of the string or expression.
 If isRegExp is true then str is converted to a QRegExp, and caseSensitive is ignored.
   
*/
	public native boolean findTextNext( String str, boolean forward, boolean caseSensitive, boolean isRegExp);

/** 
 Sets the Zoom factor. The value is given in percent, larger values mean a
 generally larger font and larger page contents. It is not guaranteed that
 all parts of the page are scaled with the same factor though.

 The given value should be in the range of 20..300, values outside that
 range are not guaranteed to work. A value of 100 will disable all zooming
 and show the page with the sizes determined via the given lengths in the
 stylesheets.
   
*/
	public native void setZoomFactor( int percent);

/** 
 Returns the current zoom factor.
   
*/
	public native int zoomFactor();

/** 
 Returns the text the user has marked.
   
*/
	public native String selectedText();

/** 
 Returns the selected part of the HTML.
   
*/
	public native Range selection();

/** 
 Sets the current selection.
   
*/
	public native void setSelection( int arg1);

/** 
 Has the user selected anything?

  Call {@link #selectedText} to
 retrieve the selected text.

*/
	public native boolean hasSelection();

/** 
 Marks all text in the document as selected.
   
*/
	public native void selectAll();

/** 
 Convenience method to show the document's view.

 Equivalent to widget().show() or view().show() .
   
*/
	public native void show();

/** 
 Convenience method to hide the document's view.

 Equivalent to widget().hide() or view().hide().
   
*/
	public native void hide();

/** 
 Returns a reference to the partmanager instance which
 manages html frame objects.
   
*/
	public native PartManager partManager();

/** 
 Saves the KHTMLPart's complete state (including child frame
 objects) to the provided {@link QDataStream}.

 This is called from the {@link #saveState} method of the
  {@link #browserExtension}.
   
*/
	public native void saveState( QDataStream stream);

/** 
 Restores the KHTMLPart's previously saved state (including
 child frame objects) from the provided QDataStream.

 This is called from the {@link #restoreState} method of the
 {@link #browserExtension} .

*/
	public native void restoreState( QDataStream stream);

/** 
 Returns the <code>Node</code> currently under the mouse
   
*/
	public native DOMNode nodeUnderMouse();

/** 

   
*/
	public native KHTMLSettings settings();

/** 
 Returns a pointer to the parent KHTMLPart if the part is a frame
 in an HTML frameset.

  Returns null otherwise.
   
*/
	public native KHTMLPart parentPart();

/** 
 Returns a list of names of all frame (including iframe) objects of
 the current document. Note that this method is not working recursively
 for sub-frames.
   
*/
	public native ArrayList frameNames();
	public native int frames();

/** 
 Finds a frame by name. Returns null if frame can't be found.
   
*/
	public native KHTMLPart findFrame( String f);

/** 
 Return the current frame (the one that has focus)
 Not necessarily a direct child of ours, framesets can be nested.
 Returns "this" if this part isn't a frameset.
   
*/
	public native ReadOnlyPart currentFrame();

/** 
 Returns whether a frame with the specified name is exists or not.
 In contrary to the {@link findFrame} method this one also returns true
 if the frame is defined but no displaying component has been
 found/loaded, yet.
   
*/
	public native boolean frameExists( String frameName);

/** 
 Called by KJS.
 Sets the StatusBarText assigned
 via window.status
   
*/
	public native void setJSStatusBarText( String text);

/** 
 Called by KJS.
 Sets the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
	public native void setJSDefaultStatusBarText( String text);

/** 
 Called by KJS.
 Returns the StatusBarText assigned
 via window.status
   
*/
	public native String jsStatusBarText();

/** 
 Called by KJS.
 Returns the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
	public native String jsDefaultStatusBarText();

/** 
 Referrer used for links in this page.
   
*/
	public native String referrer();

/** 
 Last-modified date (in raw string format), if received in the [HTTP] headers.
   
*/
	public native String lastModified();

/** 
 Loads a style sheet into the stylesheet cache.
   
*/
	public native void preloadStyleSheet( String url, String stylesheet);

/** 
 Loads a script into the script cache.
   
*/
	public native void preloadScript( String url, String script);

/** 

   
*/
	public native boolean restored();

/** 
 Sets the focussed node of the document to the specified node. If the node is a form control, the control will
 receive focus in the same way that it would if the user had clicked on it or tabbed to it with the keyboard. For
 most other types of elements, there is no visul indiction of whether or not they are focussed.

 See {@link activeNode}

*/
	public native void setActiveNode( DOMNode node);

/** 
 Stops all animated images on the current and child pages
   
*/
	public native void stopAnimations();
	public native String dcopObjectId();
	public static final int DefaultGUI = 0;
	public static final int BrowserViewGUI = 1;
	
 	// From KXMLGUIClientInterface

 	public native void beginXMLPlug( QWidget arg1);
	public native void endXMLPlug();
	public native void prepareXMLUnplug( QWidget arg1);
}
