/***************************************************************************
                            KImageEffect.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class includes various {@link QImage} based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short *
 This class includes various @ref QImage based graphical effects.
*/
public class  KImageEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KImageEffect(Class dummy){}


/** 
 Create a gradient from color a to color b of the specified type.

*/
	public static native QImage gradient( QSize size, QColor ca, QColor cb, int type, int ncols);
	public static native QImage gradient( QSize size, QColor ca, QColor cb, int type);

/** 
 Create an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
	public static native QImage unbalancedGradient( QSize size, QColor ca, QColor cb, int type, int xfactor, int yfactor, int ncols);
	public static native QImage unbalancedGradient( QSize size, QColor ca, QColor cb, int type);

/** 
 Blends a color into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel
 manipulation is used.

*/
	public static native QImage blend( QColor clr, QImage dst, float opacity);

/** 
 Blend the src image into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel
 manipulation is used.

*/
	public static native QImage blend( QImage src, QImage dst, float opacity);

/** 
 Blend the provided image into a background of the indicated color.

*/
	public static native QImage blend( QImage image, float initial_intensity, QColor bgnd, int eff, boolean anti_dir);
	public static native QImage blend( QImage image, float initial_intensity, QColor bgnd, int eff);

/** 
 Blend an image into another one, using a gradient type
 for blending from one to another.

*/
	public static native QImage blend( QImage image1, QImage image2, int gt, int xf, int yf);
	public static native QImage blend( QImage image1, QImage image2, int gt);

/** 
 Blend an image into another one, using a color channel of a
 third image for the decision of blending from one to another.

*/
	public static native QImage blend( QImage image1, QImage image2, QImage blendImage, int channel);

/** 
 Blend an image into another one, using alpha in the expected way.

*/
	public static native boolean blend( QImage upper, QImage lower, QImage output);

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates <code>x</code> and <code>y</code> with respect to the lower image.
 The output is a QImage which is the <code>upper</code> image already blended
 with the <code>lower</code> one, so its size will be (in general) the same than
 <code>upper</code> instead of the same size than <code>lower</code> like the method above.
 In fact, the size of <code>output</code> is like upper's one only when it can be
 painted on lower, if there has to be some clipping, output's size will
 be the clipped area and x and y will be set to the correct up-left corner
 where the clipped rectangle begins.
     
*/
	public static native boolean blend( int x, int y, QImage upper, QImage lower, QImage output);

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates <code>x</code> and <code>y</code> with respect to the lower image.
 The output is painted in the own <code>lower</code> image. This is an optimization
 of the blend method above provided by convenience.
     
*/
	public static native boolean blendOnLower( int x, int y, QImage upper, QImage lower);

/** 
 Modifies the intensity of a pixmap's RGB channel component.

*/
	public static native QImage channelIntensity( QImage image, float percent, int channel);

/** 
 Fade an image to a certain background color.

 The number of colors will not be changed.

*/
	public static native QImage fade( QImage img, float val, QColor color);

/** 
 This recolors a pixmap. The most dark color will become color a,
 the most bright one color b, and in between.

*/
	public static native QImage flatten( QImage image, QColor ca, QColor cb, int ncols);
	public static native QImage flatten( QImage image, QColor ca, QColor cb);

/** 
 Build a hash on any given {@link QImage}

*/
	public static native QImage hash( QImage image, int lite, int spacing);
	public static native QImage hash( QImage image);

/** 
 Either brighten or dim the image by a specified percent.
 For example, .50 will modify the colors by 50%.

*/
	public static native QImage intensity( QImage image, float percent);

/** 
 Modulate the image with a color channel of another image.

*/
	public static native QImage modulate( QImage image, QImage modImage, boolean reverse, int type, int factor, int channel);

/** 
 Convert an image to grayscale.

*/
	public static native QImage toGray( QImage image, boolean fast);
	public static native QImage toGray( QImage image);

/** 
 Desaturate an image evenly.

*/
	public static native QImage desaturate( QImage image, float desat);
	public static native QImage desaturate( QImage image);

/** 
 Fast, but low quality contrast of an image. Also see contrastHSV.

*/
	public static native QImage contrast( QImage image, int c);

/** 
 Dither an image using Floyd-Steinberg dithering for low-color
 situations.

*/
	public static native QImage dither( QImage img, QColor palette, int size);

/** 
 Calculate the image for a selected image, for instance a selected icon
 on the desktop.

*/
	public static native QImage selectedImage( QImage img, QColor col);

/** 
 High quality, expensive HSV contrast. You can do a faster one by just
 taking a intensity threshold (ie: 128) and incrementing RGB color
 channels above it and decrementing those below it, but this gives much
 better results.

*/
	public static native void contrastHSV( QImage img, boolean sharpen);
	public static native void contrastHSV( QImage img);

/** 
 Normalizes the pixel values to span the full range of color values.
 This is a contrast enhancement technique.

*/
	public static native void normalize( QImage img);

/** 
 Performs histogram equalization on the reference
 image.

*/
	public static native void equalize( QImage img);

/** 
 Thresholds the reference image. You can also threshold images by using
 ThresholdDither in the various QPixmap/QImage convert methods, but this
 lets you specify a threshold value.

*/
	public static native void threshold( QImage img, int value);
	public static native void threshold( QImage img);

/** 
 Produces a 'solarization' effect seen when exposing a photographic
 film to light during the development process.

*/
	public static native void solarize( QImage img, double factor);
	public static native void solarize( QImage img);

/** 
 Embosses the source image. This involves highlighting the edges
 and applying various other enhancements in order to get a metal
 effect.

*/
	public static native QImage emboss( QImage src);

/** 
 Minimizes speckle noise in the source image using the 8 hull
 algorithm.

*/
	public static native QImage despeckle( QImage src);

/** 
 Produces a neat little "charcoal" effect.

*/
	public static native QImage charcoal( QImage src, double factor);
	public static native QImage charcoal( QImage src);

/** 
 Rotates the image by the specified amount

*/
	public static native QImage rotate( QImage src, int r);

/** 
 Scales an image using simple pixel sampling. This does not produce
 nearly as nice a result as QImage.smoothScale(), but has the
 advantage of being much faster - only a few milliseconds.

*/
	public static native QImage sample( QImage src, int w, int h);

/** 
 Adds noise to an image.

*/
	public static native QImage addNoise( QImage src, int type);
	public static native QImage addNoise( QImage src);

/** 
 Blurs an image by convolving pixel neighborhoods.

*/
	public static native QImage blur( QImage src, double factor);
	public static native QImage blur( QImage src);

/** 
 Detects edges in an image using pixel neighborhoods and an edge
 detection mask.

*/
	public static native QImage edge( QImage src, double factor);
	public static native QImage edge( QImage src);

/** 
 Implodes an image by a specified percent.

*/
	public static native QImage implode( QImage src, double factor, int background);
	public static native QImage implode( QImage src);

/** 
 Produces an oil painting effect.

*/
	public static native QImage oilPaint( QImage src, int radius);
	public static native QImage oilPaint( QImage src);

/** 
 Sharpens the pixels in the image using pixel neighborhoods.

*/
	public static native QImage sharpen( QImage src, double factor);
	public static native QImage sharpen( QImage src);

/** 
 Randomly displaces pixels.

*/
	public static native QImage spread( QImage src, int amount);
	public static native QImage spread( QImage src);

/** 
 Shades the image using a distance light source.

*/
	public static native QImage shade( QImage src, boolean color_shading, double azimuth, double elevation);
	public static native QImage shade( QImage src);

/** 
 Swirls the image by a specified amount

*/
	public static native QImage swirl( QImage src, double degrees, int background);
	public static native QImage swirl( QImage src);

/** 
 Modifies the pixels along a sine wave.

*/
	public static native QImage wave( QImage src, double amplitude, double frequency, int background);
	public static native QImage wave( QImage src);
	public static final int VerticalGradient = 0;
	public static final int HorizontalGradient = 1;
	public static final int DiagonalGradient = 2;
	public static final int CrossDiagonalGradient = 3;
	public static final int PyramidGradient = 4;
	public static final int RectangleGradient = 5;
	public static final int PipeCrossGradient = 6;
	public static final int EllipticGradient = 7;
	public static final int Red = 0;
	public static final int Green = 1;
	public static final int Blue = 2;
	public static final int Gray = 3;
	public static final int All = 4;
	public static final int NorthLite = 0;
	public static final int NWLite = 1;
	public static final int WestLite = 2;
	public static final int SWLite = 3;
	public static final int SouthLite = 4;
	public static final int SELite = 5;
	public static final int EastLite = 6;
	public static final int NELite = 7;
	public static final int Intensity = 0;
	public static final int Saturation = 1;
	public static final int HueShift = 2;
	public static final int Contrast = 3;
	public static final int UniformNoise = 0;
	public static final int GaussianNoise = 0;
	public static final int MultiplicativeGaussianNoise = 1;
	public static final int ImpulseNoise = 2;
	public static final int LaplacianNoise = 3;
	public static final int PoissonNoise = 4;
	public static final int Rotate90 = 0;
	public static final int Rotate180 = 1;
	public static final int Rotate270 = 2;
}
