/***************************************************************************
                            KMultipleDrag.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.

 Instead of creating a specific class for each case (as would otherwise
 be necessary), you can simply create independent drag objects (e.g.
 a QImageDrag object and a KURLDrag object), and bundle them together
 using KMultipleDrag.

 Sample code for this:

 <pre>
 KMultipleDrag drag = new KMultipleDrag( parentWidget );
 drag.addDragObject( new QImageDrag( someQImage, null ) );
 drag.addDragObject( KURLDrag.newDrag( someKURL, null ) );
 drag.drag();
 </pre>

 Note that the drag objects added to the multiple drag become owned by it.
 For that reason their parent should be null.

 See {@link KMultipleDragSignals} for signals emitted by KMultipleDrag.

 

 @author David Faure <david@mandrakesoft.com>
 
 @short *
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.
*/
public class KMultipleDrag extends QDragObject  {
	protected KMultipleDrag(Class dummy){super((Class) null);}

	private native void newKMultipleDrag( QWidget dragSource, String name);

/** 
 Create a new KMultipleDrag object.

*/
	public KMultipleDrag( QWidget dragSource, String name) {
		super((Class) null);
		newKMultipleDrag( dragSource, name);
	}
	private native void newKMultipleDrag();
	public KMultipleDrag() {
		super((Class) null);
		newKMultipleDrag();
	}

/** 
 Call this to add each underlying drag object to the multiple drag object.
 The drag object should not have a parent because the multiple drag object
 will own it.

*/
	public native void addDragObject( QDragObject dragObject);

/**  
 Returns the data of a drag object with that supports the given
 mime type.

*/
	public native byte[] encodedData( String mime);

/** 
 Returns the <code>i</code>'th supported format, or 0.

*/
	public native String format( int i);
	protected native void virtual_hook( int identifier, int data);
}
