package org.kde.koala;
import org.kde.qt.*;


/** {@link KShellCompletion} emits these signals */
public interface KShellCompletionSignals {

/** 
 This signal is emitted, when calling {@link KShellCompletion#makeCompletion} and more than
 one matching item is found.

*/
	void multipleMatches();
	void destroyed( QObject obj );

/** 
 All matching items. Will be emitted by {@link KShellCompletion#makeCompletion} in shell-
 completion-mode, when the same string is passed to makeCompletion twice
 or more often.

*/
	void matches( String[] matchlist );

/** 
 The matching item. Will be emitted by {@link KShellCompletion#makeCompletion},
 {@link KShellCompletion#previousMatch} or {@link KShellCompletion#nextMatch}. May be String.null if there
 is no matching item.

*/
	void match( String item );
}

