/***************************************************************************
                            KSqueezedTextLabel.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A label class that squeezes its text into the label

 If the text is too long to fit into the label it is divided into
 remaining left and right parts which are separated by three dots.

 Example:
 http://www.kde.org/documentation/index.html could be squeezed to
 http://www.kde...ion/index.html

 
 See {@link KSqueezedTextLabelSignals} for signals emitted by KSqueezedTextLabel.

 

 @author Ronny Standtke <Ronny.Standtke@gmx.de>

 @version $Id: KSqueezedTextLabel.java,v 1.6 2002/11/26 04:17:34 rdale Exp $

 @short A replacement for QLabel that squeezes its text.
*/
public class KSqueezedTextLabel extends QLabel  {
	protected KSqueezedTextLabel(Class dummy){super((Class) null);}

	private native void newKSqueezedTextLabel( QWidget parent, String name);

/** 
 Default constructor.
   
*/
	public KSqueezedTextLabel( QWidget parent, String name) {
		super((Class) null);
		newKSqueezedTextLabel( parent, name);
	}
	private native void newKSqueezedTextLabel( QWidget parent);
	public KSqueezedTextLabel( QWidget parent) {
		super((Class) null);
		newKSqueezedTextLabel( parent);
	}
	private native void newKSqueezedTextLabel( String text, QWidget parent, String name);
	public KSqueezedTextLabel( String text, QWidget parent, String name) {
		super((Class) null);
		newKSqueezedTextLabel( text, parent, name);
	}
	private native void newKSqueezedTextLabel( String text, QWidget parent);
	public KSqueezedTextLabel( String text, QWidget parent) {
		super((Class) null);
		newKSqueezedTextLabel( text, parent);
	}
	public native QSize minimumSizeHint();
	public native void setText( String arg1);

/** 
 used when widget is resized
   
*/
	protected native void resizeEvent( QResizeEvent arg1);

/** 
 does the dirty work
   
*/
	protected native void squeezeTextToLabel();
	protected native void virtual_hook( int identifier, int data);
}
