/***************************************************************************
                            FileCopyJob.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef FILECOPYJOB_H
#define FILECOPYJOB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Job.h>

/**

 The FileCopyJob copies data from one place to another.
     
 @short 
 The FileCopyJob copies data from one place to another.
*/
@class KURL; 
@class SimpleJob; 

@interface FileCopyJob : Job 
- initWithURL: (KURL*)src dest: (KURL*)dest permissions: (int)permissions move: (BOOL)move overwrite: (BOOL)overwrite resume: (BOOL)resume showProgressInfo: (BOOL)showProgressInfo;
- (void) dealloc;

/** 
 If you know the size of the source file, call this method
 to inform this job. It will be displayed in the "resume" dialog.
         
*/
//- setSourceSize: (off_t)size;
- (KURL*) srcURL;
- (KURL*) destURL;
- slotStart;
- slotData: (Job*)arg1 data: (QByteArray*)data;
- slotDataReq: (Job*)arg1 data: (QByteArray*)data;
- startCopyJob;
- startCopyJob: (KURL*)slave_url;
- startDataPump;
- connectSubjob: (SimpleJob*)job;

/** 
 Called whenever a subjob finishes.
         
*/
- slotResult: (Job*)job;

/** 
 Forward signal from subjob
         
*/
- slotProcessedSize: (Job*)arg1 size: (unsigned long)size;

/** 
 Forward signal from subjob
         
*/
- slotTotalSize: (Job*)arg1 size: (unsigned long)size;

/** 
 Forward signal from subjob
         
*/
- slotPercent: (Job*)arg1 pct: (unsigned long)pct;

/** 
 Forward signal from subjob
         
*/
- slotCanResume: (Job*)arg1 offset: (unsigned long)offset;
@end

/** Override these methods in subclasses of FileCopyJob to customise event handling behaviour */
@protocol FileCopyJobEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
