/***************************************************************************
                            KAudioPlayer.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KAUDIOPLAYER_H
#define KAUDIOPLAYER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 This class provides one-shot-and-forget audio playing. You will never
 know if what you wanted to play really got played.

 It doesn't require linking any special libraries, as it operates over
 DCOP. In the current implementation, it only indirectly communicates
 with the aRts soundserver, using knotify as -[DCOP MCOP]bridge.

 Due to that fact, if you need "fast" response times, more control or
 feedback, use the MCOP interfaces rather than this.

 An example of using this class is:

 <pre>
   -[KAudioPlayer play]("/var/share/foo.wav");
 </pre>

 If you want to use signals & slots, you can do something like:

 <pre>
   KAudioPlayer player("/var/share/foo.wav");
   connect(&button, SIGNAL(-clicked), &player, SLOT(-play));
 </pre>

 
 @short 
 This class provides one-shot-and-forget audio playing.
*/
@interface KAudioPlayer : QObject 

/** 
 Constructor.

*/
- initWithText: (NSString *)filename parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)filename ;

/** 
 Destructor.
	 
*/
- (void) dealloc;

/** 
 Play function as slot.

 Plays the soundfile given to the constructor.
	 
*/
- play;

/** 
 Static play function.

*/
+ play: (NSString *)filename;
@end

/** Override these methods in subclasses of KAudioPlayer to customise event handling behaviour */
@protocol KAudioPlayerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
