/***************************************************************************
                            SshProcess.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef SSHPROCESS_H
#define SSHPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/StubProcess.h>

/**

 Executes a remote command, using ssh.
 
 @short 
 Executes a remote command, using ssh.
*/
@interface SshProcess : StubProcess 
- initWithText: (NSString *)host user: (NSString *)user command: (NSString *)command;
- init;
- (void) dealloc;

/**  Sets the target host. 
*/
- setHost: (NSString *)host;

/**  Sets the localtion of the remote stub. 
*/
- setStub: (NSString *)stub;

/**  
 Checks if the current user@host needs a password. 

*/
- (int) checkNeedPassword;

/** 
 Checks if the stub is installed and if the password is correct.

*/
- (int) checkInstall: (NSString *)password;

/**  Executes the command. 
*/
- (int) exec: (NSString *)password check: (int)check;
- (int) exec: (NSString *)password ;
- (NSString *) prompt;
- (NSString *) error;
- (NSString *) display;
- (NSString *) displayAuth;
- (NSString *) dcopServer;
+ (int) SshNotFound;
+ (int) SshNeedsPassword;
+ (int) SshIncorrectPassword;
@end

#endif
