namespace Binge.Generators.CSharp
{
	using System;
	using System.Collections;
	using Binge.Bits;

	public class Converter: Binge.Generators.Converter
	{
		private Hashtable types, reserved;

		public Converter ()
		{
			types = new Hashtable ();
			reserved = new Hashtable ();

			// Native types
			types.Add ("void", "void");
			types.Add ("uchar", "string");
			types.Add ("unsigned int", "uint");
			types.Add ("unsigned short", "ushort");
			types.Add ("unsigned long", "ulong");
			types.Add ("unsigned char", "string");
			types.Add ("HANDLE", "uint");

			// Reserved keywords.
			reserved.Add ("lock", "_lock");
			reserved.Add ("object", "_object");
			reserved.Add ("ref", "_ref");
			reserved.Add ("base", "_base");
			reserved.Add ("string", "_string");
			reserved.Add ("const", "_const");
			reserved.Add ("event", "_event");
		}

		public override void Convert (Interface iface)
		{
			iface.TargetName = ToPascalCase (iface.NativeName);
		}

		public override void Convert (Class klass)
		{
			klass.TargetName = ToPascalCase (klass.NativeName);
		}

		public override void Convert (Binge.Bits.Enum enm)
		{
			enm.TargetName = ToPascalCase (enm.NativeName);
		}

		void Convert (MemberBase member)
		{
			//FIXME Really ugly ;p
			if (member is Method) {
				if (!(member as Method).IsExtern)
					member.TargetName = ToPascalCase (member.NativeName);
			} else
				member.TargetName = ToPascalCase (member.NativeName);
		}

		public override void Convert (Field field)
		{
			Convert (field as MemberBase);
			field.TargetType = MapType (field.NativeType);
		}

		public override void Convert (Property prop)
		{
			Convert (prop as Field);
			Convert (prop.Underlying);
		}

		void Convert (Parameter param)
		{
			param.TargetType = MapType (param.NativeType);
			param.TargetName = MapName (param.NativeName);

			if (param.PassBy == PassingConvention.PointerToPointer)
				param.TargetType = (param.TargetType != String.Empty ?
					param.TargetType : param.NativeType) + "[]";

			// Take note of where these are used to learn how to handle them.
			if (param.TargetName == "Type")
				Errl ("{0}: Asked to convert type Type", this);
		}

		void ConvertMarshall (Parameter param)
		{
			if (param.PassBy == PassingConvention.Pointer)
			{
				switch (param.NativeType)
				{
				// Take note of where these are used to decide how to handle them.
				case "FILE":
					Errl ("{0}: Asked to convert type FILE*", this);
					break;
				case "void":
					Errl ("{0}: Asked to convert type void*", this);
					break;
				case "char":
					param.MarshallType = "string";
					// FIXME *char can be &char or char[]
					break;
				// FIXME
				case "int":
				case "bool":
				case "ushort":
				default:
					param.MarshallType = "IntPtr";
					param.MarshallName = (param.TargetName != String.Empty ?
						param.TargetName : param.NativeName) + ".Handle";
					break;
				}
			}
			else if (param.PassBy == PassingConvention.PointerToPointer)
			{
				// FIXME
			}
		}

		void Convert (MethodBase method)
		{
			Convert (method as MemberBase);
			Convert (method.Returns);
			ConvertOverloads (method);

			if (method is Method)
			{
				Method m = method as Method;
    			if (m.IsExtern) // FIXME pinvokes and icalls are the only use of extern, right?
					foreach (Parameter param in method.Parameters)
						ConvertMarshall (param);
			}
			else
				foreach (Parameter param in method.Parameters)
					Convert (param);
		}

		public override void Convert (Constructor ctor)
		{
			Convert (ctor as MethodBase);
		}

		public override void Convert (Destructor dtor)
		{
			Convert (dtor as MethodBase);
		}

		public override void Convert (Method method)
		{
			Convert (method as MethodBase);
		}
		
		void ConvertOverloads (MethodBase method)
		{
			//FIXME Should convert param defaults for CSharp
		}

		string MapType (string str)
		{
			return types.Contains (str) ?
				types[str] as string : String.Empty;
		}

		string MapName (string str)
		{
			return reserved.Contains (str) ?
				reserved[str] as string : str;
		}

		string ToPascalCase (string str)
		{
			if (! UsePascalCase || str.Length == 0)
				return String.Empty;

			char[] cstr = str.ToCharArray ();
			cstr[0] = Char.ToUpper (cstr[0]);

			string nstr = new String (cstr);

			if (nstr == str)
				return String.Empty;

			return nstr;
		}
	}
}
