/***************************************************************************
                          keducaview.h  -  description
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDUCAVIEW_H
#define KEDUCAVIEW_H

#include "fileread.h"
#include "kquestion.h"
#include "kgroupeduca.h"

#include <kurl.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qtextview.h>

class QTimer;

/**Main view of keduca file (questions and answers)
   This is the widget for asking questions and allowing selection of answers
   as used by KEduca TestMaster (class KEduca)
 *@author Javier Campos
 */

class KEducaView : public QWidget  {
    Q_OBJECT

public:
    KEducaView(QWidget *parent=0, const char *name=0);
    ~KEducaView();
    /** Open url */
    bool openURL( const KURL &url);
    FileRead const *getKeducaFile() const {return _keducaFile; };
private: // Private methods
    /** Init graphical interface */
    void init();
    /** Show record, returns false if there is no record to show. */
    bool showRecord();
    /** Show results */
    void showResults( const QString &text );
    /** Set results */
    void setResults();
    /** Write settings */
    void configWrite();
    /** Read settings */
    void configRead();

private: // Private attributes
    /** Button next */
    QPushButton *_buttonNext;
    /** Group of answers. This is a frame an check or radio buttons. */
    KGroupEduca *_buttonGroup;
    /** KEDUCA file */
    FileRead *_keducaFile;
    /** A question text with pixmaps and movies support */
    KQuestion *_questionText;
    /** A question text with pixmaps and movies support */
    QTextView *_viewResults;
    /** Current record */
    int _keducaFileIndex;
    /** Current results */
    QString _results;
    /** Num of correct answers */
    int _correctAnswer;
    /** Number of incorrect answers */
    int _incorrectAnswer;
    /** Main vbox */
    QVBoxLayout *_vbox2;
    /** Main splitt */
    QSplitter *_split;
    /** Current results */
    QString _currentResults;
    /** Show results when finish? */
    bool _showResultFinish;
    QTimer *_timeoutTimer;

private slots: // Private slots
    /** Button Next action */
    void slotButtonNext();
    void questionTimedOut();
};

#endif
