/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmpovraymatrix.h"
#include "pmpovraymatrixedit.h"

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

PMPovrayMatrix::PMPovrayMatrix( )
      : Base( )
{
   m_values = PMVector( 12 );
   m_values[0] = 1.0;
   m_values[4] = 1.0;
   m_values[8] = 1.0;
}

PMPovrayMatrix::~PMPovrayMatrix( )
{
}

QString PMPovrayMatrix::description( ) const
{
   return i18n( "matrix" );
}

void PMPovrayMatrix::serialize( PMOutputDevice& dev ) const
{
   dev.writeLine( QString( "matrix < %1, %2, %3," ).arg( m_values[0] )
                  .arg( m_values[1] ).arg( m_values[2] ) );
   dev.writeLine( QString( "         %1, %2, %3," ).arg( m_values[3] )
                  .arg( m_values[4] ).arg( m_values[5] ) );
   dev.writeLine( QString( "         %1, %2, %3," ).arg( m_values[6] )
                  .arg( m_values[7] ).arg( m_values[8] ) );
   dev.writeLine( QString( "         %1, %2, %3 >" ).arg( m_values[9] )
                  .arg( m_values[10] ).arg( m_values[11] ) );
}

void PMPovrayMatrix::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "value", m_values.serializeXML( ) );
}

void PMPovrayMatrix::readAttributes( const PMXMLHelper& h )
{
   PMVector d = PMVector( 12 );
   d[0] = 1.0;
   d[4] = 1.0;
   d[8] = 1.0;

   m_values = h.vectorAttribute( "value", d );
   m_values.resize( 12 );
}

bool PMPovrayMatrix::isA( PMObjectType t ) const
{
   if( t == PMTMatrix )
      return true;
   return Base::isA( t );
}

void PMPovrayMatrix::setValues( const PMVector& v )
{
   if( v != m_values )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTMatrix, PMMatrixID, m_values );
         m_pMemento->setViewStructureChanged( );
      }
      m_values = v;
      m_values.resize( 12 );
   }
}

PMDialogEditBase* PMPovrayMatrix::editWidget( QWidget* parent ) const
{
   return new PMPovrayMatrixEdit( parent );
}

void PMPovrayMatrix::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTMatrix )
      {
         switch( data->valueID( ) )
         {
            case PMMatrixID:
               setValues( data->vectorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMPovrayMatrix::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

PMMatrix PMPovrayMatrix::transformationMatrix( ) const
{
   PMMatrix m;
   int l, c;

   for( l = 0; l < 4; l++ )
      for( c = 0; c < 3; c++ )
         m[l][c] = m_values[l*3+c];
   m[3][3] = 1.0;
   
   return m;
}

