/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmpovrayoutputwidget.h"

#include <qmultilineedit.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kglobalsettings.h>
#include <kconfig.h>

QSize PMPovrayOutputWidget::s_size = QSize( 400, 400 );

PMPovrayOutputWidget::PMPovrayOutputWidget( QWidget* parent, const char* name )
      : KDialog( parent, name )
{
   QVBoxLayout* topLayout = new QVBoxLayout( this, KDialog::marginHint( ), KDialog::spacingHint( ) );

   m_pTextView = new QMultiLineEdit( this );
   topLayout->addWidget( m_pTextView, 1 );
   m_pTextView->setFont( KGlobalSettings::fixedFont( ) );
   m_pTextView->setReadOnly( true );

   QHBoxLayout* buttonLayout = new QHBoxLayout( topLayout );
   buttonLayout->addStretch( 1 );
   QPushButton* closeButton = new QPushButton( i18n( "Close" ), this );
   buttonLayout->addWidget( closeButton );
   closeButton->setDefault( true );
   connect( closeButton, SIGNAL( clicked( ) ), SLOT( hide( ) ) );

   setCaption( i18n( "Povray Output" ) );
   resize( s_size );

   m_bLineFinished = true;
}

PMPovrayOutputWidget::~PMPovrayOutputWidget( )
{
}

void PMPovrayOutputWidget::slotClear( )
{
   m_pTextView->clear( );
   m_bLineFinished = true;
}

void PMPovrayOutputWidget::slotText( const QString& output )
{
   QString tmp;
   
   if( !m_bLineFinished )
   {
      int nl = m_pTextView->numLines( );
      if( nl > 0 )
      {
         tmp = m_pTextView->textLine( nl - 1 );
         m_pTextView->removeLine( nl - 1 );
      }
      tmp += output;
   }
   else
      tmp = output;

   m_pTextView->append( tmp );
   
   m_bLineFinished =
      tmp[ tmp.length( ) - 1 ].category( ) == QChar::Separator_Line;
}

void PMPovrayOutputWidget::slotClose( )
{
   hide( );
}


void PMPovrayOutputWidget::saveConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );
   cfg->writeEntry( "PovrayOutputWidgetSize", s_size );
}

void PMPovrayOutputWidget::restoreConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );

   QSize defaultSize( 500, 400 );
   s_size = cfg->readSizeEntry( "PovrayOutputWidgetSize", &defaultSize );
}

void PMPovrayOutputWidget::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

#include "pmpovrayoutputwidget.moc"
