/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <time.h> /* for time_t */

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkitemfactory.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenushell.h>

#include <pan/base/pan-glib-extensions.h> /* for PRETTY_FUNCTION */

/*---------------------------------------------------------------------------
**
**  UI LOCKING FOR THREADS
*/

/**
 * Used to lock the UI thread.
 *
 * @see pan_unlock
 */
#define pan_lock() pan_lock_from(__FILE__, PRETTY_FUNCTION, __LINE__)
void pan_lock_from (const char * file, const char * func, int line);


/**
 * Used to unlock the UI thread after pan_lock() has been called.
 *
 * @see pan_lock
 * @see pan_unlock_unconditional
 */
#define pan_unlock() pan_unlock_from(__FILE__, PRETTY_FUNCTION, __LINE__)
void pan_unlock_from (const char * file, const char * func, int line);



void pan_info_dialog (const char * fmt, ...);

void pan_error_dialog (const char * fmt, ...);

void pan_error_dialog_parented (gpointer gtkwindow, const char * fmt, ...);

void replace_gstr (char ** target_free_old, char * assign_from_me);

void get_date_display_string (time_t date, const char * strftime_fmt, char * buf, int size);

void pan_url_show (const char * url);

guint pan_timeout_add   (guint32            interval,
                         GtkFunction        function,
			 gpointer           data);

/**
***  Menu Building
**/

GtkWidget* menubar_create     (GtkWidget             * window,
                               GtkItemFactoryEntry   * entries,
                               unsigned int            entries_qty,
                               const char            * path,
                               gpointer                data);

GtkWidget* menu_create_items  (GtkItemFactoryEntry  * entries,
                               unsigned int           entries_qty,
                               const char           * path,
                               GtkItemFactory      ** factory,
                               gpointer               data);

void menu_set_sensitive       (GtkItemFactory       * ifactory,
                               const char           * path,
                               gboolean               sensitive);

void menu_set_checked         (GtkItemFactory       * ifactory,
                               const char           * path,
                               gboolean               checked);

gboolean menu_is_checked      (GtkItemFactory       * ifactory,
                               const char           * path);

void menu_set_insensitive_all (GtkMenuShell         * menu_shell);

void pan_gtk_entry_set_text   (GtkWidget            * w,
                               const char           * text);

void pan_hig_frame_new        (const char           * title,
                               GtkWidget           ** setme_container,
                               GtkWidget           ** setme_vbox);

#define GUI_PAD_SMALL 3
#define GUI_PAD 6
#define GUI_PAD_BIG 12
#define GUI_PAD_LARGE 12

/*Signature parsing code*/
#define SIG_STANDARD 		1
#define SIG_NON_STANDARD 	2
#define SIG_NONE 		  (-1)

/* Maximum number of lines below an ill-formed signature */
#define SIG_THRESHOLD 6

int pan_is_signature_delimitor (const char			* line,
								const int			line_len);

gboolean pan_remove_signature (char 				* body);
#endif /* __UTIL_H__ */
