/*
  ImageMagick Drawing Wand API.
*/
#ifndef _MAGICK_DRAWING_WAND_H
#define _MAGICK_DRAWING_WAND_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include "magick/render.h"

typedef struct _DrawingWand *DrawContext;

typedef struct _DrawingWand DrawingWand;

extern MagickExport ClipPathUnits
  DrawGetClipUnits(DrawingWand *);

extern MagickExport DrawContext
  DrawAllocateContext(const DrawInfo *,Image *);

extern MagickExport DrawInfo
  *DrawPeekGraphicContext(const DrawingWand *);

extern MagickExport DecorationType
  DrawGetTextDecoration(DrawingWand *);

extern MagickExport DrawingWand
  *NewDrawingWand(void);

extern MagickExport DrawingWand
  *DrawAllocateWand(const DrawInfo *,Image *);

extern MagickExport FillRule
  DrawGetClipRule(DrawingWand *),
  DrawGetFillRule(DrawingWand *);

extern MagickExport GravityType
  DrawGetGravity(DrawingWand *);

extern MagickExport LineCap
  DrawGetStrokeLineCap(DrawingWand *);

extern MagickExport LineJoin
  DrawGetStrokeLineJoin(DrawingWand *);

extern MagickExport PixelPacket
  DrawGetFillColor(DrawingWand *),
  DrawGetStrokeColor(DrawingWand *),
  DrawGetTextUnderColor(DrawingWand *);

extern MagickExport StretchType
  DrawGetFontStretch(DrawingWand *);

extern MagickExport StyleType
  DrawGetFontStyle(DrawingWand *);

extern MagickExport char
  *DrawGetClipPath(DrawingWand *),
  *DrawGetFont(DrawingWand *),
  *DrawGetFontFamily(DrawingWand *),
  *DrawGetTextEncoding(DrawingWand *);

extern MagickExport unsigned int
  DrawGetStrokeAntialias(DrawingWand *),
  DrawGetTextAntialias(DrawingWand *),
  DrawRender(const DrawingWand *);

extern MagickExport unsigned long
  DrawGetFontWeight(DrawingWand *),
  DrawGetStrokeMiterLimit(DrawingWand *);

extern MagickExport double
  DrawGetFillOpacity(DrawingWand *),
  DrawGetFontSize(DrawingWand *),
  *DrawGetStrokeDashArray(DrawingWand *,size_t *),
  DrawGetStrokeDashOffset(DrawingWand *),
  DrawGetStrokeOpacity(DrawingWand *),
  DrawGetStrokeWidth(DrawingWand *);

extern MagickExport void
  DrawAffine(DrawingWand *,const AffineMatrix *),
  DrawAnnotation(DrawingWand *,const double, const double,
    const unsigned char *),
  DrawArc(DrawingWand *,const double,const double,const double,const double,
	  const double,const double),
  DrawBezier(DrawingWand *,const size_t,const PointInfo *),
  DrawCircle(DrawingWand *,const double,const double,const double,const double),
  DrawColor(DrawingWand *,const double,const double,const PaintMethod),
  DrawComment(DrawingWand *,const char *),
  DrawDestroyContext(DrawContext),
  DestroyDrawingWand(DrawingWand *),
  DrawEllipse(DrawingWand *,const double,const double,const double,const double,
	  const double,const double),
  DrawComposite(DrawingWand *,const CompositeOperator,const double,const double,
	  const double,const double,const Image *),
  DrawLine(DrawingWand *,const double, const double,const double,const double),
  DrawMatte(DrawingWand *,const double,const double,const PaintMethod),
  DrawPathClose(DrawingWand *),
  DrawPathCurveToAbsolute(DrawingWand *,const double,const double,const double,
	  const double,const double,const double),
  DrawPathCurveToRelative(DrawingWand *,const double,const double,const double,
	  const double,const double, const double),
  DrawPathCurveToQuadraticBezierAbsolute(DrawingWand *,const double,
    const double,const double,const double),
  DrawPathCurveToQuadraticBezierRelative(DrawingWand *,const double,
    const double,const double,const double),
  DrawPathCurveToQuadraticBezierSmoothAbsolute(DrawingWand *,const double,
    const double),
  DrawPathCurveToQuadraticBezierSmoothRelative(DrawingWand *,const double,
    const double),
  DrawPathCurveToSmoothAbsolute(DrawingWand *,const double,const double,
    const double,const double),
  DrawPathCurveToSmoothRelative(DrawingWand *,const double,const double,
    const double,const double),
  DrawPathEllipticArcAbsolute(DrawingWand *,const double,const double,
    const double,unsigned int,unsigned int,const double,const double),
  DrawPathEllipticArcRelative(DrawingWand *,const double,const double,
    const double,unsigned int,unsigned int,const double,const double),
  DrawPathFinish(DrawingWand *),
  DrawPathLineToAbsolute(DrawingWand *,const double,const double),
  DrawPathLineToRelative(DrawingWand *,const double,const double),
  DrawPathLineToHorizontalAbsolute(DrawingWand *,const double),
  DrawPathLineToHorizontalRelative(DrawingWand *,const double),
  DrawPathLineToVerticalAbsolute(DrawingWand *,const double),
  DrawPathLineToVerticalRelative(DrawingWand *,const double),
  DrawPathMoveToAbsolute(DrawingWand *,const double,const double),
  DrawPathMoveToRelative(DrawingWand *,const double,const double),
  DrawPathStart(DrawingWand *),
  DrawPoint(DrawingWand *,const double,const double),
  DrawPolygon(DrawingWand *,const size_t,const PointInfo *),
  DrawPolyline(DrawingWand *,const size_t,const PointInfo *),
  DrawPopClipPath(DrawingWand *),
  DrawPopDefs(DrawingWand *),
  DrawPopGraphicContext(DrawingWand *),
  DrawPopPattern(DrawingWand *),
  DrawPushClipPath(DrawingWand *,const char *),
  DrawPushDefs(DrawingWand *),
  DrawPushGraphicContext(DrawingWand *),
  DrawPushPattern(DrawingWand *,const char *,const double,const double,
    const double,const double),
  DrawRectangle(DrawingWand *,const double,const double,const double,
    const double),
  DrawRoundRectangle(DrawingWand *,double,double,double,double,double,double),
  DrawScale(DrawingWand *,const double,const double),
  DrawSetClipPath(DrawingWand *,const char *),
  DrawSetClipRule(DrawingWand *,const FillRule),
  DrawSetClipUnits(DrawingWand *,const ClipPathUnits),
  DrawSetFillColor(DrawingWand *,const PixelPacket *),
  DrawSetFillColorString(DrawingWand *,const char *),
  DrawSetFillOpacity(DrawingWand *,const double),
  DrawSetFillRule(DrawingWand *,const FillRule),
  DrawSetFillPatternURL(DrawingWand *,const char *),
  DrawSetFont(DrawingWand *,const char *),
  DrawSetFontFamily(DrawingWand *,const char *),
  DrawSetFontSize(DrawingWand *,const double),
  DrawSetFontStretch(DrawingWand *,const StretchType),
  DrawSetFontStyle(DrawingWand *,const StyleType),
  DrawSetFontWeight(DrawingWand *,const unsigned long),
  DrawSetGravity(DrawingWand *,const GravityType),
  DrawRotate(DrawingWand *,const double),
  DrawSkewX(DrawingWand *,const double),
  DrawSkewY(DrawingWand *,const double),
  DrawSetStrokeAntialias(DrawingWand *,const unsigned int),
  DrawSetStrokeColor(DrawingWand *,const PixelPacket *),
  DrawSetStrokeColorString(DrawingWand *, const char *),
  DrawSetStrokeDashArray(DrawingWand *,const size_t,const double *),
  DrawSetStrokeDashOffset(DrawingWand *,const double dashoffset),
  DrawSetStrokeLineCap(DrawingWand *,const LineCap),
  DrawSetStrokeLineJoin(DrawingWand *,const LineJoin),
  DrawSetStrokeMiterLimit(DrawingWand *,const unsigned long),
  DrawSetStrokeOpacity(DrawingWand *, const double),
  DrawSetStrokePatternURL(DrawingWand *,const char *),
  DrawSetStrokeWidth(DrawingWand *,const double),
  DrawSetTextAntialias(DrawingWand *,const unsigned int),
  DrawSetTextDecoration(DrawingWand *,const DecorationType),
  DrawSetTextEncoding(DrawingWand *,const char *),
  DrawSetTextUnderColor(DrawingWand *,const PixelPacket *),
  DrawSetTextUnderColorString(DrawingWand *,const char *),
  DrawSetViewbox(DrawingWand *,unsigned long,unsigned long,unsigned long,
	  unsigned long),
  DrawTranslate(DrawingWand *,const double,const double);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
