/* This file is generated by python scripts. Don't edit this file directly.
 */

#ifndef __PY_LIB_PINYIN_EMOJI_TABLE_H
#define __PY_LIB_PINYIN_EMOJI_TABLE_H

namespace PY{

typedef struct {
    const char * m_emoji_match;
    const char * m_emoji_string;
} EmojiItem;

const EmojiItem english_emoji_table[] = {
"a"       , "🅰",
"ab"      , "🆎",
"abacus"  , "🧮",
"abc"     , "🔤",
"abcd"    , "🔡",
"access"  , "♿",
"actor"   , "🧑‍🎤",
"adore"   , "🥰",
"adult"   , "🧑",
"aerial"  , "🚡",
"afro"    , "🦱",
"aid"     , "⛑",
"alarm"   , "⏰",
"alien"   , "👽",
"alpaca"  , "🦙",
"amoeba"  , "🦠",
"anchor"  , "⚓",
"angel"   , "😇",
"angry"   , "😡",
"ant"     , "🐜",
"ape"     , "🦧",
"apple"   , "🍎",
"archer"  , "🏹",
"arctic"  , "🐻‍❄",
"arepa"   , "🫓",
"army"    , "🪖",
"arrow"   , "💘",
"art"     , "🎭",
"artist"  , "🧑‍🎨",
"ashes"   , "⚱",
"ask"     , "🙏",
"atm"     , "🏧",
"atom"    , "⚛",
"autumn"  , "🥮",
"axe"     , "🪓",
"b"       , "🅱",
"baby"    , "👶",
"back"    , "🔙",
"bacon"   , "🥓",
"badge"   , "📛",
"badger"  , "🦡",
"bag"     , "👜",
"bagel"   , "🥯",
"bait"    , "🪤",
"bakery"  , "🥯",
"bald"    , "🦲",
"ball"    , "🏌",
"ballet"  , "🩰",
"ballot"  , "🗳",
"bamboo"  , "🎍",
"banana"  , "🍌",
"banjo"   , "🪕",
"bank"    , "🏦",
"banner"  , "🎋",
"bar"     , "🍫",
"barber"  , "💇",
"basket"  , "🧺",
"bat"     , "🦇",
"bath"    , "🛀",
"beach"   , "🏖",
"beacon"  , "🚨",
"bead"    , "🧿",
"beads"   , "📿",
"bear"    , "🐻",
"beard"   , "🧔",
"bearer"  , "🐍",
"beat"    , "🪘",
"beauty"  , "💇",
"beaver"  , "🦫",
"bed"     , "🛏",
"bee"     , "🐝",
"beer"    , "🍺",
"beetle"  , "🪲",
"bell"    , "🛎",
"bento"   , "🍱",
"berry"   , "🫐",
"biceps"  , "💪",
"bike"    , "🚵",
"biking"  , "🚴",
"bikini"  , "👙",
"bill"    , "💴",
"bird"    , "🪶",
"birdie"  , "🏸",
"bison"   , "🦬",
"bisque"  , "🦞",
"black"   , "🖤",
"bleed"   , "🩸",
"blind"   , "🧑‍🦯",
"blond"   , "👱",
"blonde"  , "👱‍♀",
"blow"    , "🍃",
"blue"    , "🫐",
"blush"   , "😊",
"boar"    , "🐗",
"board"   , "🛹",
"boat"    , "🚣",
"body"    , "👂",
"bolt"    , "🔩",
"bomb"    , "💣",
"bone"    , "🦴",
"book"    , "📔",
"books"   , "📚",
"boom"    , "💥",
"boot"    , "🥾",
"bored"   , "🥱",
"boring"  , "🪴",
"bottle"  , "🍼",
"bow"     , "🙇",
"bowing"  , "🙇‍♂",
"bowl"    , "🍜",
"box"     , "🍱",
"boxing"  , "🥊",
"boy"     , "👦",
"brain"   , "🧠",
"bread"   , "🍞",
"break"   , "💔",
"breast"  , "🤱",
"breath"  , "🫁",
"brick"   , "🧱",
"bricks"  , "🧱",
"bride"   , "👰",
"bridge"  , "🌉",
"briefs"  , "🩲",
"bright"  , "😎",
"broken"  , "💔",
"bronze"  , "🥉",
"broom"   , "🧹",
"brown"   , "🤎",
"brush"   , "🪥",
"bubble"  , "🧋",
"bucket"  , "🪣",
"bug"     , "🪲",
"bulb"    , "💡",
"bull"    , "🐂",
"bullet"  , "🚅",
"bunny"   , "🐰",
"burger"  , "🍔",
"bus"     , "🚌",
"bust"    , "👤",
"butter"  , "🧈",
"button"  , "🔼",
"c"       , "©",
"cable"   , "🚠",
"cactus"  , "🌵",
"cake"    , "🍥",
"call"    , "🤙",
"camel"   , "🐪",
"camera"  , "🤳",
"can"     , "🥫",
"cancel"  , "✖",
"candle"  , "🕯",
"candy"   , "🍬",
"canoe"   , "🛶",
"cap"     , "👲",
"car"     , "🚃",
"card"    , "♠",
"care"    , "💅",
"carp"    , "🎏",
"carrot"  , "🥕",
"cart"    , "🛒",
"cask"    , "🪣",
"castle"  , "🏯",
"cat"     , "😺",
"catch"   , "🪝",
"cd"      , "💿",
"cell"    , "📱",
"cereal"  , "🥣",
"chain"   , "⛓",
"chains"  , "⛓",
"chair"   , "💺",
"chapel"  , "💒",
"charm"   , "🧿",
"chart"   , "💹",
"check"   , "✅",
"cheese"  , "🫕",
"chef"    , "🧑‍🍳",
"cherry"  , "🌸",
"chess"   , "♟",
"chest"   , "🧰",
"chick"   , "🐣",
"child"   , "🧒",
"chime"   , "🎐",
"chop"    , "🥩",
"church"  , "⛪",
"cinema"  , "🎥",
"circle"  , "⏺",
"circus"  , "🎪",
"citrus"  , "🍋",
"city"    , "🏙",
"cl"      , "🆑",
"claim"   , "🛄",
"clamp"   , "🗜",
"clap"    , "👏",
"claus"   , "🎅",
"claws"   , "🦞",
"clay"    , "🧱",
"clean"   , "🪥",
"climb"   , "🪜",
"clink"   , "🍻",
"clock"   , "⌚",
"closed"  , "😚",
"closet"  , "🚾",
"cloud"   , "☁",
"clover"  , "🍀",
"clown"   , "🤡",
"clue"    , "🧩",
"coat"    , "🧥",
"coder"   , "🧑‍💻",
"coffee"  , "☕",
"coffin"  , "⚰",
"cog"     , "⚙",
"coin"    , "🪙",
"cold"    , "😅",
"comet"   , "☄",
"comic"   , "💢",
"conga"   , "🪘",
"congee"  , "🥣",
"cook"    , "🧑‍🍳",
"cooked"  , "🍚",
"cookie"  , "🍪",
"cool"    , "😎",
"cop"     , "👮",
"cork"    , "🍾",
"corn"    , "🌽",
"couch"   , "🛋",
"couple"  , "🧑‍🤝‍🧑",
"cover"   , "📔",
"cow"     , "🐮",
"cowboy"  , "🤠",
"crab"    , "🦀",
"crayon"  , "🖍",
"cream"   , "🍦",
"credit"  , "💳",
"crook"   , "🪝",
"cross"   , "🤞",
"crown"   , "👑",
"crush"   , "🥰",
"cry"     , "😢",
"cup"     , "🍵",
"cupid"   , "💘",
"curl"    , "📃",
"curly"   , "🦱",
"curry"   , "🍛",
"curve"   , "🪝",
"cygnet"  , "🦢",
"dagger"  , "🗡",
"dairy"   , "🧈",
"dam"     , "🦫",
"dance"   , "🕺",
"dancer"  , "👯",
"danger"  , "⚡",
"dango"   , "🍡",
"dark"    , "🌑",
"dart"    , "🎯",
"dash"    , "💨",
"date"    , "📅",
"dazed"   , "😳",
"deaf"    , "🧏",
"death"   , "💀",
"deer"    , "🦌",
"demon"   , "👿",
"dental"  , "🪥",
"desert"  , "🏜",
"devil"   , "👿",
"dharma"  , "☸",
"dialog"  , "💬",
"diaper"  , "🧷",
"dice"    , "🎲",
"die"     , "🎲",
"diesel"  , "⛽",
"dim"     , "🔅",
"dish"    , "📡",
"disk"    , "💽",
"divide"  , "➗",
"diving"  , "🦪",
"diya"    , "🪔",
"dizzy"   , "🥴",
"djinn"   , "🧞",
"dna"     , "🧬",
"doctor"  , "😷",
"dodo"    , "🦤",
"dog"     , "🐶",
"doll"    , "🪆",
"dollar"  , "💰",
"donut"   , "🍩",
"door"    , "🚪",
"double"  , "⏩",
"doubt"   , "🤷",
"dove"    , "🕊",
"down"    , "👇",
"dragon"  , "🐲",
"dress"   , "👗",
"drink"   , "🫖",
"drop"    , "☔",
"drum"    , "🪘",
"duck"    , "🦆",
"dung"    , "💩",
"dupe"    , "♟",
"dusk"    , "🌆",
"dvd"     , "📀",
"eagle"   , "🦅",
"ear"     , "👂",
"earbud"  , "🎧",
"earth"   , "🌍",
"east"    , "➡",
"egg"     , "🥚",
"eight"   , "🕗",
"eject"   , "⏏",
"eleven"  , "🕚",
"elf"     , "🧝",
"email"   , "✉",
"emblem"  , "🔱",
"end"     , "🔚",
"engine"  , "🚂",
"entry"   , "⛔",
"euro"    , "💶",
"evil"    , "🙈",
"ewe"     , "🐑",
"eye"     , "😄",
"eyes"    , "🤩",
"face"    , "🥸",
"fairy"   , "🧚",
"family"  , "👪",
"farmer"  , "🧑‍🌾",
"fast"    , "⏩",
"father"  , "🎅",
"favor"   , "🙇‍♂",
"fax"     , "📠",
"fear"    , "😨",
"feet"    , "🐾",
"female"  , "🐑",
"fencer"  , "🤺",
"ferris"  , "🎡",
"ferry"   , "⛴",
"fever"   , "🦟",
"field"   , "🏑",
"file"    , "📁",
"filing"  , "🗄",
"film"    , "🎞",
"finger"  , "🖐",
"fire"    , "🚒",
"first"   , "🥇",
"fish"    , "🐟",
"fist"    , "✊",
"five"    , "🕔",
"flag"    , "🏳‍⚧",
"flame"   , "🔥",
"flash"   , "📸",
"flex"    , "💪",
"flight"  , "🪶",
"floor"   , "🤣",
"floppy"  , "💾",
"flower"  , "💐",
"fly"     , "🪰",
"fog"     , "🌁",
"foggy"   , "🌁",
"folder"  , "📁",
"fondue"  , "🫕",
"food"    , "🫒",
"foot"    , "🦶",
"fork"    , "🍽",
"four"    , "🍀",
"fox"     , "🦊",
"frame"   , "🪟",
"frames"  , "🎞",
"free"    , "🆓",
"french"  , "🥐",
"fried"   , "🍤",
"fries"   , "🍟",
"frog"    , "🐸",
"frown"   , "🙁",
"fruit"   , "🍇",
"frying"  , "🍳",
"fuel"    , "⛽",
"fuji"    , "🗻",
"full"    , "💯",
"game"    , "🏐",
"garden"  , "🏡",
"garlic"  , "🧄",
"gas"     , "⛽",
"gear"    , "⚙",
"geek"    , "🤓",
"gem"     , "💎",
"gene"    , "🧬",
"genie"   , "🧞",
"ghost"   , "👻",
"gift"    , "🧧",
"ginger"  , "🦰",
"girl"    , "👧",
"glass"   , "🥛",
"globe"   , "🌍",
"glove"   , "🥎",
"gloves"  , "🧤",
"glow"    , "🌟",
"goal"    , "🥍",
"goat"    , "🐐",
"goblin"  , "👺",
"gold"    , "🪙",
"golf"    , "🏌",
"good"    , "🦸",
"goofy"   , "🤪",
"grain"   , "🌾",
"grape"   , "🍇",
"grapes"  , "🍇",
"graph"   , "💹",
"grave"   , "🪦",
"gray"    , "🦳",
"green"   , "💚",
"grin"    , "😀",
"groom"   , "🤵",
"grow"    , "🪴",
"growth"  , "💹",
"guard"   , "💂",
"guide"   , "🦮",
"guitar"  , "🎸",
"gun"     , "🔫",
"gyro"    , "🥙",
"hair"    , "👱",
"halo"    , "😇",
"hammer"  , "🔨",
"hand"    , "👋",
"happy"   , "🙋",
"hashi"   , "🥢",
"hat"     , "🤠",
"head"    , "🗣",
"hear"    , "🙉",
"heart"   , "🫀",
"hearts"  , "🥰",
"heavy"   , "🪨",
"heel"    , "👠",
"hello"   , "🫂",
"helmet"  , "🪖",
"help"    , "💁",
"herb"    , "🌿",
"herd"    , "🦬",
"hero"    , "🦸",
"hidden"  , "🥷",
"hijab"   , "🧕",
"hike"    , "🚶",
"hiking"  , "🥾",
"hindu"   , "🛕",
"hippo"   , "🦛",
"hit"     , "🎯",
"hocho"   , "🔪",
"hockey"  , "🏑",
"hoist"   , "🛗",
"hold"    , "🧑‍🤝‍🧑",
"hole"    , "🕳",
"home"    , "🏠",
"honey"   , "🍯",
"hook"    , "🪝",
"hoop"    , "🏀",
"hooray"  , "🙌",
"horn"    , "🥳",
"horns"   , "😈",
"horse"   , "🏇",
"hot"     , "🥵",
"hotdog"  , "🌭",
"hotel"   , "🛌",
"house"   , "🪴",
"houses"  , "🏘",
"hug"     , "🫂",
"hump"    , "🐪",
"hurt"    , "🤕",
"hushed"  , "😯",
"hut"     , "🛖",
"i"       , "ℹ",
"ice"     , "🍦",
"id"      , "🆔",
"idea"    , "💡",
"ill"     , "🤒",
"imp"     , "👿",
"inbox"   , "📥",
"index"   , "👈",
"injury"  , "🤕",
"ink"     , "🔏",
"input"   , "🔠",
"insect"  , "🪲",
"inside"  , "💠",
"iron"    , "🧇",
"ironic"  , "😼",
"islam"   , "🕌",
"island"  , "🏝",
"jack"    , "🎃",
"jacket"  , "🧥",
"jeans"   , "👖",
"jewel"   , "💎",
"jiaozi"  , "🥟",
"jigsaw"  , "🧩",
"jockey"  , "🏇",
"joey"    , "🦘",
"joke"    , "😜",
"joker"   , "🃏",
"joy"     , "😂",
"judge"   , "🧑‍⚖",
"judo"    , "🥋",
"jug"     , "🏺",
"juggle"  , "🤹",
"juice"   , "🥤",
"jump"    , "🦘",
"kaaba"   , "🕋",
"kale"    , "🥬",
"karate"  , "🥋",
"kebab"   , "🥙",
"key"     , "🔐",
"kick"    , "🦵",
"kimono"  , "👘",
"king"    , "👑",
"kiss"    , "😘",
"kite"    , "🪁",
"kiwi"    , "🥝",
"kneel"   , "🧎",
"knife"   , "🍽",
"knit"    , "🧶",
"knobs"   , "🎛",
"knot"    , "🪢",
"koala"   , "🐨",
"lab"     , "🧪",
"label"   , "🏷",
"ladder"  , "🪜",
"lamp"    , "🪔",
"laptop"  , "💻",
"large"   , "🦣",
"lather"  , "🧼",
"latin"   , "🔠",
"laugh"   , "😆",
"lavash"  , "🫓",
"lazy"    , "🦥",
"leaf"    , "🌿",
"ledger"  , "📒",
"left"    , "◀",
"leg"     , "🦵",
"lemon"   , "🍋",
"letter"  , "💌",
"level"   , "🎚",
"lie"     , "🤥",
"life"    , "🧬",
"lift"    , "🛗",
"lifter"  , "🏋",
"light"   , "🪶",
"limb"    , "🦵",
"link"    , "🖇",
"lion"    , "🦁",
"lips"    , "💋",
"liquor"  , "🥃",
"litter"  , "🚮",
"lizard"  , "🦎",
"llama"   , "🦙",
"loaf"    , "🍞",
"lock"    , "🔓",
"locked"  , "🔒",
"locker"  , "🛅",
"log"     , "🪵",
"loop"    , "➰",
"lorry"   , "🚛",
"lotion"  , "🧴",
"loud"    , "🔊",
"love"    , "😍",
"low"     , "🔅",
"luck"    , "🤞",
"lumber"  , "🪚",
"lungs"   , "🫁",
"m"       , "Ⓜ",
"mad"     , "😡",
"mage"    , "🧙",
"maggot"  , "🪰",
"magic"   , "🪄",
"magnet"  , "🧲",
"mail"    , "💌",
"maize"   , "🌽",
"makeup"  , "💄",
"male"    , "🐏",
"man"     , "👨",
"mango"   , "🥭",
"map"     , "🗺",
"maple"   , "🍁",
"mark"    , "❣",
"marker"  , "📑",
"mask"    , "😷",
"mate"    , "🧉",
"math"    , "➕",
"maze"    , "🌽",
"meat"    , "🍖",
"medal"   , "🎖",
"medium"  , "🔉",
"meh"     , "😐",
"melon"   , "🍈",
"melted"  , "🫕",
"memo"    , "📝",
"men"     , "👯‍♂",
"mercy"   , "🥺",
"merman"  , "🧜",
"metal"   , "🪙",
"metro"   , "🚇",
"mic"     , "🎙",
"milk"    , "🧋",
"mining"  , "⛏",
"minus"   , "➖",
"mirror"  , "🪞",
"moai"    , "🗿",
"mobile"  , "📱",
"mode"    , "📳",
"molusc"  , "🦑",
"money"   , "🪙",
"monkey"  , "🙈",
"moon"    , "🌑",
"mortar"  , "🧱",
"mosque"  , "🕌",
"mother"  , "🤶",
"motor"   , "🛵",
"mouse"   , "🐭",
"mouth"   , "😃",
"movie"   , "🎥",
"moyai"   , "🗿",
"mug"     , "🍺",
"munch"   , "😱",
"muscle"  , "💪",
"museum"  , "🖼",
"music"   , "🎼",
"mute"    , "🔇",
"naan"    , "🫓",
"nail"    , "💅",
"name"    , "📛",
"nazar"   , "🧿",
"neck"    , "🧣",
"needle"  , "🪡",
"nerd"    , "🤓",
"net"     , "🥅",
"new"     , "🆕",
"news"    , "📰",
"ng"      , "🆖",
"nib"     , "✒",
"night"   , "🌃",
"nine"    , "🕘",
"ninja"   , "🥷",
"no"      , "⛔",
"noodle"  , "🍜",
"north"   , "⬆",
"nose"    , "🥸",
"not"     , "⛔",
"note"    , "🎵",
"notes"   , "🎶",
"nurse"   , "🧑‍⚕",
"nut"     , "🥜",
"o"       , "⭕",
"ocean"   , "🌊",
"oden"    , "🍢",
"off"     , "📴",
"ogre"    , "👹",
"oh"      , "🙀",
"oil"     , "🛢",
"old"     , "🧓",
"olive"   , "🫒",
"om"      , "🕉",
"on"      , "🔛",
"once"    , "🔂",
"one"     , "🕐",
"onion"   , "🧅",
"open"    , "😃",
"orange"  , "🧡",
"organ"   , "🫀",
"otter"   , "🦦",
"outbox"  , "📤",
"owl"     , "🦉",
"ox"      , "🐂",
"oyster"  , "🦪",
"pad"     , "🗒",
"paddle"  , "🏓",
"paella"  , "🥘",
"page"    , "📃",
"pager"   , "📟",
"pail"    , "🪣",
"palm"    , "🤦",
"pan"     , "🍳",
"panda"   , "🐼",
"pants"   , "👖",
"paper"   , "📜",
"parcel"  , "📦",
"park"    , "🏞",
"parlor"  , "💇",
"parrot"  , "🦜",
"part"    , "〽",
"party"   , "🪅",
"pasta"   , "🍝",
"pastry"  , "🍥",
"patrol"  , "🚓",
"pause"   , "⏯",
"paw"     , "🐾",
"pc"      , "💻",
"peace"   , "🕊",
"peach"   , "🍑",
"peahen"  , "🦚",
"peanut"  , "🥜",
"pear"    , "🍐",
"pearl"   , "🧋",
"pen"     , "✒",
"pencil"  , "✏",
"pepper"  , "🫑",
"person"  , "🧑",
"pest"    , "🪰",
"pester"  , "🦡",
"pet"     , "🐶",
"phone"   , "🤳",
"piano"   , "🎹",
"pick"    , "⛏",
"picket"  , "🪧",
"pickle"  , "🥒",
"pickup"  , "🛻",
"picnic"  , "🧺",
"pie"     , "🥧",
"piece"   , "🧩",
"pig"     , "🐷",
"pill"    , "💊",
"pilot"   , "🧑‍✈",
"pin"     , "📌",
"pine"    , "🎍",
"pink"    , "🏳‍⚧",
"pirate"  , "🦜",
"pistol"  , "🔫",
"pita"    , "🫓",
"pizza"   , "🍕",
"plane"   , "🧑‍✈",
"plant"   , "🪴",
"plate"   , "🍽",
"play"    , "▶",
"please"  , "🙏",
"plug"    , "🔌",
"plus"    , "➕",
"plush"   , "🧸",
"point"   , "👈",
"pole"    , "💈",
"police"  , "👮",
"polish"  , "💅",
"polo"    , "🤽",
"poo"     , "💩",
"poodle"  , "🐩",
"poop"    , "💩",
"popper"  , "🎉",
"porous"  , "🧽",
"post"    , "🏣",
"postal"  , "📯",
"pot"     , "🫕",
"potato"  , "🥔",
"pouch"   , "👝",
"pound"   , "💷",
"prawn"   , "🍤",
"pray"    , "🙏",
"prayer"  , "🤲",
"pretty"  , "🦋",
"pride"   , "🏳‍🌈",
"prince"  , "🤴",
"print"   , "👣",
"prize"   , "🏆",
"proof"   , "🧾",
"proud"   , "🥲",
"puck"    , "🏒",
"pulse"   , "🫀",
"pump"    , "⛽",
"punch"   , "✊",
"purple"  , "💜",
"purse"   , "👛",
"puzzle"  , "🧩",
"queen"   , "👑",
"quench"  , "🧯",
"quiet"   , "🤫",
"r"       , "®",
"rabbit"  , "🐰",
"racing"  , "🏃‍♂",
"radio"   , "📻",
"rage"    , "😡",
"rain"    , "⛈",
"raised"  , "🤚",
"ram"     , "🐏",
"ramen"   , "🍜",
"rat"     , "🐀",
"rays"    , "☀",
"razor"   , "🪒",
"record"  , "⏺",
"red"     , "😡",
"reload"  , "🔃",
"repeat"  , "🔁",
"resort"  , "⛵",
"rewind"  , "⏪",
"rhythm"  , "🪘",
"ribbon"  , "💝",
"rice"    , "🌾",
"right"   , "▶",
"ring"    , "💍",
"roach"   , "🪳",
"road"    , "🛣",
"robot"   , "🤖",
"rock"    , "🪨",
"rocket"  , "🧑‍🚀",
"roll"    , "🥐",
"rolled"  , "🗞",
"roller"  , "🛼",
"rope"    , "🪢",
"rose"    , "🌹",
"rugby"   , "🏉",
"ruler"   , "📏",
"rung"    , "🪜",
"rushed"  , "😰",
"russia"  , "🪆",
"sad"     , "😢",
"safety"  , "🦺",
"sake"    , "🍶",
"salad"   , "🥗",
"salon"   , "💆",
"salt"    , "🧂",
"sand"    , "⌛",
"sandal"  , "👡",
"santa"   , "🎅",
"sari"    , "🥻",
"sash"    , "🎽",
"sassy"   , "💁",
"saturn"  , "🪐",
"sauna"   , "🧖",
"saw"     , "🪚",
"sax"     , "🎷",
"scale"   , "⚖",
"scales"  , "🧑‍⚖",
"scared"  , "😨",
"scarf"   , "🧣",
"school"  , "🏫",
"score"   , "💯",
"scream"  , "😱",
"screw"   , "🪛",
"scroll"  , "📜",
"scuba"   , "🤿",
"sea"     , "⛵",
"seal"    , "🦭",
"search"  , "🔍",
"seat"    , "💺",
"second"  , "🥈",
"secure"  , "🔐",
"see"     , "🙈",
"selfie"  , "🤳",
"semi"    , "🚛",
"sent"    , "📤",
"set"     , "📐",
"seven"   , "🕖",
"sewing"  , "🪡",
"shake"   , "🤝",
"shaker"  , "🧂",
"shark"   , "🦈",
"sharp"   , "🪒",
"shave"   , "🪒",
"shaved"  , "🍧",
"shaven"  , "🦲",
"sheep"   , "🐏",
"shell"   , "🐚",
"shield"  , "🛡",
"shinto"  , "⛩",
"ship"    , "⚓",
"shirt"   , "🎽",
"shoe"    , "👞",
"shorts"  , "🩳",
"shot"    , "🥃",
"shower"  , "🚿",
"shrimp"  , "🍤",
"shrine"  , "⛩",
"shrug"   , "🤷",
"shush"   , "🤫",
"sick"    , "😷",
"sign"    , "🪧",
"signal"  , "🚥",
"silent"  , "😶",
"silver"  , "🪙",
"singer"  , "🧑‍🎤",
"sit"     , "🪑",
"six"     , "🕕",
"skate"   , "🛼",
"skewer"  , "🍢",
"ski"     , "⛷",
"skier"   , "⛷",
"skill"   , "🤹",
"skis"    , "🎿",
"skull"   , "💀",
"skunk"   , "🦨",
"sled"    , "🛷",
"sledge"  , "🛷",
"sleep"   , "😪",
"sleigh"  , "🛷",
"sleuth"  , "🕵",
"slice"   , "🍕",
"slider"  , "🎚",
"slot"    , "🎰",
"sloth"   , "🦥",
"slow"    , "🦥",
"sly"     , "🦝",
"small"   , "🤪",
"smile"   , "😃",
"smirk"   , "😏",
"snail"   , "🐌",
"snake"   , "🐍",
"snare"   , "🪤",
"sneeze"  , "🤧",
"snow"    , "⛷",
"soap"    , "🧼",
"soar"    , "🪁",
"sob"     , "😭",
"soccer"  , "⚽",
"socks"   , "🧦",
"soda"    , "🥤",
"soft"    , "🍦",
"solid"   , "🪨",
"soon"    , "🔜",
"sorry"   , "🙇",
"sos"     , "🆘",
"south"   , "⬇",
"sow"     , "🐖",
"space"   , "🛰",
"speak"   , "🙊",
"speech"  , "💬",
"speed"   , "🚄",
"spider"  , "🕷",
"spiny"   , "🦔",
"spiral"  , "🐚",
"split"   , "🪓",
"spock"   , "🖖",
"sponge"  , "🧽",
"spool"   , "🧵",
"spoon"   , "🥄",
"spots"   , "🦒",
"spy"     , "🕵",
"square"  , "⏹",
"squid"   , "🦑",
"staff"   , "⚕",
"stand"   , "🧍",
"star"    , "🤩",
"statue"  , "🗽",
"steak"   , "🥩",
"steam"   , "🚂",
"step"    , "🪜",
"stew"    , "🍲",
"stick"   , "🍢",
"stink"   , "🦨",
"stomp"   , "🦶",
"stone"   , "🪨",
"stop"    , "🚏",
"store"   , "🏪",
"straw"   , "🧃",
"string"  , "🧵",
"stripe"  , "🦓",
"studio"  , "🎙",
"stuffy"  , "🧐",
"subway"  , "🚇",
"suit"    , "🕴",
"sun"     , "😎",
"sunny"   , "☀",
"sunset"  , "🌆",
"sushi"   , "🍣",
"swan"    , "🦢",
"sweat"   , "😅",
"sweet"   , "🍠",
"swim"    , "🏊",
"swirl"   , "🍥",
"sword"   , "🤺",
"swords"  , "⚔",
"tabs"    , "📑",
"taco"    , "🌮",
"tada"    , "🎉",
"talk"    , "🦜",
"tamale"  , "🫔",
"tao"     , "☯",
"taoist"  , "☯",
"tape"    , "📼",
"target"  , "🎯",
"taste"   , "😝",
"taxi"    , "🚕",
"tea"     , "🧋",
"teacup"  , "🍵",
"teapot"  , "🫖",
"tear"    , "🥲",
"teeth"   , "🪥",
"teller"  , "🏧",
"temple"  , "🛕",
"ten"     , "🕙",
"tennis"  , "🎾",
"tent"    , "⛺",
"thanks"  , "🫂",
"third"   , "🥉",
"thirty"  , "🕧",
"thongs"  , "🩴",
"thread"  , "🧵",
"three"   , "🕒",
"thumb"   , "👍",
"tichel"  , "🧕",
"ticket"  , "🎟",
"tie"     , "🪢",
"tiger"   , "🐯",
"timber"  , "🪵",
"timer"   , "⌛",
"tipsy"   , "🥴",
"tired"   , "😩",
"tm"      , "™",
"toilet"  , "🪠",
"tomato"  , "🍅",
"tongue"  , "😛",
"tool"    , "🪚",
"tooth"   , "🦷",
"top"     , "🎩",
"tophat"  , "🎩",
"torch"   , "🔦",
"tower"   , "🗼",
"toy"     , "🪀",
"train"   , "🚂",
"tram"    , "🚃",
"trap"    , "🪤",
"travel"  , "🧳",
"tray"    , "📤",
"tree"    , "🌲",
"trend"   , "📈",
"trophy"  , "🏆",
"truck"   , "🛻",
"tshirt"  , "👕",
"tulip"   , "🌷",
"turban"  , "👳",
"turkey"  , "🦃",
"turtle"  , "🐢",
"tusk"    , "🦣",
"tuxedo"  , "🤵",
"tv"      , "📺",
"twelve"  , "🕛",
"twine"   , "🪢",
"twins"   , "👬",
"twist"   , "🪢",
"two"     , "🕑",
"ufo"     , "👽",
"undead"  , "🧛",
"unlock"  , "🔓",
"up"      , "👆",
"upward"  , "📈",
"urn"     , "⚱",
"v"       , "✌",
"vat"     , "🪣",
"veil"    , "👰",
"versus"  , "🆚",
"vest"    , "🦺",
"vhs"     , "📼",
"vice"    , "🗜",
"video"   , "📻",
"view"    , "🪟",
"violin"  , "🎻",
"virus"   , "🦟",
"vomit"   , "🤢",
"vs"      , "🆚",
"vulcan"  , "🖖",
"waffle"  , "🧇",
"walk"    , "🚶",
"wall"    , "🧱",
"waning"  , "🌖",
"watch"   , "⌚",
"water"   , "🤽",
"wave"    , "👋",
"waving"  , "👋",
"wavy"    , "〰",
"waxing"  , "🌒",
"wc"      , "🚹",
"weapon"  , "🔪",
"weary"   , "😩",
"web"     , "🕸",
"weight"  , "🏋",
"west"    , "⬅",
"whale"   , "🐳",
"wheel"   , "🎡",
"whew"    , "😥",
"whisky"  , "🥃",
"white"   , "🤍",
"whoops"  , "🤭",
"wicked"  , "🖤",
"wilted"  , "🥀",
"wind"    , "🍃",
"window"  , "🪟",
"wine"    , "🍷",
"wings"   , "💸",
"wink"    , "😉",
"wise"    , "🦉",
"wisent"  , "🦬",
"witch"   , "🪄",
"wizard"  , "🪄",
"wolf"    , "🐺",
"woman"   , "👩",
"women"   , "👯‍♀",
"won"     , "😤",
"wood"    , "🪵",
"wool"    , "🦙",
"woolly"  , "🦣",
"worker"  , "🧑‍🏭",
"world"   , "🌍",
"worm"    , "🪱",
"wrap"    , "🌯",
"wrench"  , "🛠",
"write"   , "✍",
"wry"     , "😼",
"x"       , "✖",
"yacht"   , "⛵",
"yang"    , "☯",
"yarn"    , "🧶",
"yawn"    , "🥱",
"yellow"  , "💛",
"yen"     , "💴",
"yin"     , "☯",
"yoga"    , "🧘",
"young"   , "👶",
"yum"     , "😋",
"yurt"    , "🛖",
"zap"     , "⚡",
"zebra"   , "🦓",
"zipper"  , "🤐",
"zodiac"  , "👧",
"zombie"  , "🧟",
"zzz"     , "😴"
};

const EmojiItem chinese_emoji_table[] = {
"㵴火"      , "🧯",
"㵴火筒"     , "🧯",
"一"       , "🕐",
"一件头"     , "🩲",
"一堆屎"     , "💩",
"一杯奶"     , "🥛",
"一次"      , "🔂",
"一点"      , "🕐",
"一点半"     , "🕜",
"一百分"     , "💯",
"一群"      , "🦬",
"七"       , "🕖",
"七点"      , "🕖",
"七点半"     , "🕢",
"万圣节"     , "🎃",
"万字夹"     , "📎",
"万岁"      , "🙌",
"三"       , "🕒",
"三十"      , "🕧",
"三叉戟"     , "🔱",
"三叶草"     , "☘",
"三文治"     , "🥪",
"三点"      , "🕒",
"三点半"     , "🕞",
"三角尺"     , "📐",
"三角形"     , "📐",
"三角旗"     , "🚩",
"上"       , "👆",
"上升"      , "💹",
"上弦月"     , "🌓",
"上锁"      , "🔒",
"下"       , "👇",
"下弦月"     , "🌗",
"下跌"      , "📉",
"不"       , "🙈",
"不久"      , "🔜",
"不关心"     , "🤷",
"不准"      , "⛔",
"不可"      , "⛔",
"丑小鸭"     , "🦢",
"世界"      , "🌍",
"丘比特"     , "💘",
"业务"      , "👨‍💼",
"东"       , "➡",
"东京"      , "🗼",
"东北"      , "↗",
"东南"      , "↘",
"丝带"      , "🎗",
"两个心"     , "💕",
"两点"      , "🕑",
"两点半"     , "🕝",
"个人"      , "💻",
"中国帽"     , "👲",
"中心"      , "🫀",
"中性"      , "🧒",
"中指"      , "🖕",
"中暑"      , "🥵",
"中等"      , "🔉",
"中肤色"     , "🏽",
"串"       , "🍡",
"串烧"      , "🍢",
"丸子"      , "🍡",
"丹参树"     , "🎋",
"举手"      , "✋",
"举起"      , "🤚",
"举重"      , "🏋",
"举重者"     , "🏋",
"义肢"      , "🦾",
"乌蝇"      , "🪰",
"乐谱"      , "🎼",
"乒乓"      , "🏓",
"乒乓球"     , "🏓",
"乘"       , "✖",
"乘客"      , "🛳",
"乘法"      , "✖",
"九"       , "🕘",
"九点"      , "🕘",
"九点半"     , "🕤",
"乞嚏"      , "🤧",
"乞讨"      , "🥺",
"书"       , "📔",
"书包"      , "🎒",
"书呆子"     , "🤓",
"书签"      , "📑",
"乳制品"     , "🧈",
"乳房"      , "🤱",
"乳液"      , "🧴",
"乳液樽"     , "🧴",
"二"       , "🕑",
"二头肌"     , "💪",
"亏"       , "🌖",
"亏凸月"     , "🌖",
"云"       , "☁",
"五"       , "🕔",
"五点"      , "🕔",
"五点半"     , "🕠",
"亚洲"      , "🌏",
"亡灵"      , "🧛",
"交叉"      , "🤞",
"交叉旗"     , "🎌",
"交叉骨"     , "☠",
"交通"      , "🚥",
"亮度"      , "🔅",
"人"       , "🧑‍🍼",
"人马座"     , "♐",
"人鱼"      , "🧜",
"仓鼠"      , "🐹",
"仓鼠脸"     , "🐹",
"仙人掌"     , "🌵",
"仙子"      , "🧚",
"仪器"      , "🎷",
"仪式"      , "🎑",
"企"       , "🧍",
"企鹅"      , "🐧",
"会计"      , "🧾",
"传呼机"     , "📟",
"传真"      , "📠",
"传真机"     , "📠",
"伤心"      , "😢",
"低"       , "🔅",
"低手"      , "🥎",
"体操"      , "🤸",
"体育场"     , "🏟",
"佛教"      , "☸",
"佛法"      , "☸",
"佛法轮"     , "☸",
"侦探"      , "🕵",
"侧手翻"     , "🤸",
"便利店"     , "🏪",
"便当"      , "🍱",
"便条"      , "📝",
"俄罗斯"     , "🪆",
"保健员"     , "🧑‍⚕",
"保龄球"     , "🎳",
"信"       , "💌",
"信号"      , "🚥",
"信封"      , "✉",
"信用"      , "💳",
"信用卡"     , "💳",
"信箱"      , "📫",
"修甲"      , "💅",
"假扮"      , "🥸",
"停"       , "🚏",
"停止"      , "🛑",
"健康"      , "🤧",
"傍晚"      , "🌆",
"傻笑"      , "😏",
"傻笑脸"     , "😏",
"光"       , "🪶",
"光亮"      , "☀",
"光头"      , "🦲",
"光学"      , "💽",
"光环"      , "😇",
"光碟"      , "💽",
"免费"      , "🈚",
"兑换"      , "💱",
"兔"       , "🐰",
"兔耳"      , "👯",
"兔脸"      , "🐰",
"入场"      , "🎟",
"入场券"     , "🎟",
"八"       , "🕗",
"八点"      , "🕗",
"八点半"     , "🕣",
"八角形"     , "🛑",
"八角星"     , "✳",
"公"       , "🐏",
"公主"      , "👸",
"公事包"     , "💼",
"公仔"      , "🪆",
"公园"      , "🏞",
"公牛"      , "🐂",
"公羊"      , "🐏",
"公路"      , "🛣",
"公鸡"      , "🐓",
"六"       , "🕕",
"六点"      , "🕕",
"六点半"     , "🕡",
"关闭"      , "📫",
"兴奋"      , "💖",
"内"       , "💠",
"内衣"      , "🩲",
"冇位"      , "🈵",
"写字"      , "✍",
"军事"      , "🪖",
"军队"      , "🪖",
"农夫"      , "🧑‍🌾",
"农夫车"     , "🛻",
"冥想"      , "🧘",
"冬甩"      , "🍩",
"冰"       , "🥶",
"冰冷"      , "😓",
"冰块"      , "🧊",
"冰川"      , "🐻‍❄",
"冰球"      , "🏒",
"冲凉"      , "🛀",
"冷球"      , "🧶",
"冻"       , "😅",
"冻伤"      , "🥶",
"冻结"      , "🥶",
"凉鞋"      , "🩴",
"凋谢"      , "🥀",
"减"       , "➖",
"几何"      , "🔴",
"出发"      , "🛫",
"出汗"      , "🥵",
"击中"      , "🎯",
"刀"       , "🍽",
"分开"      , "🪓",
"分数"      , "💯",
"分类"      , "🗂",
"分量"      , "🥃",
"划艇"      , "🚣",
"初学者"     , "🔰",
"刨"       , "🍧",
"刨冰"      , "🍧",
"利"       , "🪒",
"利是"      , "🧧",
"利是封"     , "🧧",
"到达"      , "🛬",
"制服"      , "🥋",
"刷"       , "🪥",
"券"       , "🎟",
"刺"       , "🦔",
"刺猬"      , "🦔",
"刺绣"      , "🪡",
"剃刀"      , "🪒",
"剃头"      , "🦲",
"剃须"      , "🪒",
"剑"       , "🤺",
"剑击"      , "🤺",
"剔号"      , "✅",
"剧场"      , "🎭",
"剪"       , "✂",
"剪头发"     , "💇‍♂",
"剪影"      , "🗣",
"割"       , "🈹",
"办公室"     , "👨‍💼",
"加"       , "➕",
"勾"       , "🪝",
"包头"      , "🧕",
"包装"      , "🎁",
"包裹"      , "📦",
"匆忙"      , "😰",
"匕首"      , "🗡",
"化妆"      , "💄",
"化妆品"     , "💅",
"化学"      , "⚗",
"化学家"     , "🧑‍🔬",
"化疗"      , "🦲",
"北"       , "⬆",
"北极熊"     , "🐻‍❄",
"匙羮"      , "🥄",
"医生"      , "😷",
"医疗"      , "🩸",
"医药"      , "💉",
"医院"      , "🏥",
"匿名"      , "🥸",
"十"       , "🕙",
"十一"      , "🕦",
"十一点"     , "🕚",
"十二"      , "🕛",
"十二点"     , "🕛",
"十八岁"     , "🔞",
"十字架"     , "⛪",
"十点"      , "🕙",
"十点半"     , "🕥",
"升降机"     , "🛗",
"半"       , "🚛",
"协助"      , "🐕‍🦺",
"卒"       , "🤌",
"卒手指"     , "🤌",
"单车"      , "🚴",
"单轨"      , "🚝",
"卖点"      , "🪝",
"南"       , "⬇",
"南瓜"      , "🎃",
"博物馆"     , "🖼",
"卡"       , "💳",
"卡片"      , "🗂",
"卡片盒"     , "📇",
"卡车"      , "🚒",
"卫星"      , "🛰",
"卫生"      , "🪥",
"卫生间"     , "🚹",
"印"       , "👣",
"印度寺"     , "🛕",
"印度教"     , "🕉",
"危险"      , "⚡",
"卷"       , "🧵",
"卷发"      , "🦱",
"卷心菜"     , "🥬",
"卷曲"      , "🦱",
"卷曲圈"     , "➰",
"卷纸"      , "🧻",
"卷起"      , "🗞",
"卷页"      , "📃",
"卷饼"      , "🌯",
"压"       , "🗜",
"厌倦"      , "🙀",
"厕所"      , "🚽",
"厕所泵"     , "🪠",
"厕纸"      , "🧻",
"原子"      , "⚛",
"原子笔"     , "🖊",
"原驼"      , "🦙",
"厨师"      , "🧑‍🍳",
"厨房刀"     , "🔪",
"叉"       , "🍽",
"叉同刀"     , "🍴",
"双"       , "⏸",
"双子"      , "♊",
"双子座"     , "👬",
"双眼"      , "👀",
"双耳瓶"     , "🏺",
"双胞胎"     , "👬",
"双重"      , "⏩",
"双鱼座"     , "🐟",
"反射"      , "🪃",
"反射器"     , "🪞",
"反射镜"     , "🪞",
"反弹"      , "🪃",
"反手"      , "🤚",
"发件箱"     , "📤",
"发光"      , "🌟",
"发出"      , "📩",
"发动机"     , "🚂",
"发型师"     , "💇",
"发明家"     , "🧑‍💻",
"发烧"      , "🦟",
"发疯"      , "😡",
"发癫"      , "😠",
"发誓"      , "🤬",
"发送"      , "📩",
"取消"      , "✖",
"受伤"      , "🤕",
"口罩"      , "😷",
"口震"      , "😱",
"古典"      , "🏛",
"可"       , "🉑",
"台风"      , "🌀",
"叶"       , "🌿",
"号角"      , "🥳",
"合"       , "🈴",
"合埋"      , "😚",
"合手"      , "🙏",
"合格"      , "🈴",
"吊钟"      , "🔔",
"同情"      , "😮",
"同意"      , "🤝",
"名牌"      , "📛",
"向上"      , "💹",
"向下"      , "⬇",
"向右"      , "🤜",
"向左"      , "🤛",
"吓亲"      , "😲",
"吓惊"      , "😯",
"听"       , "🙉",
"听筒"      , "🩺",
"听障"      , "🦻",
"吸力"      , "🧲",
"吸气"      , "🫁",
"吸水"      , "🧽",
"吸烟"      , "🚬",
"吸血鬼"     , "🧛",
"吹"       , "🍃",
"吻"       , "😘",
"呕吐"      , "🤢",
"呕心"      , "🤢",
"员工"      , "⚕",
"呜咽"      , "😭",
"呢度"      , "🈁",
"呼"       , "😥",
"呼叫"      , "🤭",
"呼吸"      , "🫁",
"呼气"      , "🫁",
"咀唇"      , "💋",
"和平"      , "🕊",
"和服"      , "👘",
"咖哩"      , "🍛",
"咖哩饭"     , "🍛",
"咖啡"      , "☕",
"咧嘴笑"     , "😁",
"咪"       , "🎙",
"咪高峰"     , "🎙",
"哺乳"      , "👨‍🍼",
"哺育"      , "🧑‍🍼",
"唇印"      , "💋",
"唇膏"      , "💄",
"唔准"      , "🙈",
"唔吉利"     , "🐈‍⬛",
"唔好"      , "🙈",
"唔客气"     , "😑",
"唔开心"     , "😒",
"唔相信"     , "🤦",
"唵"       , "🕉",
"啄木鸟"     , "🦜",
"商业"      , "🧑‍💼",
"商人"      , "👨‍🔧",
"商店"      , "🏪",
"商标"      , "™",
"啡色"      , "🤎",
"啡色心"     , "🤎",
"啤酒"      , "🍺",
"啤酒杯"     , "🍺",
"啧水"      , "🐳",
"喂哺"      , "🧑‍🍼",
"喇叭"      , "🔇",
"喊"       , "😢",
"喊嘅脸"     , "😢",
"喷水池"     , "⛲",
"嗯"       , "😋",
"嘘"       , "🤫",
"嘘嘅脸"     , "🤫",
"嘟嘟鸟"     , "🦤",
"嘭嘭"      , "‼",
"嘲笑"      , "🤌",
"嘴"       , "😃",
"噢"       , "🙀",
"器官"      , "🫀",
"四"       , "🍀",
"四叶草"     , "🍀",
"四点"      , "🕓",
"四点半"     , "🕟",
"回力镖"     , "🪃",
"回带"      , "◀",
"团"       , "🍙",
"园丁"      , "🧑‍🌾",
"困惑"      , "😖",
"国王"      , "👑",
"图"       , "💹",
"图片"      , "🖼",
"图表"      , "💹",
"圆屋"      , "🛖",
"圆形"      , "⏺",
"圆碌碌"     , "🙄",
"圆禁钉"     , "📍",
"圈"       , "➰",
"圈套"      , "🪝",
"土星"      , "🪐",
"圣诞树"     , "🎄",
"圣诞节"     , "🎅",
"在"       , "🔛",
"地下"      , "🤣",
"地图"      , "🗺",
"地球"      , "🌍",
"地球仪"     , "🌍",
"地铁"      , "🚇",
"场所"      , "🛐",
"坏人"      , "🦹",
"坐"       , "🪑",
"块"       , "🧩",
"坚硬"      , "🪨",
"坟墓"      , "🪦",
"坠落"      , "🌠",
"垂直"      , "⏸",
"垃圾"      , "🚮",
"垃圾桶"     , "🚮",
"垒球"      , "🥎",
"垫"       , "🗒",
"城堡"      , "🏯",
"城市"      , "🏙",
"培养皿"     , "🧫",
"培育"      , "🪴",
"基因"      , "🧬",
"基点"      , "⬆",
"基点间"     , "↗",
"基督徒"     , "⛪",
"基督教"     , "✝",
"塔"       , "🗼",
"墓地"      , "🪦",
"墓碑"      , "🪦",
"墙"       , "🧱",
"增长"      , "💹",
"墨水"      , "🔏",
"墨西哥"     , "🫔",
"士兵"      , "🪖",
"士巴拿"     , "🛠",
"壳"       , "🐚",
"壶"       , "🫖",
"处女"      , "👧",
"处女座"     , "♍",
"夏日"      , "🍹",
"外卖盒"     , "🥡",
"外套"      , "🧥",
"外星"      , "👽",
"外星人"     , "👽",
"外框"      , "❔",
"外送盘"     , "📤",
"多动作"     , "🤹",
"多窿"      , "🧽",
"多谢"      , "🫂",
"夜晚"      , "🌃",
"大"       , "🦣",
"大卫"      , "✡",
"大厦"      , "🏢",
"大厨"      , "👨‍🍳",
"大声"      , "🔊",
"大声公"     , "📢",
"大头针"     , "📌",
"大桥"      , "🌉",
"大烛台"     , "🕎",
"大猩猩"     , "🦍",
"大羊驼"     , "🦙",
"大虾"      , "🍤",
"大象"      , "🐘",
"大阶"      , "🔠",
"大雾"      , "🌁",
"天使"      , "😇",
"天妇罗"     , "🍤",
"天房"      , "🕋",
"天气"      , "🌡",
"天父"      , "🎅",
"天真"      , "😇",
"天秤"      , "⚖",
"天秤座"     , "⚖",
"天线"      , "📡",
"天线棒"     , "📶",
"天蝎座"     , "🦂",
"天鹅"      , "🦢",
"太空"      , "🛰",
"太空人"     , "🧑‍🚀",
"太阳"      , "😎",
"太阳花"     , "🌻",
"夫妇"      , "👭",
"失望"      , "😥",
"头"       , "🗣",
"头发"      , "🦳",
"头巾"      , "👳",
"头晕"      , "😵",
"头盔"      , "🪖",
"奇异果"     , "🥝",
"奇怪"      , "🤓",
"奖"       , "🏆",
"奖杯"      , "🏆",
"奖牌"      , "🎖",
"奥布朗"     , "🧚",
"女"       , "👱‍♀",
"女人"      , "👩",
"女仔"      , "👧",
"女仙子"     , "🧚‍♀",
"女侦探"     , "🕵‍♀",
"女农夫"     , "👩‍🌾",
"女厕"      , "🚺",
"女厨师"     , "👩‍🍳",
"女士"      , "👠",
"女学生"     , "👩‍🎓",
"女巫"      , "🪄",
"女巫师"     , "🧙‍♀",
"女技工"     , "👩‍🔧",
"女教师"     , "👩‍🏫",
"女歌手"     , "👩‍🎤",
"女殭尸"     , "🧟‍♀",
"女法官"     , "👩‍⚖",
"女王"      , "👑",
"女精灵"     , "🧝‍♀",
"女装"      , "👚",
"女装帽"     , "👒",
"女装靴"     , "👢",
"女警察"     , "👮‍♀",
"女超人"     , "🦸‍♀",
"奶"       , "🍼",
"好"       , "🦸",
"好奇"      , "🦝",
"好累"      , "😩",
"好运"      , "🧧",
"好食"      , "😋",
"妈妈"      , "🤶",
"妖"       , "👿",
"姓名"      , "📛",
"姿势"      , "🙇",
"威士忌"     , "🥃",
"娃娃"      , "🎎",
"娥眉月"     , "🌒",
"娱乐"      , "🚙",
"娱乐家"     , "🧑‍🎤",
"婚礼"      , "👰",
"婴儿"      , "👶",
"嬲"       , "😡",
"嬲嘅脸"     , "😠",
"子午线"     , "🌐",
"子弹"      , "🚅",
"孔雀"      , "🦚",
"孕妇"      , "🤰",
"字母"      , "🔠",
"学校"      , "🏫",
"学生"      , "🧑‍🎓",
"孵化"      , "🐣",
"守卫员"     , "💂",
"安全"      , "🦺",
"安息"      , "🪦",
"安静"      , "🔇",
"完全"      , "😲",
"宗教"      , "⛪",
"宝石"      , "💎",
"宝藏"      , "🪙",
"实验"      , "🥼",
"实验室"     , "🧪",
"实验袍"     , "🥼",
"宠物"      , "🐶",
"客厅"      , "💇",
"客船"      , "🛳",
"害怕"      , "😨",
"家"       , "🏠",
"家庭"      , "👪",
"家禽"      , "🍗",
"寄信"      , "💌",
"寄存"      , "🛅",
"寄生虫"     , "🪱",
"密码"      , "🔑",
"富士"      , "🗻",
"富士山"     , "🗻",
"寒冷"      , "🌨",
"寒冷的"     , "🏔",
"对"       , "🆚",
"对唔住"     , "🙇",
"对话"      , "💬",
"寺庙"      , "🛕",
"导师"      , "🧑‍🏫",
"导盲"      , "🦮",
"导盲犬"     , "🦮",
"导航"      , "🧭",
"寿司"      , "🍣",
"封面"      , "📔",
"射击"      , "🌠",
"射手"      , "🏹",
"射手座"     , "🏹",
"射箭"      , "🏹",
"射线"      , "☀",
"小"       , "🦐",
"小丑"      , "🤡",
"小丑脸"     , "🤡",
"小天鹅"     , "🦢",
"小妖精"     , "👺",
"小屋"      , "🛖",
"小巴"      , "🚐",
"小提琴"     , "🎻",
"小教堂"     , "💒",
"小水滴"     , "💧",
"小童"      , "🧒",
"小精灵"     , "🧝",
"小量"      , "🤏",
"小阶"      , "🔡",
"小鸡"      , "🐣",
"尺度"      , "🧑‍⚖",
"尿片"      , "🧷",
"屋"       , "🪴",
"屎"       , "💩",
"山"       , "🏔",
"山地"      , "🚵",
"山羊"      , "🐐",
"山羊座"     , "🐐",
"岗位"      , "🚩",
"岛"       , "🏝",
"崇拜"      , "🥰",
"巡逻"      , "🚓",
"工业"      , "🧑‍🏭",
"工人"      , "🧑‍🏭",
"工具"      , "🪚",
"工具箱"     , "🧰",
"工厂"      , "🧑‍🏭",
"工程师"     , "🧑‍🔬",
"巨灵"      , "🧞",
"巨石"      , "🪨",
"巨蛇"      , "🐍",
"巨蟹座"     , "🦀",
"巫婆"      , "🧙",
"巫师"      , "🪄",
"巴士"      , "🚌",
"巴士站"     , "🚏",
"市场"      , "💹",
"布甸"      , "🍮",
"帆船"      , "⛵",
"帐单"      , "💴",
"帐篷"      , "⛺",
"帕克"      , "🧚",
"带"       , "📼",
"帮助"      , "💁",
"常青树"     , "🌲",
"帽"       , "🤠",
"干净"      , "🪥",
"平底镬"     , "🍳",
"平底鞋"     , "🥿",
"平行"      , "🤹",
"年青"      , "👶",
"幸运"      , "🤞",
"幻想"      , "😇",
"幼小"      , "🌱",
"幼苗"      , "🌱",
"庆祝"      , "🪅",
"床"       , "🛏",
"废纸篓"     , "🗑",
"度假村"     , "⛵",
"座位"      , "💺",
"座灯"      , "🛋",
"康加鼓"     , "🪘",
"建筑"      , "👷",
"建筑师"     , "🧑‍💼",
"建造"      , "🏗",
"开"       , "🔓",
"开会"      , "🤝",
"开发者"     , "🧑‍💻",
"开屏"      , "🦚",
"开玩笑"     , "😜",
"开花"      , "🌸",
"开酒塞"     , "🍾",
"弓"       , "🏹",
"弓箭"      , "🏹",
"张开"      , "🖐",
"弦月"      , "🌒",
"弦线"      , "🪕",
"弯"       , "🪝",
"弯曲"      , "🪝",
"录像机"     , "📹",
"录制"      , "⏺",
"录影带"     , "📼",
"录影机"     , "📼",
"录音室"     , "🎙",
"彗星"      , "☄",
"彩虹"      , "🌈",
"彩虹旗"     , "🏳‍🌈",
"影片"      , "📻",
"得"       , "🉐",
"微生物"     , "🦠",
"微笑"      , "🥲",
"德古拉"     , "🧛",
"徽章"      , "🔱",
"心"       , "💌",
"心脏"      , "🫀",
"心跳"      , "🫀",
"忌廉"      , "🍦",
"忍者"      , "🥷",
"忧心"      , "😔",
"快"       , "⏩",
"快乐"      , "😂",
"快到"      , "🚔",
"快艇"      , "🚤",
"快走"      , "💨",
"快进"      , "⏩",
"快速"      , "💨",
"念珠"      , "📿",
"怀孕"      , "🤰",
"怀疑"      , "🤨",
"怜悯"      , "🥺",
"怪物"      , "💀",
"恋爱"      , "🥰",
"恐布"      , "😝",
"恭喜"      , "㊗",
"恶魔"      , "👿",
"您好"      , "🫂",
"悬架"      , "🚟",
"情人"      , "💝",
"情侣"      , "🧑‍🤝‍🧑",
"情信"      , "💌",
"惊叫"      , "😱",
"惊恐"      , "😨",
"惊慌"      , "😨",
"惊讶"      , "😯",
"惧怕"      , "😱",
"想法"      , "💡",
"感动"      , "🥲",
"感叹号"     , "‼",
"感叹嘅"     , "❣",
"感激"      , "🥲",
"感谢"      , "🙇‍♂",
"愤怒"      , "😡",
"慢"       , "🦥",
"懒"       , "🦥",
"戏"       , "🎞",
"戏院"      , "🎥",
"成人"      , "🧑",
"成长"      , "🪴",
"我爱您"     , "🤟",
"戒指"      , "💍",
"战士"      , "🪖",
"战斗机"     , "🥷",
"房屋"      , "🏚",
"手"       , "👋",
"手势"      , "🤌",
"手卷"      , "🫔",
"手套"      , "🥎",
"手指"      , "🤌",
"手指公"     , "👍",
"手掌"      , "🤦",
"手提袋"     , "👝",
"手机"      , "🤳",
"手枪"      , "🔫",
"手球"      , "🤾",
"手瓜"      , "💪",
"手表"      , "⌚",
"手袋"      , "👜",
"手风琴"     , "🪗",
"手鼓"      , "🪘",
"扒"       , "🥩",
"打"       , "✊",
"打印机"     , "🖨",
"打喊露"     , "🥱",
"打开"      , "🪟",
"打开手"     , "👐",
"打扮"      , "🧑‍🎄",
"打气"      , "📣",
"打电话"     , "🤙",
"托盘"      , "📤",
"扣针"      , "🧷",
"扩音器"     , "📣",
"扫"       , "🧹",
"扫把"      , "🧹",
"扭"       , "🪢",
"扭歪"      , "😼",
"扭纹"      , "🥨",
"扳手"      , "🛠",
"批"       , "🥧",
"技工"      , "🧑‍🔧",
"技术"      , "🤹",
"投币口"     , "🎰",
"投票"      , "🗳",
"抗议"      , "🪧",
"折扣"      , "🈹",
"抢"       , "🏴‍☠",
"护士"      , "🧑‍⚕",
"护照"      , "🛂",
"护理"      , "💅",
"护符"      , "🧿",
"护镜"      , "🥽",
"报纸"      , "📰",
"抱抱"      , "🫂",
"抵达"      , "🛬",
"担心"      , "😟",
"拉丁"      , "🔠",
"拉链"      , "🤐",
"拉面"      , "🍜",
"拍子"      , "🪘",
"拍手"      , "👏",
"拍板"      , "🎬",
"拖"       , "👭",
"拖住"      , "🧑‍🤝‍🧑",
"拖头车"     , "🚛",
"拖拉机"     , "🚜",
"拖鞋"      , "🥿",
"招牌"      , "💈",
"拜拜"      , "🫂",
"拥抱"      , "🫂",
"拳击"      , "🥊",
"拳头"      , "✊",
"拳套"      , "🥊",
"持有人"     , "🐍",
"指"       , "👈",
"指南针"     , "🧭",
"指向"      , "👈",
"指甲"      , "💅",
"指甲油"     , "💅",
"按摩"      , "💆",
"按钮"      , "🔼",
"挑"       , "⛏",
"挥手"      , "👋",
"挥紧手"     , "👋",
"捏手"      , "🤏",
"捐血"      , "🩸",
"损伤"      , "🤕",
"换片"      , "🚼",
"掌"       , "🐾",
"掌印"      , "🐾",
"排球"      , "🏐",
"探热针"     , "🤒",
"接受"      , "🉑",
"接收"      , "📨",
"控制"      , "🎛",
"控制器"     , "🎮",
"提子"      , "🍇",
"提示"      , "💁",
"插头"      , "🔌",
"握"       , "🤝",
"握手"      , "🤝",
"握紧"      , "✊",
"揽"       , "🤗",
"搜寻"      , "🔍",
"搞笑"      , "💢",
"摇"       , "🪀",
"摇摇"      , "🪀",
"摇滚"      , "🤘",
"摔交"      , "🤼",
"摔交手"     , "🤼",
"摧毁"      , "⚡",
"摩天轮"     , "🎡",
"摩艾"      , "🗿",
"撅嘴"      , "😡",
"播放"      , "▶",
"收件盘"     , "📥",
"收件箱"     , "📥",
"收到"      , "📲",
"收据"      , "🧾",
"收费"      , "🈶",
"收集"      , "🛻",
"收音机"     , "📻",
"放低"      , "📪",
"放大"      , "🔍",
"放射性"     , "☢",
"放映机"     , "📽",
"放松"      , "☺",
"救护车"     , "🚑",
"救生衣"     , "🦺",
"教堂"      , "⛪",
"教师"      , "👨‍🏫",
"教授"      , "🧑‍🏫",
"散子"      , "👛",
"散子包"     , "👛",
"敬礼"      , "🖖",
"数字"      , "🔢",
"数学"      , "➕",
"数学家"     , "👨‍🔬",
"文件"      , "📃",
"文件夹"     , "📁",
"文化"      , "🧫",
"斑点"      , "🦒",
"斑马"      , "🦓",
"斧头"      , "🪓",
"斩"       , "🪓",
"新娘"      , "👰",
"新干线"     , "🚄",
"新月"      , "🌑",
"新月面"     , "🌚",
"新郎"      , "🤵",
"新闻"      , "📰",
"方位"      , "🧭",
"方便"      , "🏪",
"方向"      , "⬆",
"方格旗"     , "🏁",
"旅行"      , "🧳",
"旋转"      , "💞",
"旋风"      , "🌪",
"旗"       , "🎏",
"无"       , "🈚",
"无声"      , "😶",
"无头发"     , "🦲",
"无用"      , "🪴",
"无知"      , "🤷",
"无表情"     , "😐",
"无表达"     , "😑",
"无限"      , "♾",
"无限制"     , "♾",
"无障碍"     , "🛗",
"日元"      , "💹",
"日出"      , "🌄",
"日历"      , "📅",
"日圆"      , "💴",
"日式"      , "🏣",
"日期"      , "📅",
"日本"      , "🍙",
"日落"      , "🌆",
"旧"       , "🗝",
"旧锁匙"     , "🗝",
"早上"      , "🌄",
"早餐"      , "🥣",
"时钟"      , "⌚",
"时髦"      , "💁",
"昆虫"      , "🪲",
"明星"      , "🤩",
"明星脸"     , "🤩",
"星"       , "💫",
"星夜"      , "🌃",
"星座"      , "👧",
"星星"      , "🌃",
"显微镜"     , "🔬",
"晕"       , "🥴",
"晚上"      , "🌉",
"晚礼服"     , "🤵",
"景观"      , "🪟",
"晴朗"      , "☀",
"智力"      , "🧠",
"智慧"      , "🦉",
"暂停"      , "⏯",
"暗"       , "🔅",
"暴龙"      , "🦖",
"曱甴"      , "🪳",
"曲发"      , "🦱",
"曲奇"      , "🍪",
"曲棍球"     , "🏑",
"月"       , "🌒",
"月亮"      , "🌑",
"月经"      , "🩸",
"月费"      , "🈷",
"月饼"      , "🥮",
"有"       , "🈶",
"有雾"      , "🌁",
"服务"      , "🐕‍🦺",
"服务员"     , "🛎",
"服务费"     , "🈂",
"服装"      , "👣",
"望远镜"     , "🔭",
"木"       , "🪓",
"木头"      , "🪵",
"木屐"      , "🩴",
"木工"      , "🪚",
"木材"      , "🪚",
"木桶"      , "🪣",
"木锯"      , "🪚",
"未成年"     , "🔞",
"朱古力"     , "🫕",
"机动船"     , "🛥",
"机械人"     , "🤖",
"机械脚"     , "🦿",
"机械臂"     , "🦾",
"杂耍"      , "🤹",
"条"       , "🍫",
"条纹"      , "🦓",
"来"       , "📨",
"杯"       , "🥛",
"松树"      , "🎍",
"板"       , "🛹",
"板手"      , "🔧",
"板球"      , "🏏",
"果仁"      , "🥜",
"果汁"      , "🥤",
"果汁盒"     , "🧃",
"果汁酒"     , "🥥",
"枪"       , "🎉",
"枫叶"      , "🍁",
"枫树"      , "🍁",
"柑桔"      , "🍊",
"柑橘"      , "🍋",
"柔软"      , "🔈",
"柔道"      , "🥋",
"柜"       , "🗄",
"柠檬"      , "🍋",
"标志"      , "🪧",
"标签"      , "📑",
"标记"      , "📑",
"标语"      , "🪧",
"树"       , "🌲",
"树熊"      , "🐨",
"树獭"      , "🦥",
"栗子"      , "🌰",
"格子"      , "🏁",
"桃"       , "🍑",
"框架"      , "🪟",
"框画"      , "🖼",
"桌球"      , "🎱",
"桌面"      , "🖥",
"桑拿"      , "🧖",
"档案"      , "📁",
"档案柜"     , "🗄",
"桶"       , "🛢",
"梅花"      , "♣",
"梨"       , "🍐",
"梯"       , "🪜",
"梯级"      , "🪜",
"梳打"      , "🥤",
"检查"      , "🛂",
"棍"       , "🥍",
"棒"       , "🍢",
"棒型图"     , "📊",
"棒球"      , "⚾",
"棒球帽"     , "🧢",
"棕榈"      , "🌴",
"棕榈树"     , "🌴",
"棺材"      , "⚰",
"植物"      , "🪴",
"椰子"      , "🥥",
"榄球"      , "🏉",
"槿"       , "🌺",
"模式"      , "📳",
"横额"      , "🎋",
"樱花"      , "🌸",
"樽"       , "🍼",
"橄榄"      , "🫒",
"橙"       , "🍊",
"橙色"      , "🧡",
"橙色书"     , "📙",
"橙色心"     , "🧡",
"櫈"       , "💺",
"欧元"      , "💶",
"欧洲"      , "🌍",
"欧陆式"     , "🏰",
"歌手"      , "🧑‍🎤",
"歌记号"     , "〽",
"正义"      , "👨‍⚖",
"正方形"     , "⏹",
"步"       , "🪜",
"武器"      , "🔪",
"武术"      , "🥋",
"死"       , "💀",
"死亡"      , "☠",
"残月"      , "🌘",
"殡仪馆"     , "⚱",
"殭尸"      , "🧟",
"毒菌"      , "🍄",
"比坚尼"     , "👙",
"比赛"      , "🏐",
"比高包"     , "🥯",
"毕业"      , "🧑‍🎓",
"毕业帽"     , "🎓",
"毛绒"      , "🧸",
"气体"      , "⛽",
"气球"      , "💬",
"水"       , "🤽",
"水坝"      , "🦫",
"水晶"      , "🔮",
"水晶球"     , "🔮",
"水果"      , "🥭",
"水桶"      , "🪣",
"水泥"      , "🧱",
"水点"      , "☔",
"水牛"      , "🦬",
"水狸"      , "🦫",
"水球"      , "🤽",
"水瓶座"     , "🏺",
"水龟"      , "🐢",
"永远"      , "♾",
"求助"      , "🆘",
"汉堡包"     , "🍔",
"汗"       , "😅",
"汽球"      , "🎈",
"汽车"      , "🚞",
"沉默"      , "😯",
"沙"       , "⌛",
"沙发"      , "🛋",
"沙律"      , "🥗",
"沙漏"      , "⏳",
"沙漠"      , "🏜",
"沮丧"      , "😔",
"河马"      , "🦛",
"油"       , "🛢",
"油桶"      , "🛢",
"治疗师"     , "🧑‍⚕",
"治疗犬"     , "🐕‍🦺",
"泉"       , "♨",
"泊车"      , "🅿",
"法国"      , "🥐",
"法官"      , "🧑‍⚖",
"法式"      , "🥖",
"泡"       , "🧋",
"泡泡"      , "💬",
"泡菜"      , "🥒",
"波"       , "🏌",
"波板糖"     , "🍭",
"波浪"      , "🌊",
"注册"      , "®",
"注射"      , "💉",
"注释"      , "🗒",
"泳衣"      , "🩱",
"泳裤"      , "🩲",
"泵"       , "⛽",
"洋葱"      , "🧅",
"洗头水"     , "🧴",
"洗手间"     , "🚹",
"洗衫"      , "🧺",
"洞"       , "⛳",
"派对"      , "🪅",
"派对枪"     , "🎉",
"流动"      , "📱",
"流口水"     , "🤤",
"流星"      , "🌠",
"浅"       , "🥘",
"浅肤色"     , "🏻",
"浓汤"      , "🦞",
"浪漫"      , "💒",
"浮潜"      , "🤿",
"浴室"      , "🪥",
"浴缸"      , "🛀",
"海"       , "⛵",
"海关"      , "🛃",
"海洋"      , "🌊",
"海浪"      , "🌊",
"海滩"      , "🏖",
"海狮"      , "🦭",
"海盗"      , "🦜",
"海盗旗"     , "🏴‍☠",
"海绵"      , "🧽",
"海豚"      , "🐬",
"海豹"      , "🦭",
"海鲜"      , "🍢",
"海龟"      , "🐢",
"消闲"      , "♟",
"消防员"     , "🧑‍🚒",
"消防车"     , "🧑‍🚒",
"润肤霜"     , "🧴",
"深肤色"     , "🏿",
"清洁"      , "🧹",
"清真寺"     , "🕌",
"清酒"      , "🍶",
"渡船"      , "⛴",
"温度计"     , "🌡",
"温泉"      , "♨",
"游乐场"     , "🎡",
"游戏"      , "🥌",
"游戏杆"     , "🕹",
"游水"      , "🏊",
"游艇"      , "⛵",
"溅"       , "💦",
"溜冰"      , "⛸",
"溜冰鞋"     , "🛼",
"滑块"      , "🎚",
"滑板"      , "🛹",
"滑板车"     , "🛵",
"滑浪"      , "🏄",
"滑翔伞"     , "🪂",
"滑雪"      , "⛷",
"滑雪板"     , "🏂",
"滚动"      , "📜",
"滚筒"      , "🎢",
"滚轴"      , "🛼",
"满"       , "🌕",
"满分"      , "💯",
"满意"      , "😆",
"满月"      , "🌕",
"满月面"     , "🌝",
"滴汗"      , "💦",
"演员"      , "🧑‍🎤",
"漩涡"      , "🍥",
"漫画"      , "💩",
"潜水"      , "🦪",
"潜水镜"     , "🤿",
"澳洲"      , "🪃",
"火"       , "🚒",
"火山"      , "🌋",
"火焰"      , "🔥",
"火箭"      , "🧑‍🚀",
"火花"      , "🎇",
"火车"      , "🚂",
"火鸡"      , "🦃",
"灯"       , "🚨",
"灯泡"      , "💡",
"灯笼"      , "🎃",
"灯笼椒"     , "🫑",
"灯胆"      , "💡",
"灰烬"      , "⚱",
"灰色"      , "🦳",
"炖"       , "🍲",
"炮丈"      , "🧨",
"炸"       , "🍤",
"炸弹"      , "💣",
"炸药"      , "🧨",
"炸虾"      , "🍤",
"点"       , "🕛",
"烈酒"      , "🥃",
"烈酒㷴"     , "🥃",
"烘焙"      , "🥯",
"烛台"      , "🕎",
"烟肉"      , "🥓",
"烟花"      , "🎆",
"烤肉串"     , "🥙",
"烤饼"      , "🫓",
"烧焊"      , "🥽",
"烩"       , "🍠",
"烩番薯"     , "🍠",
"热"       , "🥵",
"热带"      , "🦩",
"热带鱼"     , "🐠",
"热狗"      , "🌭",
"热腾腾"     , "♨",
"热饮"      , "☕",
"热香饼"     , "🥞",
"煎"       , "🍳",
"煮熟"      , "🍚",
"煮食"      , "🍳",
"煲"       , "🫕",
"熄"       , "🧯",
"熊"       , "🐻",
"熊仔"      , "🧸",
"熊猫"      , "🐼",
"熊猫脸"     , "🐼",
"熊脸"      , "🐻",
"燃油"      , "⛽",
"燃油泵"     , "⛽",
"燕尾服"     , "🤵‍♀",
"燕麦"      , "🥣",
"爆发"      , "🌋",
"爆炸"      , "🧨",
"爆炸头"     , "🤯",
"爆谷"      , "🍿",
"爪"       , "🦞",
"爬"       , "🪜",
"爱"       , "😍",
"爱情"      , "💌",
"片"       , "🍕",
"片装"      , "🍰",
"版权"      , "©",
"牌"       , "📛",
"牙"       , "🪥",
"牙刷"      , "🪥",
"牙医"      , "🦷",
"牙科"      , "🪥",
"牙齿"      , "🦷",
"牛"       , "🐮",
"牛仔"      , "🤠",
"牛仔裤"     , "👖",
"牛女"      , "🤠",
"牛奶"      , "🧋",
"牛扒"      , "🥩",
"牛油"      , "🧈",
"牛油果"     , "🥑",
"牛脸"      , "🐮",
"牛角"      , "😈",
"牛角包"     , "🥐",
"牛角卷"     , "🥐",
"牧人"      , "👨‍🌾",
"犀牛"      , "🦏",
"犯罪"      , "🦹",
"犹太人"     , "✡",
"犹太教"     , "🕍",
"狂热"      , "🥵",
"狐狸"      , "🦊",
"狐狸脸"     , "🦊",
"狗"       , "🐶",
"狗脸"      , "🐶",
"狡猾"      , "🦝",
"独峰驼"     , "🐪",
"独木舟"     , "🛶",
"独角兽"     , "🦄",
"狮子"      , "🦁",
"狮子座"     , "🦁",
"狮子狗"     , "🐩",
"狮子脸"     , "🦁",
"狸"       , "🦝",
"狼"       , "🐺",
"狼脸"      , "🐺",
"猩猩"      , "🦧",
"猪"       , "🐷",
"猪公"      , "🐗",
"猪扒"      , "🥩",
"猪脸"      , "🐷",
"猪鼻"      , "🐽",
"猫"       , "😺",
"猫头鹰"     , "🦉",
"猫脸"      , "🐱",
"猿"       , "🦧",
"獭"       , "🦦",
"獾"       , "🦡",
"玉米"      , "🌽",
"王子"      , "🤴",
"玛黛茶"     , "🧉",
"玩"       , "🎴",
"玩具"      , "🪀",
"玫瑰"      , "🌹",
"环虫"      , "🪱",
"玻璃"      , "🥃",
"玻璃杯"     , "🍸",
"珍珠"      , "🧋",
"珠"       , "🧿",
"珠宝"      , "💎",
"班卓琴"     , "🪕",
"班戟"      , "🥞",
"球"       , "🤾",
"球场"      , "🏑",
"球拍"      , "🏓",
"球棒"      , "🏏",
"理发"      , "💇",
"瑜伽"      , "🧘",
"瑞士"      , "🫕",
"瓦肯式"     , "🖖",
"瓮"       , "⚱",
"甜"       , "🍡",
"甜品"      , "🍡",
"生命"      , "🧬",
"生姜"      , "🦰",
"生果"      , "🍇",
"生物"      , "👹",
"生物学"     , "🧫",
"生病"      , "🤒",
"生肖"      , "⛎",
"生菜"      , "🥬",
"生蚝"      , "🦪",
"用笔锁"     , "🔏",
"甲壳虫"     , "🪲",
"甲虫"      , "🪲",
"申"       , "🈸",
"申请"      , "🈸",
"电"       , "🚃",
"电力"      , "⚡",
"电单车"     , "🏍",
"电压"      , "⚡",
"电工"      , "🧑‍🔧",
"电影"      , "🎥",
"电池"      , "🔋",
"电筒"      , "🔦",
"电脑"      , "💻",
"电视机"     , "📺",
"电话"      , "📱",
"电车"      , "🚃",
"电邮"      , "✉",
"男"       , "👱‍♂",
"男人"      , "👨",
"男仔"      , "👦",
"男仙子"     , "🧚‍♂",
"男侦探"     , "🕵‍♂",
"男农夫"     , "👨‍🌾",
"男厕"      , "🚹",
"男厨师"     , "👨‍🍳",
"男士"      , "👞",
"男学生"     , "👨‍🎓",
"男巫"      , "🧙",
"男巫师"     , "🧙‍♂",
"男技工"     , "👨‍🔧",
"男教师"     , "👨‍🏫",
"男歌手"     , "👨‍🎤",
"男殭尸"     , "🧟‍♂",
"男法官"     , "👨‍⚖",
"男精灵"     , "🧝‍♂",
"男装鞋"     , "👞",
"男警察"     , "👮‍♂",
"男超人"     , "🦸‍♂",
"画画"      , "🖌",
"画笔"      , "🖌",
"画面"      , "🎞",
"番枧"      , "🧼",
"番枧盒"     , "🧼",
"番茄"      , "🍅",
"番薯"      , "🍠",
"疟疾"      , "🦟",
"疾病"      , "🪰",
"病"       , "😷",
"病毒"      , "🦟",
"痛苦"      , "😬",
"痢"       , "😛",
"登山者"     , "🧗",
"白兔"      , "🐰",
"白羊座"     , "🐏",
"白色"      , "🤍",
"白色心"     , "🤍",
"白色旗"     , "🏳",
"白花"      , "💮",
"白菜"      , "🥬",
"白领"      , "🧑‍💼",
"百"       , "💯",
"百撘卡"     , "🃏",
"的士"      , "🚕",
"皇冠"      , "👑",
"皮纳塔"     , "🪅",
"皱眉"      , "☹",
"盆栽"      , "🪴",
"盈"       , "🌒",
"盈凸月"     , "🌔",
"盐"       , "🧂",
"盐樽"      , "🧂",
"盒"       , "🍱",
"盒子"      , "📥",
"目标"      , "🥍",
"盲"       , "👨‍🦯",
"盲人"      , "🧑‍🦯",
"直升机"     , "🚁",
"直尺"      , "📏",
"直边"      , "📏",
"相机"      , "🤳",
"盾"       , "🛡",
"眨眼"      , "😉",
"眼"       , "😄",
"眼泪"      , "🥲",
"眼睛"      , "🤩",
"眼镜"      , "🥸",
"着上"      , "🥿",
"睇"       , "🙈",
"短裤"      , "🩳",
"石"       , "🥌",
"石头"      , "🪨",
"砂浆"      , "🧱",
"砂锅"      , "🥘",
"砌图"      , "🧩",
"砖"       , "🧱",
"破折号"     , "〰",
"破碎"      , "💔",
"硬币"      , "🪙",
"碌地"      , "🤣",
"碎"       , "💔",
"碗"       , "🍜",
"碟"       , "🍽",
"碰撞"      , "💥",
"磁力"      , "🧭",
"磁性"      , "🧲",
"磁石"      , "🧲",
"磁碟"      , "💾",
"礼物"      , "🧧",
"祈祷"      , "🤲",
"祝"       , "㊗",
"神奇"      , "🧝",
"神教"      , "⛩",
"神社"      , "⛩",
"祷告"      , "📿",
"禁"       , "🈲",
"禁止"      , "🙈",
"禁钉"      , "📌",
"离境"      , "🛫",
"禾束"      , "🌾",
"秋天"      , "🥮",
"科学"      , "🧪",
"科学家"     , "🧑‍🔬",
"秒表"      , "⏱",
"秘"       , "㊙",
"秘密"      , "㊙",
"秤"       , "👨‍⚖",
"穆斯林"     , "🕌",
"穗"       , "🌾",
"空"       , "🈳",
"空中"      , "🚡",
"空手道"     , "🥋",
"突起"      , "🌔",
"窗"       , "🪟",
"窝夫"      , "🧇",
"窿"       , "🕳",
"竖起"      , "👍",
"章鱼"      , "🐙",
"童话"      , "👼",
"竹"       , "🎍",
"竿"       , "🎣",
"笃笃"      , "🛺",
"笑"       , "😆",
"笑脸"      , "😀",
"笔"       , "✒",
"笔尖"      , "✒",
"笔记板"     , "📋",
"笔记簿"     , "📔",
"符号"      , "❣",
"第一"      , "🥇",
"第三"      , "🥉",
"第二"      , "🥈",
"筷子"      , "🥢",
"算盘"      , "🧮",
"箭"       , "💘",
"箭咀"      , "📲",
"箭头"      , "🏹",
"箭靶"      , "🎯",
"箱"       , "🧰",
"篮"       , "🧺",
"篮圈"      , "🏀",
"篮球"      , "🏀",
"簿记"      , "🧾",
"米"       , "🌾",
"米饼"      , "🍘",
"粉碎"      , "🥰",
"粗乘号"     , "✖",
"粗减号"     , "➖",
"粗剔号"     , "✔",
"粗加号"     , "➕",
"粗除号"     , "➗",
"粟米"      , "🌽",
"粟米饼"     , "🫓",
"粥"       , "🥣",
"粪便"      , "💩",
"粱龙"      , "🦕",
"糕点"      , "🍥",
"糖果"      , "🍬",
"索引"      , "🗂",
"紧张"      , "💗",
"紧急"      , "🦺",
"紫色"      , "💜",
"紫色心"     , "💜",
"累"       , "😩",
"累嘅脸"     , "😫",
"纠察"      , "🪧",
"纠缠"      , "🦡",
"红"       , "😡",
"红包"      , "🧧",
"红心"      , "♥",
"红色"      , "🍎",
"红色心"     , "❤",
"红苹果"     , "🍎",
"红萝卜"     , "🥕",
"红酒杯"     , "🍷",
"红面"      , "🥵",
"红鹤"      , "🦩",
"级别"      , "🎚",
"纪念"      , "🎗",
"纱丽"      , "🥻",
"纳扎尔"     , "🧿",
"纸"       , "📜",
"纸屑"      , "🎊",
"纸屑球"     , "🎊",
"纸巾"      , "🧻",
"纸币"      , "💴",
"纸牌"      , "♠",
"线"       , "🧵",
"线索"      , "🧩",
"组合"      , "📐",
"组装"      , "🪆",
"细"       , "🤪",
"细菌"      , "🦠",
"终极"      , "🥏",
"经理"      , "🧑‍💼",
"结"       , "🪢",
"结他"      , "🎸",
"结束"      , "🔚",
"绘画"      , "🖼",
"绝种"      , "🦣",
"绳"       , "🪢",
"绳球"      , "🪢",
"绵羊"      , "🐏",
"绷带"      , "🤕",
"绿色"      , "💚",
"绿色书"     , "📗",
"绿色心"     , "💚",
"缆"       , "🚠",
"缆车"      , "🚠",
"缝纫"      , "🧵",
"缝纫针"     , "🪡",
"缝线"      , "🪡",
"缝补"      , "🪡",
"缝针"      , "🪡",
"缸"       , "🪣",
"罐"       , "🍯",
"罐头"      , "🥫",
"网"       , "🕸",
"网球"      , "🎾",
"网球拍"     , "🎾",
"羊扒"      , "🥩",
"羊毛"      , "🦣",
"羊驼"      , "🦙",
"美人鱼"     , "🧜",
"美元"      , "💵",
"美容"      , "💇",
"美容店"     , "💆",
"美式"      , "🏈",
"美洲"      , "🌎",
"羽毛"      , "🪶",
"羽毛球"     , "🏸",
"翼"       , "💸",
"老"       , "🦳",
"老人"      , "🧓",
"老伯伯"     , "👴",
"老婆婆"     , "👵",
"老师"      , "🧑‍🏫",
"老年"      , "🧓",
"老虎"      , "🐯",
"老虎机"     , "🎰",
"老虎脸"     , "🐯",
"老鼠"      , "🐭",
"老鼠夹"     , "🪤",
"老鼠脸"     , "🐭",
"耕种"      , "🧺",
"耳仔"      , "👂",
"耳机"      , "🎧",
"耸肩"      , "🤷",
"聋"       , "🧏",
"聋人"      , "🧏",
"联锁"      , "🧩",
"肉"       , "🍖",
"肉丸"      , "🧆",
"肉块"      , "🥩",
"肉菜饭"     , "🥘",
"肉连⻣"     , "🍖",
"肌肉"      , "💪",
"肢"       , "🦵",
"肤色"      , "🏻",
"肩带"      , "🎽",
"肺"       , "🫁",
"背囊"      , "🥾",
"背心"      , "🦺",
"胜利"      , "✌",
"胡椒粉"     , "🫑",
"胶布"      , "🩹",
"胸像"      , "👤",
"脉冲"      , "🫀",
"脉动"      , "💗",
"脑"       , "🧠",
"脚"       , "🦵",
"脚印"      , "👣",
"脚掌"      , "🦶",
"脱落"      , "🌳",
"脸"       , "😀",
"脸红"      , "😳",
"腐烂"      , "🪰",
"腕龙"      , "🦕",
"腮红"      , "😊",
"自动化"     , "🏧",
"自拍"      , "🤳",
"自来水"     , "🚰",
"自然"      , "😐",
"自由"      , "🗽",
"自行车"     , "🚳",
"自豪"      , "🥲",
"臭"       , "💩",
"臭鼬"      , "🦨",
"舞蹈员"     , "👯",
"航班"      , "🪶",
"船"       , "⚓",
"艇"       , "🚣",
"色士风"     , "🎷",
"艺人"      , "👨‍🎤",
"艺术"      , "🎭",
"艺术家"     , "👨‍🎨",
"节奏"      , "🪘",
"节日"      , "🥮",
"芒果"      , "🥭",
"芝士"      , "🫕",
"芭蕾舞"     , "🩰",
"花"       , "💐",
"花园"      , "🏡",
"花束"      , "💐",
"花栗鼠"     , "🐿",
"花洒"      , "🚿",
"花环"      , "🏵",
"花生"      , "🥜",
"花纸牌"     , "🎴",
"苦恼"      , "😧",
"英镑"      , "💷",
"英雄"      , "🦸",
"苹果"      , "🍎",
"茄子"      , "🍆",
"茶"       , "🧋",
"茶壶"      , "🫖",
"茶杯"      , "🍵",
"草"       , "🍀",
"草蜢"      , "🦗",
"荒岛"      , "🏝",
"荒废"      , "🏚",
"药"       , "😷",
"药丸"      , "💊",
"莓"       , "🫐",
"莫伊"      , "🗿",
"菜"       , "🥬",
"菠萝"      , "🍍",
"菱形"      , "🔶",
"营"       , "🈺",
"营业"      , "🈺",
"落叶"      , "🍁",
"落叶树"     , "🌳",
"落雨"      , "🌈",
"葬礼"      , "⚱",
"葵扇"      , "♠",
"蒙古包"     , "🛖",
"蒜头"      , "🧄",
"蒸气"      , "🍜",
"蒸气房"     , "🧖",
"蒸汽"      , "🚂",
"蒸馏器"     , "⚗",
"蓝光"      , "📀",
"蓝色"      , "🫐",
"蓝色书"     , "📘",
"蓝色心"     , "💙",
"蓝莓"      , "🫐",
"蔬菜"      , "🫑",
"薄班戟"     , "🥞",
"薄饼"      , "🫓",
"薯仔"      , "🥔",
"薯条"      , "🍟",
"蘑菇"      , "🍄",
"虎头钳"     , "🗜",
"虫"       , "🪱",
"虾"       , "🍤",
"蚂蚁"      , "🐜",
"蚊"       , "🦟",
"蚝桶"      , "🥡",
"蚯蚓"      , "🪱",
"蛆"       , "🪰",
"蛇"       , "🐍",
"蛇夫座"     , "🐍",
"蛋"       , "🥚",
"蛋糕"      , "🎂",
"蜂蜜獾"     , "🦡",
"蜗牛"      , "🐌",
"蜘蛛"      , "🕷",
"蜘蛛网"     , "🕸",
"蜜瓜"      , "🍈",
"蜜糖"      , "🍯",
"蜜糖罐"     , "🍯",
"蜜蜂"      , "🐝",
"蜡烛"      , "🕯",
"蜡笔"      , "🖍",
"蜥蜴"      , "🦎",
"蝎子"      , "🦂",
"蝙蝠"      , "🦇",
"蝴蝶"      , "🦋",
"蝴蝶结"     , "💝",
"蝴蝶酥"     , "🥨",
"融"       , "🫕",
"螺"       , "🐚",
"螺丝"      , "🪛",
"螺丝批"     , "🪛",
"螺旋"      , "🗒",
"螺旋形"     , "🐚",
"螺栓"      , "🔩",
"螺母"      , "🔩",
"蟹"       , "🦀",
"血型"      , "🅰",
"血液"      , "🩸",
"行人"      , "🚸",
"行尸"      , "🧟",
"行山"      , "🥾",
"行山鞋"     , "🥾",
"行李"      , "🧳",
"行紧路"     , "🚶",
"行路"      , "🚶",
"表情"      , "🙍",
"表演"      , "🎭",
"衫"       , "🎽",
"袋"       , "👝",
"袋棍球"     , "🥍",
"袋鼠"      , "🦘",
"袜"       , "🧦",
"裁剪"      , "🪡",
"装配"      , "👨‍🏭",
"装饰"      , "📔",
"裇衫"      , "👕",
"裙"       , "👗",
"裤"       , "👖",
"西"       , "⬅",
"西兰花"     , "🥦",
"西北"      , "↖",
"西南"      , "↙",
"西瓜"      , "🍉",
"西装"      , "🕴",
"见证"      , "👁‍🗨",
"解锁"      , "🔓",
"警告"      , "⚠",
"警员"      , "👮",
"警官"      , "👮",
"警察"      , "👮",
"警报"      , "⏰",
"警示灯"     , "🚨",
"警车"      , "🚓",
"警车灯"     , "🚨",
"计数"      , "🧮",
"计时器"     , "⌛",
"训紧觉"     , "😴",
"训觉"      , "😪",
"讯号"      , "📶",
"讲"       , "🙊",
"讲价"      , "🉐",
"讲大话"     , "🤥",
"讲师"      , "👨‍🏫",
"讲野"      , "💬",
"讽刺"      , "😼",
"证据"      , "🧾",
"证明"      , "🧾",
"试味"      , "😝",
"试管"      , "🧪",
"试食"      , "😋",
"请"       , "🙏",
"谂野"      , "🤔",
"调味"      , "🧄",
"调味料"     , "🧂",
"调查员"     , "🕵",
"调皮"      , "🦦",
"调色板"     , "🧑‍🎨",
"谷物"      , "🌾",
"豹"       , "🐆",
"账簿"      , "📒",
"货币"      , "💴",
"货船"      , "🎢",
"货车"      , "🛻",
"质问"      , "🤌",
"购物"      , "🛍",
"购物袋"     , "🛍",
"购物车"     , "🛒",
"资讯"      , "💁",
"赏月"      , "🎑",
"赛跑"      , "🏃‍♂",
"赛跑衫"     , "🎽",
"赛车"      , "🏎",
"赛马"      , "🏇",
"赢"       , "😤",
"赢咗"      , "😤",
"赶上"      , "🪝",
"起重机"     , "🛗",
"超人"      , "🦸",
"超级"      , "🦸",
"趋势"      , "💹",
"足球"      , "⚽",
"跆拳道"     , "🥋",
"跑"       , "💨",
"跑步"      , "🏃",
"跑鞋"      , "👟",
"跪"       , "🧎",
"跪嘅人"     , "🧎",
"路"       , "🛣",
"跳"       , "🦘",
"跳伞"      , "🪂",
"跳动"      , "💓",
"跳舞"      , "💃",
"踏"       , "🦶",
"踢"       , "🦵",
"踩单车"     , "🚴",
"踫杯"      , "🍻",
"身份"      , "🆔",
"身体"      , "👂",
"车"       , "🚃",
"车厘子"     , "🍒",
"车站"      , "🚉",
"车辆"      , "🚝",
"轨迹球"     , "🖲",
"轮"       , "🎡",
"轮廓"      , "☺",
"轮椅"      , "🧑‍🦼",
"软"       , "🧇",
"软件"      , "🧑‍💻",
"软雪糕"     , "🍦",
"轰"       , "💥",
"轻铁"      , "🚈",
"较剪"      , "✂",
"辅助"      , "🦾",
"输入"      , "🔠",
"辣"       , "🌶",
"辣椒"      , "🫑",
"过山车"     , "🎢",
"过路"      , "🚸",
"运动"      , "👟",
"运动场"     , "🎽",
"运动鞋"     , "👟",
"返回"      , "🔙",
"进入"      , "⛔",
"进化"      , "🧬",
"远足"      , "🚶",
"连住"      , "🖇",
"连结"      , "🔗",
"迪亚"      , "🪔",
"迪亚灯"     , "🪔",
"迷茫"      , "😕",
"退出"      , "⏏",
"送礼"      , "🎁",
"送货"      , "🚚",
"送货车"     , "🚚",
"逆时针"     , "🔄",
"选框"      , "☑",
"透明"      , "🪟",
"通渠"      , "🪠",
"速度"      , "🚄",
"道"       , "☯",
"道教"      , "☯",
"道歉"      , "🙇",
"遗传学"     , "🧬",
"遮"       , "🏖",
"邋遢"      , "🧐",
"邪恶"      , "🙈",
"邪眼"      , "🧿",
"邮件"      , "📧",
"邮局"      , "🏤",
"邮政"      , "🏣",
"邮箱"      , "📫",
"郁金香"     , "🌷",
"部门"      , "🏬",
"酒"       , "🍷",
"酒吧"      , "🍶",
"酒塞"      , "🍾",
"酒店"      , "🛌",
"酱"       , "🥯",
"酷"       , "😎",
"醉"       , "🥴",
"醉嘅脸"     , "🥴",
"醒"       , "😎",
"采矿"      , "⛏",
"重"       , "🪨",
"重覆"      , "🔁",
"重量"      , "⚖",
"野牛"      , "🦬",
"野餐"      , "🧺",
"金"       , "🪙",
"金属"      , "🪙",
"金牌"      , "🥇",
"金牛座"     , "🐂",
"针"       , "🪡",
"针筒"      , "💉",
"针织"      , "🧶",
"钓鱼"      , "🦦",
"钓鱼竿"     , "🎣",
"钟"       , "🛎",
"钢琴"      , "🎹",
"钢笔"      , "🖋",
"钩针"      , "🧶",
"钮"       , "🎛",
"钱"       , "🪙",
"钱袋"      , "💰",
"钳"       , "🗜",
"钻石"      , "💍",
"铁"       , "🧇",
"铁路"      , "🚂",
"铁路车"     , "🚃",
"铃"       , "🎐",
"铅笔"      , "✏",
"铜"       , "🥉",
"铜牌"      , "🥉",
"银"       , "🪙",
"银河"      , "🌌",
"银牌"      , "🥈",
"银纸"      , "💴",
"银行"      , "🏦",
"链"       , "⛓",
"锁"       , "🔓",
"锁匙"      , "🔐",
"锅"       , "🍲",
"锚"       , "⚓",
"锤"       , "🔨",
"锤同挑"     , "⚒",
"键盘"      , "🎹",
"锯"       , "🪚",
"镜"       , "🪞",
"镜片"      , "🔍",
"长大"      , "💗",
"长条"      , "🏮",
"长毛象"     , "🦣",
"长牙"      , "🦣",
"长裤"      , "👖",
"长颈鹿"     , "🦒",
"长鼓"      , "🪘",
"门"       , "🚪",
"门券"      , "🎫",
"闩"       , "📴",
"闩埋"      , "📕",
"闪"       , "💖",
"闪光"      , "📸",
"闪嘅心"     , "💖",
"闪电"      , "🌩",
"闪电云"     , "🌩",
"闪耀"      , "🌟",
"闪闪"      , "❇",
"问"       , "🙏",
"问号"      , "❓",
"问题"      , "⁉",
"间尺"      , "📏",
"间谍"      , "🕵",
"闷"       , "🪴",
"闹钟"      , "⏰",
"防晒"      , "🧴",
"阳"       , "☯",
"阴"       , "☯",
"阴沉"      , "🪐",
"阴阳"      , "☯",
"阶砖"      , "♦",
"阿米巴"     , "🦠",
"陆龟"      , "🐢",
"降落"      , "🛬",
"降落伞"     , "🪂",
"除"       , "➗",
"陶醉"      , "🥴",
"陷阱"      , "🪤",
"隐形"      , "🥷",
"隐私"      , "🔏",
"障碍物"     , "🚧",
"雀"       , "🦃",
"雀仔"      , "🐦",
"雌性"      , "🐑",
"雌性猪"     , "🐖",
"雕像"      , "🗽",
"雨"       , "⛈",
"雨云"      , "🌧",
"雪"       , "⛷",
"雪云"      , "🌨",
"雪人"      , "☃",
"雪山"      , "🏔",
"雪橇"      , "🛷",
"雪糕"      , "🍦",
"雪花"      , "❄",
"雷电"      , "⛈",
"雷龙"      , "🦕",
"雾"       , "🌫",
"震动"      , "📳",
"震惊"      , "🤯",
"露营"      , "🏕",
"青瓜"      , "🥒",
"青色"      , "🍏",
"青苹果"     , "🍏",
"青蛙"      , "🐸",
"青蛙脸"     , "🐸",
"靓"       , "🦩",
"静"       , "🤫",
"静音"      , "🔇",
"非洲"      , "🦱",
"非饮用"     , "🚱",
"面"       , "🥸",
"面具"      , "🥸",
"面包"      , "🍞",
"面纱"      , "🧕",
"靴"       , "🥾",
"靴子"      , "👢",
"靶"       , "🎯",
"靶心"      , "🎯",
"鞋"       , "👞",
"鞠躬"      , "🙏",
"音乐"      , "🎼",
"音符"      , "🎵",
"页"       , "📃",
"顶帽"      , "🎩",
"顶部"      , "🔝",
"项链"      , "📿",
"顺时针"     , "🔃",
"须"       , "🧔",
"预言"      , "🥠",
"预订"      , "🈯",
"领取"      , "🛄",
"领呔"      , "🪢",
"颈"       , "🧣",
"颈巾"      , "🧣",
"风"       , "🍃",
"风筝"      , "🪁",
"风脸"      , "🌬",
"风铃"      , "🎐",
"飘动"      , "🍃",
"飞"       , "🕊",
"飞机"      , "🧑‍✈",
"飞机师"     , "🧑‍✈",
"飞碟"      , "👽",
"飞镖"      , "🎯",
"食物"      , "🫒",
"餐具"      , "🥄",
"饭"       , "🍙",
"饭团"      , "🍙",
"饮"       , "🫖",
"饮品"      , "🍼",
"饮水"      , "🚰",
"饮用"      , "🚰",
"饮管杯"     , "🥤",
"饮酒"      , "🍶",
"饵"       , "🪤",
"饺子"      , "🥟",
"饼"       , "🍘",
"馅料"      , "🥧",
"馅饼"      , "🫓",
"香烟"      , "🚬",
"香肠"      , "🌭",
"香草"      , "🌿",
"香蕉"      , "🍌",
"马"       , "🏇",
"马戏团"     , "🎪",
"马拉松"     , "🏃",
"马脸"      , "🐴",
"马蹄铁"     , "🧲",
"马骝"      , "🙈",
"马骝脸"     , "🐵",
"驼峰"      , "🐪",
"骄傲"      , "🦚",
"骆马"      , "🦙",
"骆驼"      , "🐪",
"骑单车"     , "🚵‍♀",
"骑师"      , "🏇",
"骨"       , "🍖",
"骨头"      , "🦴",
"骰子"      , "🎲",
"骷髅头"     , "💀",
"高压"      , "⚡",
"高尔夫"     , "🏌",
"高根鞋"     , "👠",
"高飞"      , "🪁",
"髪型屋"     , "💈",
"鬼"       , "👻",
"魅力"      , "🧿",
"魔术"      , "🪄",
"魔法棒"     , "🪄",
"魔鬼"      , "👿",
"鱼"       , "🐟",
"鱿鱼"      , "🦑",
"鲤鱼"      , "🎏",
"鲤鱼旗"     , "🎏",
"鲨鱼"      , "🦈",
"鲸鱼"      , "🐳",
"鳄鱼"      , "🐊",
"鳍"       , "🐬",
"鸡"       , "🐔",
"鸡仔"      , "🐤",
"鸡尾酒"     , "🍸",
"鸡泡鱼"     , "🐡",
"鸡肶"      , "🍗",
"鸢尾花"     , "⚜",
"鸣门卷"     , "🍥",
"鸭"       , "🦆",
"鸽"       , "🕊",
"鹰"       , "🦅",
"鹰嘴豆"     , "🧆",
"鹿"       , "🦌",
"麻雀"      , "🀄",
"黄昏"      , "🌆",
"黄色"      , "💛",
"黄色心"     , "💛",
"黎紧"      , "🚍",
"黑暗"      , "🌑",
"黑猫"      , "🐈‍⬛",
"黑色"      , "🖤",
"黑色心"     , "🖤",
"黑色旗"     , "🏴",
"鼓"       , "🪘",
"鼓棍"      , "🥁",
"鼠"       , "🐀",
"鼻"       , "🥸",
"齿轮"      , "⚙",
"龙"       , "🐲",
"龙卷风"     , "🌀",
"龙脸"      , "🐲",
"龙虾"      , "🦞",
"龙门"      , "🥅"
};

};

#endif
