/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

// Test updating the touch simulation `enabled` property

const {
  updateTouchSimulationEnabled,
} = require("devtools/client/responsive.html/actions/touch-simulation");

add_task(function* () {
  let store = Store();
  const { getState, dispatch } = store;

  ok(!getState().touchSimulation.enabled,
    "Touch simulation is disabled by default.");

  dispatch(updateTouchSimulationEnabled(true));

  ok(getState().touchSimulation.enabled,
    "Touch simulation is enabled.");
});
