/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent;

import java.io.PrintStream;
import java.util.Date;
import java.util.Map;

public class ThreadUtil {
    public static void dumpAllStacks() {
        ThreadUtil.dumpAllStacks(System.out);
    }

    public static void dumpAllStacks(PrintStream stream) {
        stream.println("All current live threads (" + new Date().toString() + "):\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Thread thread : stackTraces.keySet()) {
            stream.print("Thread[name=");
            stream.print(thread.getName());
            stream.print(",id=");
            stream.print(thread.getId());
            stream.print(",priority=");
            stream.print(ThreadUtil.getPriorityDescription(thread));
            stream.print(",group=");
            stream.print(thread.getThreadGroup().getName());
            stream.println("]");
            for (StackTraceElement element : stackTraces.get(thread)) {
                stream.print("\tat ");
                stream.println(element);
            }
            stream.println();
        }
    }

    private static String getPriorityDescription(Thread thread) {
        int priority = thread.getPriority();
        if (priority == 1) {
            return priority + " (MIN_PRIORITY)";
        }
        if (priority == 10) {
            return priority + " (MAX_PRIORITY)";
        }
        if (priority == 5) {
            return priority + " (NORM_PRIORITY)";
        }
        return String.valueOf(priority);
    }
}

