/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class BigDecimalParameter
extends NotLongDataParameterHolder {
    private BigDecimal bigDecimal;

    public BigDecimalParameter(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.write(os, this.bigDecimal);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.bigDecimal.toPlainString().getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeStringLength(this.bigDecimal.toPlainString());
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DECIMAL;
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }
}

