/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable no-shadow, max-nested-callbacks */

"use strict";

/**
 * Verify if client can receive binary wasm if 'wasmBinarySource' is set.
 */

var gDebuggee;
var gThreadFront;

add_task(
  threadFrontTest(
    async ({ threadFront, debuggee, client }) => {
      gThreadFront = threadFront;
      gDebuggee = debuggee;

      await gThreadFront.reconfigure({
        observeAsmJS: true,
        wasmBinarySource: true,
      });

      test_source();
    },
    { waitForFinish: true, doNotRunWorker: true }
  )
);

const EXPECTED_CONTENT = String.fromCharCode(
  0,
  97,
  115,
  109,
  1,
  0,
  0,
  0,
  1,
  132,
  128,
  128,
  128,
  0,
  1,
  96,
  0,
  0,
  3,
  130,
  128,
  128,
  128,
  0,
  1,
  0,
  6,
  129,
  128,
  128,
  128,
  0,
  0,
  7,
  133,
  128,
  128,
  128,
  0,
  1,
  1,
  102,
  0,
  0,
  10,
  136,
  128,
  128,
  128,
  0,
  1,
  130,
  128,
  128,
  128,
  0,
  0,
  11
);

function test_source() {
  gThreadFront.once("paused", function(packet) {
    gThreadFront.getSources().then(function(response) {
      Assert.ok(!!response);
      Assert.ok(!!response.sources);

      const source = response.sources.filter(function(s) {
        return s.introductionType === "wasm";
      })[0];

      Assert.ok(!!source);

      const sourceFront = gThreadFront.source(source);
      sourceFront.source().then(function(response) {
        Assert.ok(!!response);
        Assert.ok(!!response.contentType);
        Assert.ok(response.contentType.includes("wasm"));

        const sourceContent = response.source;
        Assert.ok(!!sourceContent);
        Assert.equal(typeof sourceContent, "object");
        Assert.ok("binary" in sourceContent);
        Assert.equal(EXPECTED_CONTENT, sourceContent.binary);

        gThreadFront.resume().then(function() {
          threadFrontTestFinished();
        });
      });
    });
  });

  /* eslint-disable comma-spacing, max-len */
  gDebuggee.eval(
    "(" +
      function() {
        // WebAssembly bytecode was generated by running:
        // js -e 'print(wasmTextToBinary("(module(func(export \"f\")))"))'
        const m = new WebAssembly.Module(
          new Uint8Array([
            0,
            97,
            115,
            109,
            1,
            0,
            0,
            0,
            1,
            132,
            128,
            128,
            128,
            0,
            1,
            96,
            0,
            0,
            3,
            130,
            128,
            128,
            128,
            0,
            1,
            0,
            6,
            129,
            128,
            128,
            128,
            0,
            0,
            7,
            133,
            128,
            128,
            128,
            0,
            1,
            1,
            102,
            0,
            0,
            10,
            136,
            128,
            128,
            128,
            0,
            1,
            130,
            128,
            128,
            128,
            0,
            0,
            11,
          ])
        );
        const i = new WebAssembly.Instance(m);
        debugger;
        i.exports.f();
      } +
      ")()"
  );
}
