.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XPutImage __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XPutImage, XGetImage, XGetSubImage \- transfer images
.SH SYNTAX
.HP
int XPutImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
XImage *\fIimage\fP\^, int \fIsrc_x\fP\^, int \fIsrc_y\fP\^, int
\fIdest_x\fP\^, int \fIdest_y\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^);
.HP
XImage *XGetImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, int
\fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, unsigned long \fIplane_mask\fP\^, int \fIformat\fP\^);
.HP
XImage *XGetSubImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, int
\fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, unsigned long \fIplane_mask\fP\^, int \fIformat\fP\^, XImage
*\fIdest_image\fP\^, int \fIdest_x\fP\^, \fIdest_y\fP\^);
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable.
.IP \fIdest_image\fP 1i
Specifies the destination image.
.ds Dx
.IP \fIdest_x\fP 1i
.br
.ns
.IP \fIdest_y\fP 1i
Specify the x and y coordinates, which are relative to the origin of the drawable
and are the coordinates of the subimage
or which are relative to the origin of the destination rectangle,
specify its upper-left corner, and determine where the subimage
is placed in the destination image.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIformat\fP 1i
Specifies the format for the image.
You can pass
.B XYPixmap
or
.BR ZPixmap .
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fIimage\fP 1i
Specifies the image you want combined with the rectangle.
.IP \fIplane_mask\fP 1i
Specifies the plane mask.
.\" *** JIM: NEED MORE INFO FOR THIS. ***
.IP \fIsrc_x\fP 1i
Specifies the offset in X from the left edge of the image defined
by the
.B XImage
structure.
.IP \fIsrc_y\fP 1i
Specifies the offset in Y from the top edge of the image defined
by the
.B XImage
structure.
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height of the subimage, which define
the dimensions of the rectangle.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates, which are relative to the origin of the drawable
and define the upper-left corner of the rectangle.
.SH DESCRIPTION
The
.B XPutImage
function
combines an image with a rectangle of the specified drawable.
The section of the image defined by the src_x, src_y, width, and height
arguments is drawn on the specified part of the drawable.
If
.B XYBitmap
format is used, the depth of the image must be one,
or a
.B BadMatch
error results.
The foreground pixel in the GC defines the source for the one bits in the image,
and the background pixel defines the source for the zero bits.
For
.B XYPixmap
and
.BR ZPixmap ,
the depth of the image must match the depth of the drawable,
or a
.B BadMatch
error results.
.LP
If the characteristics of the image (for example, byte_order and bitmap_unit)
differ from what the server requires,
.B XPutImage
automatically makes the appropriate
conversions.
.LP
This function uses these GC components:
function, plane-mask, subwindow-mode, clip-x-origin, clip-y-origin,
and clip-mask.
It also uses these GC mode-dependent components:
foreground and background.
.LP
.B XPutImage
can generate
.BR BadDrawable ,
.BR BadGC ,
.BR BadMatch ,
and
.B BadValue
errors.
.LP
The
.B XGetImage
function returns a pointer to an
.B XImage
structure.
This structure provides you with the contents of the specified rectangle of
the drawable in the format you specify.
If the format argument is
.BR XYPixmap ,
the image contains only the bit planes you passed to the plane_mask argument.
If the plane_mask argument only requests a subset of the planes of the
display, the depth of the returned image will be the number of planes
requested.
If the format argument is
.BR ZPixmap ,
.B XGetImage
returns as zero the bits in all planes not
specified in the plane_mask argument.
The function performs no range checking on the values in plane_mask and ignores
extraneous bits.
.LP
.B XGetImage
returns the depth of the image to the depth member of the
.B XImage
structure.
The depth of the image is as specified when the drawable was created,
except when getting a subset of the planes in
.B XYPixmap
format, when the depth is given by the number of bits set to 1 in plane_mask.
.LP
If the drawable is a pixmap,
the given rectangle must be wholly contained within the pixmap,
or a
.B BadMatch
error results.
If the drawable is a window,
the window must be viewable,
and it must be the case that if there were no inferiors or overlapping windows,
the specified rectangle of the window would be fully visible on the screen
and wholly contained within the outside edges of the window,
or a
.B BadMatch
error results.
Note that the borders of the window can be included and read with
this request.
If the window has backing-store, the backing-store contents are
returned for regions of the window that are obscured by noninferior
windows.
If the window does not have backing-store,
the returned contents of such obscured regions are undefined.
The returned contents of visible regions of inferiors
of a different depth than the specified window's depth are also undefined.
The pointer cursor image is not included in the returned contents.
If a problem occurs,
.B XGetImage
returns NULL.
.LP
.B XGetImage
can generate
.BR BadDrawable ,
.BR BadMatch ,
and
.B BadValue
errors.
.LP
The
.B XGetSubImage
function updates dest_image with the specified subimage in the same manner as
.BR XGetImage .
If the format argument is
.BR XYPixmap ,
the image contains only the bit planes you passed to the plane_mask argument.
If the format argument is
.BR ZPixmap ,
.B XGetSubImage
returns as zero the bits in all planes not
specified in the plane_mask argument.
The function performs no range checking on the values in plane_mask and ignores
extraneous bits.
As a convenience,
.B XGetSubImage
returns a pointer to the same
.B XImage
structure specified by dest_image.
.LP
The depth of the destination
.B XImage
structure must be the same as that of the drawable.
If the specified subimage does not fit at the specified location
on the destination image, the right and bottom edges are clipped.
If the drawable is a pixmap,
the given rectangle must be wholly contained within the pixmap,
or a
.B BadMatch
error results.
If the drawable is a window,
the window must be viewable,
and it must be the case that if there were no inferiors or overlapping windows,
the specified rectangle of the window would be fully visible on the screen
and wholly contained within the outside edges of the window,
or a
.B BadMatch
error results.
If the window has backing-store,
then the backing-store contents are returned for regions of the window
that are obscured by noninferior windows.
If the window does not have backing-store,
the returned contents of such obscured regions are undefined.
The returned contents of visible regions of inferiors
of a different depth than the specified window's depth are also undefined.
If a problem occurs,
.B XGetSubImage
returns NULL.
.LP
.B XGetSubImage
can generate
.BR BadDrawable ,
.BR BadGC ,
.BR BadMatch ,
and
.B BadValue
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.B BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.B BadMatch
An
.B InputOnly
window is used as a Drawable.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
