//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QRect;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QPixmap;
import org.kde.qt.QPoint;
import org.kde.qt.QSize;
import java.util.ArrayList;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;

/**

 \short Base class for all your special main frames.
 It contains the child frame area (QMainWindow's central widget) and a child view taskbar
 for switching the MDI views. Most methods are functions for later overriding.
 Basically, this class provides functionality for docking/undocking view windows and
 manages the taskbar. Usually a developer will only need to know about this class and
 \ref KMdiChildView.
 \par General usage
 Your program mainwidget should inherit KMdiMainFrm. Then usually you'll just need
 addWindow() and removeWindowFromMdi() to control the views.
 <pre>
		public class MyMainWindow implements KMdiMainFrm
		{ .... }
 </pre>
 to define your main window class and
 <pre>
		MyMainWindow mainframe;
		qApp.setMainWidget(&mainframe);
		mainframe.addWindow(view1); // put it under MDI control
		mainframe.addWindow(view2);
 </pre>
 when you wish to use your main window class. The above example also adds a few windows
 to the frame.
 KMdiMainFrm will provide the "Window" menu needed in common MDI applications. Just
 insert it in your main menu:
 <pre>
 		if ( !isFakingSDIApplication() )
 		{
 			menuBar().insertItem( i18n( "&Window" ), windowMenu() );
 		}
 </pre>
 To synchronize the positions of the MDI control buttons inserted in your mainmenu:
 <pre>
 		void B_MainModuleWidget.initMenuBar()
 		{
 			setMenuForSDIModeSysButtons( menuBar() );
 		}
 		...
		void B_MainModuleWidget.resizeEvent ( QResizeEvent e )
		{
			KMdiMainFrm.resizeEvent( e );
			setSysButtonsAtMenuPosition();
		}
 </pre>
 \par Dynamic mode switching
 Dynamic switching of the MDI mode can be done via the following functions:
 - switchToChildframeMode()
 - switchToToplevelMode()
 - switchToTabPageMode()
 - switchToIDEAlMode()
 The MDI mode can be gotten using mdiMode(). If you need to fake the look of an SDI application
 use fakeSDIApplication() to fake it and isFakingSDIApplication() to query whether or not an SDI
 interface is being faked.
 You can dynamically change the shape of the attached MDI views using setFrameDecorOfAttachedViews().
 Additionally, here's a hint how to restore the mainframe's settings from config file:
 <pre>
    // restore MDI mode (toplevel, childframe, tabpage)
    int mdiMode = config.readIntEntry( "mainmodule session", "MDI mode", KMdi.ChildframeMode);
    switch (mdiMode) {
    case KMdi.ToplevelMode:
       {
          int childFrmModeHt = config.readIntEntry( "mainmodule session", "Childframe mode height", desktop().height() - 50);
          mainframe.resize( m_pMdiMainFrm.width(), childFrmModeHt);
          mainframe.switchToToplevelMode();
       }
       break;
    case KMdi.ChildframeMode:
       break;
    case KMdi.TabPageMode:
       {
          int childFrmModeHt = m_pCfgFileManager.readIntEntry( "mainmodule session", "Childframe mode height", desktop().height() - 50);
          mainframe.resize( m_pMdiMainFrm.width(), childFrmModeHt);
          mainframe.switchToTabPageMode();
       }
       break;
    default:
       break;
    }
    // restore a possible maximized Childframe mode
    boolean maxChildFrmMode = config.readBoolEntry( "mainmodule session", "maximized childframes", true);
    mainframe.setEnableMaximizedChildFrmMode(maxChildFrmMode);
 </pre>
 The maximized-Childframe mode means that currently all views are maximized in Childframe mode's application desktop.
 \par Managing views
 This class provides placing algorithms in Childframe mode. The following is a list of the window placement functions
 - tilePragma() - Tile the windows and allow them to overlap
 - tileAnodine() - Tile the windows but don't allow them to overlap
 - tileVertically() - Tile the windows vertically
 - cascadeWindows() - cascade windows
 - cascadeMaximized() - cascade windows and maximize their viewing area
 - expandVertical() - expand all the windows to use the most amount of vertical space
 - expandHorizontal() - expand all the windows to use the most amount of horizontal space
 activateView(KMdiChildView) and activateView(int index) set the appropriate MDI child view as the active
 one. It will be raised, will get an active MDI frame and will get the focus. Call activeView() to find out what the
 current MDI view is.
 Use detachWindow() and attachWindow() for docking the MDI views to desktop and back.
 Connect accels of your program with activatePrevWin(), activateNextWin() and activateView(int index).
 Note: KMdiChildViews can be added in 2 meanings: Either as a normal child view (usually containing
 user document views) or as a tool-view (usually containing status, info or control widgets).
 The tool-views can be added as floating dockwidgets or as stay-on-top desktop windows in tool style.
 Also, pay attention to the fact that when you click on the close button of MDI views that their
 close event should be redirected to closeWindow(). Otherwise the mainframe class will
 not get noticed about the deleted view and a dangling pointer will remain in the MDI control. The
 closeWindow() or the removeWindowFromMdi() method is for that issue. The difference is closeWindow()
 deletes the view object. So if your application wants to control that by itself, call removeWindowFromMdi()
 and call delete by yourself. See also KMdiChildView.closeEvent() for that issue.
 Here's an example how you can suggest things for the adding of views to the MDI control via flags:
 <pre>
		m_mapOfMdiWidgets.insert( pWnd, mh );
		unsigned int mdiFlags = KMdi.StandardAdd;
 		if ( !show )
			mdiFlags |= KMdi.Hide;
 		if ( !attach )
			mdiFlags |= KMdi.Detach;
 		if ( minimize )
			mdiFlags |= KMdi.Minimize;
 		if ( bToolWindow)
			mdiFlags |= KMdi.ToolWindow;
		if ( m_pMdiMainFrm.isFakingSDIApplication() )
		{
			if ( attach ) //fake an SDI app
				mdiFlags |= KMdi.Maximize;
		}
		else
		{
			m_pMdiMainFrm.addWindow( pWnd, QPoint(20, 20), KMdi.AddWindowFlags(mdiFlags));
			return;
		}
		m_pMdiMainFrm.addWindow( pWnd, KMdi.AddWindowFlags(mdiFlags));
 </pre>
  See {@link KMdiMainFrmSignals} for signals emitted by KMdiMainFrm
		@short    \short Base class for all your special main frames.

*/
public class KMdiMainFrm extends DockMainWindow  {
	protected KMdiMainFrm(Class dummy){super((Class) null);}
	public static final int DocumentView = 0;
	public static final int ToolView = 1;
	public static final int AnyView = 2;

	public native QMetaObject metaObject();
	public native String className();
	public KMdiMainFrm(QWidget parentWidget, String name, int mdiMode, int flags) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name,mdiMode,flags);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name, int mdiMode, int flags);
	public KMdiMainFrm(QWidget parentWidget, String name, int mdiMode) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name,mdiMode);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name, int mdiMode);
	public KMdiMainFrm(QWidget parentWidget, String name) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name);
	public KMdiMainFrm(QWidget parentWidget) {
		super((Class) null);
		newKMdiMainFrm(parentWidget);
	}
	private native void newKMdiMainFrm(QWidget parentWidget);
	/**	
		 Control whether or not the standard MDI menu is displayed
		 when a context menu is displayed
			 		@short    Control whether or not the standard MDI menu is displayed  when a context menu is displayed
	*/
	public native void setStandardMDIMenuEnabled(boolean showModeMenu);
	public native void setStandardMDIMenuEnabled();
	public native void setManagedDockPositionModeEnabled(boolean enabled);
	/**	
		 Returns whether the application's MDI views are in maximized state or not.
			 		@short    Returns whether the application's MDI views are in maximized state or not.
	*/
	public native boolean isInMaximizedChildFrmMode();
	/**	
		 Returns the MDI mode. This can be one of the enumerations KMdi.MdiMode.
			 		@short    Returns the MDI mode.
	*/
	public native int mdiMode();
	/**	
		 Returns the focused attached MDI view.
			 		@short    Returns the focused attached MDI view.
	*/
	public native KMdiChildView activeWindow();
	/**	
		 Returns a popup menu filled according to the MDI view state. You can override this
		 method to insert additional entries there. The popup menu is usually popuped when the user
		 clicks with the right mouse button on a taskbar entry. The default entries are:
		 Undock/Dock, Restore/Maximize/Minimize, Close and an empty sub-popup ( windowPopup() )
		 menu called Operations.
			 		@short    Returns a popup menu filled according to the MDI view state.
	*/
	public native QPopupMenu taskBarPopup(KMdiChildView pWnd, boolean bIncludeWindowPopup);
	public native QPopupMenu taskBarPopup(KMdiChildView pWnd);
	/**	
		 Returns a popup menu with only a title "Window". You can fill it with own operations entries
		 on the MDI view. This popup menu is inserted as last menu item in taskBarPopup() .
			 		@short    Returns a popup menu with only a title "Window".
	*/
	public native QPopupMenu windowPopup(KMdiChildView pWnd, boolean bIncludeTaskbarPopup);
	public native QPopupMenu windowPopup(KMdiChildView pWnd);
	/**	
		 Called in the constructor (forces a resize of all MDI views)
			 		@short    Called in the constructor (forces a resize of all MDI views)
	*/
	public native void applyOptions();
	/**	
		 Returns the KMdiChildView belonging to the given caption string.
			 		@short    Returns the KMdiChildView belonging to the given caption string.
	*/
	public native KMdiChildView findWindow(String caption);
	/**	
		 Returns whether this MDI child view is under MDI control (using addWindow() ) or not.
			 		@short    Returns whether this MDI child view is under MDI control (using addWindow() ) or not.
	*/
	public native boolean windowExists(KMdiChildView pWnd, int as);
	/**	
		 Catches certain Qt events and processes it here.
		 Currently, here this catches only the KMdiViewCloseEvent (a KMdi user event) which is sent
		 from itself in childWindowCloseRequest() right after a KMdiChildView.closeEvent() .
		 The reason for this event to itself is simple: It just wants to break the function call stack.
		 It continues the processing with calling closeWindow() .
		 You see, a close() is translated to a closeWindow() .
		 It is necessary that the main frame has to start an MDI view close action because it must
		 remove the MDI view from MDI control, additionally.
			 This method calls QMainWindow.event , additionally.
			 		@short    Catches certain Qt events and processes it here.
	*/
	public native boolean event(QEvent e);
	/**	
		 If there's a main menubar given, it will create the 4 maximize mode buttons there (undock, minimize, restore, close).
			 		@short    If there's a main menubar given, it will create the 4 maximize mode buttons there (undock, minimize, restore, close).
	*/
	public native void setSysButtonsAtMenuPosition();
	/**	
		 Returns the height of the taskbar.
			 		@short    Returns the height of the taskbar.
	*/
	public native int taskBarHeight();
	/**	
		 Sets an offset value that is used on detachWindow() . The undocked window
		 is visually moved on the desktop by this offset.
			 		@short    Sets an offset value that is used on detachWindow() .
	*/
	public native void setUndockPositioningOffset(QPoint offset);
	/**	
		 If you don't want to know about the inner structure of the KMdi system, you can use
		 this iterator to handle with the MDI view list in a more abstract way.
		 The iterator hides what special data structure is used in KMdi.
			 		@short    If you don't want to know about the inner structure of the KMdi system, you can use  this iterator to handle with the MDI view list in a more abstract way.
	*/
	// KMdiIterator<KMdiChildView*>* createIterator(); >>>> NOT CONVERTED
	/**	
		 Deletes an KMdiIterator created in the KMdi library (needed for the windows dll problem).
			 		@short    Deletes an KMdiIterator created in the KMdi library (needed for the windows dll problem).
	*/
	// void deleteIterator(KMdiIterator<KMdiChildView*>* arg1); >>>> NOT CONVERTED
	/**	
		 Returns a popup menu that contains the MDI controlled view list.
		 Additionally, this menu provides some placing actions for these views.
		 Usually, you insert this popup menu in your main menubar as "Window" menu.
			 		@short    Returns a popup menu that contains the MDI controlled view list.
	*/
	public native QPopupMenu windowMenu();
	/**	
		 Sets a background color for the MDI view area widget.
			 		@short    Sets a background color for the MDI view area widget.
	*/
	public native void setBackgroundColor(QColor c);
	/**	
		 Sets a background pixmap for the MDI view area widget.
			 		@short    Sets a background pixmap for the MDI view area widget.
	*/
	public native void setBackgroundPixmap(QPixmap pm);
	/**	
		 Sets a size that is used as the default size for a newly to the MDI system added KMdiChildView .
		  By default this size is 600x400. So all non-resized added MDI views appear in that size.
			 		@short    Sets a size that is used as the default size for a newly to the MDI system added KMdiChildView .
	*/
	public native void setDefaultChildFrmSize(QSize sz);
	/**	
		 Returns the default size for a newly added KMdiChildView. See setDefaultChildFrmSize() .
			 		@short    Returns the default size for a newly added KMdiChildView.
	*/
	public native QSize defaultChildFrmSize();
	/**	
		 Do nothing when in Toplevel mode
			 		@short    Do nothing when in Toplevel mode
	*/
	public native void setMinimumSize(int minw, int minh);
	/**	
		 Returns the Childframe mode height of this. Makes only sense when in Toplevel mode.
			 		@short    Returns the Childframe mode height of this.
	*/
	public native int childFrameModeHeight();
	/**	
		 Tells the MDI system a QMenu where it can insert buttons for
		 the system menu, undock, minimize, restore actions.
		 If no such menu is given, KMdi simply overlays the buttons
		 at the upper right-hand side of the main widget.
			 		@short    Tells the MDI system a QMenu where it can insert buttons for  the system menu, undock, minimize, restore actions.
	*/
	public native void setMenuForSDIModeSysButtons(KMenuBar menuBar);
	public native void setMenuForSDIModeSysButtons();
	/**	
		 An SDI application user interface is faked:
		
			<li>
			an opened view is always maximized
			</li>
			
			<li>
			buttons for maximized childframe mode aren't inserted in the main menubar
			</li>
			
			<li>
			taskbar and windowmenu are not created/updated
				 
			</li>		@short    An SDI application user interface is faked:
	*/
	public native void fakeSDIApplication();
	/**	
				@return if we are faking an SDI application (fakeSDIApplication())
	 
		@short
	*/
	public native boolean isFakingSDIApplication();
	public native boolean eventFilter(QObject arg1, QEvent e);
	// void findRootDockWidgets(QPtrList<KDockWidget>* arg1,QValueList<QRect>* arg2); >>>> NOT CONVERTED
	/**	 We're switching something.		@short   We're switching something.
	*/
	public native void setSwitching(boolean switching);
	public native boolean switching();
	/**	
		 addWindow demands a KMdiChildView. This method wraps every QWidget in such an object and
		 this way you can put every widget under MDI control.
			 		@short    addWindow demands a KMdiChildView.
	*/
	public native KMdiChildView createWrapper(QWidget view, String name, String shortName);
	/**	
		 Adds a KMdiChildView to the MDI system. The main frame takes control of it.
		 \param pWnd the parent view.
		 \param flags the flags for the view such as:
		 <li>whether</li> the view should be attached or detached.
		 <li>whether</li> the view should be shown or hidden
		 <li>whether</li> the view should be maximized, minimized or restored (normalized)
		 <li>whether</li> the view should be added as tool view (stay-on-top and toplevel) or added as document-type view.
			 		@short    Adds a KMdiChildView to the MDI system.
	*/
	public native void addWindow(KMdiChildView pWnd, int flags);
	public native void addWindow(KMdiChildView pWnd);
	/**	
		 Adds a KMdiChildView to the MDI system. The main frame takes control of it.
		 \param pWnd the parent view.
		 \param flags
		 You can specify here whether:
		 <li>the</li> view should be attached or detached.
		 <li>shown</li> or hidden
		 <li>maximized</li>, minimized or restored (normalized)
		 <li>added</li> as tool view (stay-on-top and toplevel) or added as
		 document-type view.
		 \param index the index of the tab we should insert the new tab after.
		 If index == -1 then the tab will just be appended to the end.
		 Using this parameter in childview mode has no effect.
		 \since 3.3
			 		@short    Adds a KMdiChildView to the MDI system.
	*/
	public native void addWindow(KMdiChildView pWnd, int flags, int index);
	/**	
		 Adds a KMdiChildView to the MDI system. The main frame takes control of it.
		 \param pWnd the parent view.
		 \param pos move the child view to the specified position
		 \param flags the flags for the view such as:
		 <li>whether</li> the view should be attached or detached.
		 <li>whether</li> the view should be shown or hidden
		 <li>whether</li> the view should be maximized, minimized or restored (normalized)
		 <li>whether</li> the view should be added as tool view (stay-on-top and toplevel) or
		 added as document-type view.
			 		@short    Adds a KMdiChildView to the MDI system.
	*/
	public native void addWindow(KMdiChildView pWnd, QPoint pos, int flags);
	public native void addWindow(KMdiChildView pWnd, QPoint pos);
	/**	
		 Adds a KMdiChildView to the MDI system. The main frame takes control of it.
		 \param pWnd the parent view.
		 \param rectNormal Sets the geometry for this child view
		 \param flags the flags for the view such as:
		 <li>whether</li> the view should be attached or detached.
		 <li>whether</li> the view should be shown or hidden
		 <li>whether</li> the view should be maximized, minimized or restored (normalized)
		 <li>whether</li> the view should be added as tool view (stay-on-top and toplevel) or
		 added as document-type view.
			 		@short    Adds a KMdiChildView to the MDI system.
	*/
	public native void addWindow(KMdiChildView pWnd, QRect rectNormal, int flags);
	public native void addWindow(KMdiChildView pWnd, QRect rectNormal);
	/**	
		 Usually called from addWindow() when adding a tool view window. It reparents the given widget
		 as toplevel and stay-on-top on the application's main widget.
			 		@short    Usually called from addWindow() when adding a tool view window.
	*/
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd, int pos, QWidget pTargetWnd, int percent, String tabToolTip, String tabCaption);
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd, int pos, QWidget pTargetWnd, int percent, String tabToolTip);
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd, int pos, QWidget pTargetWnd, int percent);
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd, int pos, QWidget pTargetWnd);
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd, int pos);
	public native KMdiToolViewAccessor addToolWindow(QWidget pWnd);
	public native void deleteToolWindow(QWidget pWnd);
	public native void deleteToolWindow(KMdiToolViewAccessor accessor);
	/**	
		 Using this method you have to use the setWidget method of the access object, and it is very recommendet, that you use
		 the widgetContainer() method for the parent of your newly created widget
			 		@short    Using this method you have to use the setWidget method of the access object, and it is very recommendet, that you use  the widgetContainer() method for the parent of your newly created widget
	*/
	public native KMdiToolViewAccessor createToolWindow();
	/**	
		 Removes a KMdiChildView from the MDI system and from the main frame`s control.
		 The caller is responsible for deleting the view. If the view is not deleted it will
		 be reparented to 0
			 		@short    Removes a KMdiChildView from the MDI system and from the main frame`s control.
	*/
	public native void removeWindowFromMdi(KMdiChildView pWnd);
	/**	
		 Removes a KMdiChildView from the MDI system and from the main frame`s control.
		 Note: The view will be deleted!
			 		@short    Removes a KMdiChildView from the MDI system and from the main frame`s control.
	*/
	public native void closeWindow(KMdiChildView pWnd, boolean layoutTaskBar);
	public native void closeWindow(KMdiChildView pWnd);
	/**	
		 Switches the KMdiTaskBar on and off.
			 		@short    Switches the KMdiTaskBar on and off.
	*/
	public native void slot_toggleTaskBar();
	/**	
		 Makes a main frame controlled undocked KMdiChildView docked.
		 Doesn't work on KMdiChildView which aren't added to the MDI system.
		 Use addWindow() for that.
			 		@short    Makes a main frame controlled undocked KMdiChildView docked.
	*/
	public native void attachWindow(KMdiChildView pWnd, boolean bShow, boolean bAutomaticResize);
	public native void attachWindow(KMdiChildView pWnd, boolean bShow);
	public native void attachWindow(KMdiChildView pWnd);
	/**	
		 Makes a docked KMdiChildView undocked.
		 The view window still remains under the main frame's MDI control.
			 		@short    Makes a docked KMdiChildView undocked.
	*/
	public native void detachWindow(KMdiChildView pWnd, boolean bShow);
	public native void detachWindow(KMdiChildView pWnd);
	/**	
		 Someone wants that the MDI view to be closed. This method sends a KMdiViewCloseEvent to itself
		 to break the function call stack. See also event() .
			 		@short    Someone wants that the MDI view to be closed.
	*/
	public native void childWindowCloseRequest(KMdiChildView pWnd);
	/**	
		 Close all views
			 		@short    Close all views
	*/
	public native void closeAllViews();
	/**	
		 Iconfiy all views
			 		@short    Iconfiy all views
	*/
	public native void iconifyAllViews();
	/**	
		 Closes the view of the active (topchild) window
			 		@short    Closes the view of the active (topchild) window
	*/
	public native void closeActiveView();
	/**	
		 Undocks all view windows (unix-like)
			 		@short    Undocks all view windows (unix-like)
	*/
	public native void switchToToplevelMode();
	public native void finishToplevelMode();
	/**	
		 Docks all view windows (Windows-like)
			 		@short    Docks all view windows (Windows-like)
	*/
	public native void switchToChildframeMode();
	public native void finishChildframeMode();
	/**	
		 Docks all view windows (Windows-like)
			 		@short    Docks all view windows (Windows-like)
	*/
	public native void switchToTabPageMode();
	public native void finishTabPageMode();
	/**	
		 Docks all view windows. Toolviews use dockcontainers
			 		@short    Docks all view windows.
	*/
	public native void switchToIDEAlMode();
	public native void finishIDEAlMode(boolean full);
	public native void finishIDEAlMode();
	/**	
		 Sets the appearance of the toolview tabs.
			@param flags See KMdi.ToolviewStyle.
				@short    Sets the appearance of the toolview tabs.
	*/
	public native void setToolviewStyle(int flags);
	/**	
				@return if the view taskbar should be shown if there are MDI views
	 
		@short
	*/
	public native boolean isViewTaskBarOn();
	/**	
		 Shows the view taskbar. This should be connected with your "View" menu.
			 		@short    Shows the view taskbar.
	*/
	public native void showViewTaskBar();
	/**	
		 Hides the view taskbar. This should be connected with your "View" menu.
			 		@short    Hides the view taskbar.
	*/
	public native void hideViewTaskBar();
	/**	
		 Update of the window menu contents.
			 		@short    Update of the window menu contents.
	*/
	public native void fillWindowMenu();
	/**	
		 Cascades the windows without resizing them.
			 		@short    Cascades the windows without resizing them.
	*/
	public native void cascadeWindows();
	/**	
		 Cascades the windows resizing them to the maximum available size.
			 		@short    Cascades the windows resizing them to the maximum available size.
	*/
	public native void cascadeMaximized();
	/**	
		 Maximizes only in vertical direction.
			 		@short    Maximizes only in vertical direction.
	*/
	public native void expandVertical();
	/**	
		 Maximizes only in horizontal direction.
					@short    Maximizes only in horizontal direction.
	*/
	public native void expandHorizontal();
	/**	
		 Tile Pragma
			 		@short    Tile Pragma
	*/
	public native void tilePragma();
	/**	
		 Tile Anodine
			 		@short    Tile Anodine
	*/
	public native void tileAnodine();
	/**	
		 Tile Vertically
			 		@short    Tile Vertically
	*/
	public native void tileVertically();
	/**	
		 If in Childframe mode, we can switch between maximized or restored shown MDI views
			 		@short    If in Childframe mode, we can switch between maximized or restored shown MDI views
	*/
	public native void setEnableMaximizedChildFrmMode(boolean bEnable);
	/**	
		 Activates the next open view
			 		@short    Activates the next open view
	*/
	public native void activateNextWin();
	/**	
		 Activates the previous open view
			 		@short    Activates the previous open view
	*/
	public native void activatePrevWin();
	/**	
		 Activates the view first viewed concerning to the access time.
			 		@short    Activates the view first viewed concerning to the access time.
	*/
	public native void activateFirstWin();
	/**	
		 Activates the view last viewed concerning to the access time.
			 		@short    Activates the view last viewed concerning to the access time.
	*/
	public native void activateLastWin();
	/**	
		 Activates the view with the tab page index (TabPage mode only)
			 		@short    Activates the view with the tab page index (TabPage mode only)
	*/
	public native void activateView(int index);
	public native void prevToolViewInDock();
	public native void nextToolViewInDock();
	/**	
				@return the decoration of the window frame of docked (attached) MDI views
	 
		@short
	*/
	public static native int frameDecorOfAttachedViews();
	protected native void resizeEvent(QResizeEvent arg1);
	/**	
		 Creates a new MDI taskbar (showing the MDI views as taskbar entries) and shows it.
			 		@short    Creates a new MDI taskbar (showing the MDI views as taskbar entries) and shows it.
	*/
	protected native void createTaskBar();
	/**	
		 Creates the MDI view area and connects some signals and slots with the KMdiMainFrm widget.
			 		@short    Creates the MDI view area and connects some signals and slots with the KMdiMainFrm widget.
	*/
	protected native void createMdiManager();
	/**	
		 prevents fillWindowMenu() from m_pWindowMenu.clear(). You have to care for it by yourself.
		 This is useful if you want to add some actions in your overridden fillWindowMenu() method.
			 		@short    prevents fillWindowMenu() from m_pWindowMenu.clear().
	*/
	protected native void blockClearingOfWindowMenu(boolean bBlocked);
	// void findToolViewsDockedToMain(QPtrList<KDockWidget>* arg1,KDockWidget::DockPosition arg2); >>>> NOT CONVERTED
	// void dockToolViewsIntoContainers(QPtrList<KDockWidget>& arg1,KDockWidget* arg2); >>>> NOT CONVERTED
	protected native ArrayList prepareIdealToTabs(KDockWidget container);
	protected native void idealToolViewsToStandardTabs(String[] widgetNames, int pos, int sizee);
	/**	 Get tabwidget visibility 		@short   Get tabwidget visibility
	*/
	protected native int tabWidgetVisibility();
	/**	 Set tabwidget visibility 		@short   Set tabwidget visibility
	*/
	protected native void setTabWidgetVisibility(int arg1);
	/**	 Returns the tabwidget used in IDEAl and Tabbed modes. Returns 0 in other modes. 		@short   Returns the tabwidget used in IDEAl and Tabbed modes.
	*/
	protected native KTabWidget tabWidget();
	/**	
		 Sets the focus to this MDI view, raises it, activates its taskbar button and updates
		 the system buttons in the main menubar when in maximized (Maximize mode).
			 		@short    Sets the focus to this MDI view, raises it, activates its taskbar button and updates  the system buttons in the main menubar when in maximized (Maximize mode).
	*/
	protected native void activateView(KMdiChildView pWnd);
	/**	
		 Activates the MDI view (see activateView() ) and popups the taskBar popup menu (see taskBarPopup() ).
			 		@short    Activates the MDI view (see activateView() ) and popups the taskBar popup menu (see taskBarPopup() ).
	*/
	protected native void taskbarButtonRightClicked(KMdiChildView pWnd);
	/**	
		 Turns the system buttons for maximize mode (SDI mode) off, and disconnects them
			 		@short    Turns the system buttons for maximize mode (SDI mode) off, and disconnects them
	*/
	protected native void switchOffMaximizeModeForMenu(KMdiChildFrm oldChild);
	/**	
		 Reconnects the system buttons form maximize mode (SDI mode) with the new child frame
			 		@short    Reconnects the system buttons form maximize mode (SDI mode) with the new child frame
	*/
	protected native void updateSysButtonConnections(KMdiChildFrm oldChild, KMdiChildFrm newChild);
	/**	
		 Usually called when the user clicks an MDI view item in the "Window" menu.
			 		@short    Usually called when the user clicks an MDI view item in the "Window" menu.
	*/
	protected native void windowMenuItemActivated(int id);
	/**	
		 Usually called when the user clicks an MDI view item in the sub-popup menu "Docking" of the "Window" menu.
			 		@short    Usually called when the user clicks an MDI view item in the sub-popup menu "Docking" of the "Window" menu.
	*/
	protected native void dockMenuItemActivated(int id);
	/**	
		 Popups the "Window" menu. See also windowPopup() .
			 		@short    Popups the "Window" menu.
	*/
	protected native void popupWindowMenu(QPoint p);
	/**	
		 The timer for main widget moving has elapsed . send drag end to all concerned views.
			 		@short    The timer for main widget moving has elapsed . send drag end to all concerned views.
	*/
	protected native void dragEndTimeOut();
	/**	
		 internally used to handle click on view close button (TabPage mode, only)
			 		@short    internally used to handle click on view close button (TabPage mode, only)
	*/
	protected native void closeViewButtonPressed();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
