// Qt# tutorial 7
// Based on the Qt tutorial
// Implemented by Marcus Urban
//
// This example currently does not funtion properly because custom
// signals are not yet implemented.

using System;
using Qt;

[DeclareQtSignal ("valueChanged(int)")]
public class LCDRange : QVBox {

	QSlider slider;

	public LCDRange (QWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		QLCDNumber lcd = new QLCDNumber (2, this, "lcd" );
		slider = new QSlider (Orientation.Horizontal, this, "slider");
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, SIGNAL ("valueChanged(int)"), lcd, SLOT ("Display(int)") );
		Connect ( slider, SIGNAL ("valueChanged(int)"), SIGNAL ("valueChanged(int)"));
	}

	public LCDRange (QWidget parent) : this (parent, "") {}
	public LCDRange () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.

	public void SetValue (int value)
	{
		slider.SetValue (value);
	}
}

public class MyWidget : QVBox {

	MyWidget (QWidget parent, String name) : base (parent, name)
	{
		QPushButton quit = new QPushButton ("Quit", this, "quit");
		quit.SetFont ( new QFont ("Times", 18, QFont.Weight.Bold) );
		
		Connect ( quit, SIGNAL ("clicked()"), qApp, SLOT ("Quit()") );
		
		QGrid grid = new QGrid (4, this);
		
		LCDRange previous = null;
		
		for ( int c =0; c < 4; c++ ) {
			for ( int r = 0; r < 4; r++ ) {
				LCDRange lr = new LCDRange (grid);
				if (previous != null)
					Connect (lr, SIGNAL ("valueChanged(int)"),
						previous, SLOT ("SetValue(int)") );
				previous = lr;
			}
		}
	}
	
	public MyWidget (QWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);

		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
