/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.FunctionCall;
import com.google.javascript.rhino.head.ast.FunctionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class FunctionReceiverChecker
extends ContextTrackingChecker {
    private static final Set<String> FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT = new HashSet<String>();
    private static final String SUPPRESSION_HINT = "This check can be suppressed using @suppressReceiverCheck annotation on function declaration.";
    private final Map<String, FunctionRecord> nestedFunctionsByName = new HashMap<String, FunctionRecord>();
    private final Map<String, Set<CallSite>> callSitesByFunctionName = new HashMap<String, Set<CallSite>>();
    private final Map<String, Set<SymbolicArgument>> symbolicArgumentsByName = new HashMap<String, Set<SymbolicArgument>>();
    private final Set<FunctionRecord> functionsRequiringThisAnnotation = new HashSet<FunctionRecord>();

    @Override
    void enterNode(AstNode astNode) {
        switch (astNode.getType()) {
            case 38: {
                this.handleCall((FunctionCall)astNode);
                break;
            }
            case 109: {
                this.handleFunction((FunctionNode)astNode);
                break;
            }
            case 43: {
                this.handleThis();
                break;
            }
        }
    }

    private void handleCall(FunctionCall functionCall) {
        boolean bl;
        String[] stringArray = this.getContext().getNodeText(functionCall.getTarget()).split("\\.");
        String string = stringArray[0];
        List<AstNode> list = functionCall.getArguments();
        List<String> list2 = this.argumentsForCall(list);
        int n = stringArray.length;
        String string2 = stringArray[n - 1];
        this.saveSymbolicArguments(string2, list, list2);
        boolean bl2 = bl = n > 1 && "bind".equals(string2);
        if (bl && n == 3 && "this".equals(string) && (list2.size() <= 0 || !"this".equals(list2.get(0)))) {
            this.reportErrorAtNodeStart(functionCall, "Member function can only be bound to 'this' as the receiver");
            return;
        }
        if (n > 2 || "this".equals(string)) {
            return;
        }
        boolean bl3 = bl && this.isReceiverSpecified(list2);
        FunctionReceiverChecker.getOrCreateSetByKey(this.callSitesByFunctionName, string).add(new CallSite(bl3 |= n == 2 && ("call".equals(string2) || "apply".equals(string2)) && this.isReceiverSpecified(list2), functionCall));
    }

    private void handleFunction(FunctionNode functionNode) {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        if (functionRecord.isTopLevelFunction()) {
            this.symbolicArgumentsByName.clear();
        } else {
            AstNode astNode = AstUtil.getFunctionNameNode(functionNode);
            if (astNode == null) {
                return;
            }
            this.nestedFunctionsByName.put(this.getContext().getNodeText(astNode), functionRecord);
        }
    }

    private void handleThis() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        if (!functionRecord.isTopLevelFunction() && !functionRecord.isConstructor) {
            this.functionsRequiringThisAnnotation.add(functionRecord);
        }
    }

    private List<String> argumentsForCall(List<AstNode> list) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (AstNode astNode : list) {
            arrayList.add(this.getContext().getNodeText(astNode));
        }
        return arrayList;
    }

    private void saveSymbolicArguments(String string, List<AstNode> list, List<String> list2) {
        int n = list2.size();
        CheckedReceiverPresence checkedReceiverPresence = CheckedReceiverPresence.MISSING;
        if (FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.contains(string)) {
            if (n >= 2) {
                checkedReceiverPresence = CheckedReceiverPresence.PRESENT;
            }
        } else if ("addEventListener".equals(string) || "removeEventListener".equals(string)) {
            String string2;
            switch (string2 = n < 3 ? "" : list2.get(2)) {
                case "": 
                case "true": 
                case "false": {
                    checkedReceiverPresence = CheckedReceiverPresence.MISSING;
                    break;
                }
                case "this": {
                    checkedReceiverPresence = CheckedReceiverPresence.PRESENT;
                    break;
                }
                default: {
                    checkedReceiverPresence = CheckedReceiverPresence.IGNORE;
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            String string3 = list2.get(i);
            FunctionReceiverChecker.getOrCreateSetByKey(this.symbolicArgumentsByName, string3).add(new SymbolicArgument(checkedReceiverPresence, list.get(i)));
        }
    }

    private static <K, T> Set<T> getOrCreateSetByKey(Map<K, Set<T>> map, K k) {
        Set<T> set = map.get(k);
        if (set == null) {
            set = new HashSet<T>();
            map.put(k, set);
        }
        return set;
    }

    private boolean isReceiverSpecified(List<String> list) {
        return list.size() > 0 && !"null".equals(list.get(0));
    }

    @Override
    void leaveNode(AstNode astNode) {
        if (astNode.getType() != 109) {
            return;
        }
        ContextTrackingState contextTrackingState = this.getState();
        FunctionRecord functionRecord = contextTrackingState.getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        this.checkThisAnnotation(functionRecord);
        if (!functionRecord.isTopLevelFunction()) {
            return;
        }
        for (FunctionRecord functionRecord2 : this.nestedFunctionsByName.values()) {
            this.processFunctionUsesAsArgument(functionRecord2, this.symbolicArgumentsByName.get(functionRecord2.name));
            this.processFunctionCallSites(functionRecord2, this.callSitesByFunctionName.get(functionRecord2.name));
        }
        this.nestedFunctionsByName.clear();
        this.callSitesByFunctionName.clear();
        this.symbolicArgumentsByName.clear();
    }

    private void checkThisAnnotation(FunctionRecord functionRecord) {
        AstNode astNode = AstUtil.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        boolean bl = this.hasAnnotationTag(functionRecord.functionNode, "this");
        if (bl == this.functionReferencesThis(functionRecord)) {
            return;
        }
        if (bl) {
            if (!functionRecord.isTopLevelFunction()) {
                this.reportErrorAtNodeStart(astNode, "@this annotation found for function not referencing 'this'");
            }
            return;
        }
        this.reportErrorAtNodeStart(astNode, "@this annotation is required for functions referencing 'this'");
    }

    private boolean functionReferencesThis(FunctionRecord functionRecord) {
        return this.functionsRequiringThisAnnotation.contains(functionRecord);
    }

    private void processFunctionCallSites(FunctionRecord functionRecord, Set<CallSite> set) {
        if (set == null) {
            return;
        }
        boolean bl = this.functionReferencesThis(functionRecord);
        for (CallSite callSite : set) {
            if (bl == callSite.hasReceiver || functionRecord.isConstructor) continue;
            if (callSite.hasReceiver) {
                this.reportErrorAtNodeStart(callSite.callNode, "Receiver specified for a function not referencing 'this'");
                continue;
            }
            this.reportErrorAtNodeStart(callSite.callNode, "Receiver not specified for a function referencing 'this'");
        }
    }

    private void processFunctionUsesAsArgument(FunctionRecord functionRecord, Set<SymbolicArgument> set) {
        if (set == null || this.hasAnnotationTag(functionRecord.functionNode, "suppressReceiverCheck")) {
            return;
        }
        boolean bl = this.functionReferencesThis(functionRecord);
        for (SymbolicArgument symbolicArgument : set) {
            boolean bl2;
            if (symbolicArgument.receiverPresence == CheckedReceiverPresence.IGNORE || bl == (bl2 = symbolicArgument.receiverPresence == CheckedReceiverPresence.PRESENT)) continue;
            if (bl) {
                this.reportErrorAtNodeStart(symbolicArgument.node, "Function referencing 'this' used as argument without a receiver. This check can be suppressed using @suppressReceiverCheck annotation on function declaration.");
                continue;
            }
            this.reportErrorAtNodeStart(symbolicArgument.node, "Function not referencing 'this' used as argument with a receiver. This check can be suppressed using @suppressReceiverCheck annotation on function declaration.");
        }
    }

    static {
        FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.add("every");
        FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.add("filter");
        FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.add("forEach");
        FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.add("map");
        FUNCTIONS_WITH_CALLBACK_RECEIVER_AS_SECOND_ARGUMENT.add("some");
    }

    private static class CallSite {
        boolean hasReceiver;
        FunctionCall callNode;

        public CallSite(boolean bl, FunctionCall functionCall) {
            this.hasReceiver = bl;
            this.callNode = functionCall;
        }
    }

    private static class SymbolicArgument {
        CheckedReceiverPresence receiverPresence;
        AstNode node;

        public SymbolicArgument(CheckedReceiverPresence checkedReceiverPresence, AstNode astNode) {
            this.receiverPresence = checkedReceiverPresence;
            this.node = astNode;
        }
    }

    private static enum CheckedReceiverPresence {
        PRESENT,
        MISSING,
        IGNORE;

    }
}

