// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Flags_h__
#define __Flags_h__

namespace Puma {


class Flags {
public:
  enum Flag {
    NONE                       = 0x0,
    
    SKIP_FCT_BODY              = 0x1,
    SKIP_INITS                 = 0x2,
    
    // GNU extensions
    GNU_NESTED_FCT             = 0x4,
    GNU_CONDITION_SCOPE        = 0x8,
    GNU_PARAM_DECL             = 0x10,
    GNU_FCT_DECL               = 0x20,
    GNU_PARAM_SCOPE            = 0x40,
    GNU_DEFAULT_ARGS           = 0x80,
    GNU_EXTENDED_ASM           = 0x100,
    GNU_EXTENDED_EXPR          = 0x200,
    GNU_LONG_LONG              = 0x400,
    GNU_NAME_SCOPE             = 0x800, 
    GNU_IMPLICIT_INT           = 0x1000,
    GNU_FCT_ATTRIBUTE          = 0x2000,
    GNU_IF_THEN_EXPR           = 0x4000
  };
  
private:
  Flag _Flags;
  
public:
  Flags ();
  Flags (const Flags &);
  Flags &operator =(const Flags &);

  // add/remove flag
  Flags &operator +=(Flag);
  Flags &operator -=(Flag);
  
  // test for flag
  bool operator ==(Flag) const;
  bool operator !=(Flag) const;
};

inline Flags::Flags () : _Flags (NONE) 
 {}
inline Flags::Flags (const Flags &f)
 { _Flags = f._Flags; }
inline Flags &Flags::operator =(const Flags &f)
 { _Flags = f._Flags; return *(Flags*)this; }

inline Flags &Flags::operator +=(Flags::Flag f)
 { _Flags = (Flag)(_Flags | f); return *(Flags*)this; }
inline Flags &Flags::operator -=(Flags::Flag f)
 { _Flags = (Flag)(_Flags ^ (_Flags & f)); return *(Flags*)this; }

inline bool Flags::operator ==(Flags::Flag f) const
 { return _Flags & f; }
inline bool Flags::operator !=(Flags::Flag f) const
 { return ! (_Flags & f); }


} // namespace Puma

#endif /* __Flags_h__ */
