##############################################################################
# N.B. CosNaming omitted -- its stubs/skels are already in omniORB libraries.
# The .hh file can be found at <omni_top>/include/<omniORBX>/CosNaming.hh
##############################################################################

##############################################################################
# Note that the anatomy of the *.mms files are a little different from the
# *.mk files.
#
# * dir.mms is generated by premake.py which parses this file to generate
#   some of the dependencies.
#
# * there's no libdef.mms
#
# * this file .include's $(top)/mk/mklib.mms
#
# To pick and choose which interfaces you want, edit the COSINT and COSINT_#
# variables.
##############################################################################

##############################################################################
# Summary of Dependencies:
# 
#    if you use                 precede with
# --------------    -------------------------------------------
# COS_SEC_INT       TIMEBASE_INT
# COS_EVT_INT       TIMEBASE_INT
# COS_NFY_INT       TIMEBASE_INT, COS_EVT_INT
# COS_COL_INT       TIMEBASE_INT, COS_EVT_INT
# COS_LIC_INT       TIMEBASE_INT, COS_EVT_INT, COS_PRP_INT
# COS_LIF_INT       COS_REL_INT
# COS_EXT_INT       COS_REL_INT, COS_LIF_INT
# 
##############################################################################

# The following should be a valid ordering on all the interfaces.
# One could copy + edit this to produce a desired COS_INTERFACES,
# keeping in mind the dependencies above.
#
# COS_TRX_INT and COS_SEC_INT are left out because:
# * Transactions requires:  CORBA::Current, CORBA::Environent
#        -- currently missing from omniORB's CORBA.h
# * Security requires: CORBA::Current,
#                       CORBA::ServiceOption, CORBA::ServiceDetailType
#        -- currently missing from omniORB's CORBA.h


# Uncomment this line to optimize the size of the COS library by only
# including things required by omniNotify.

OPTIMIZE_OMNINOTIFY = 1

# TimeBase is used be many interfaces
TIMEBASE_INT = \
  TimeBase

# Interfaces for CosTime*/CosEvent*
#   DEPENDS_ON: TIMEBASE_INT
COS_EVT_INT = \
  CosTime \
  CosEventComm \
  CosEventChannelAdmin

.ifdef OPTIMIZE_OMNINOTIFY
.else
COS_EVT_INT = $(COS_EVT_INT)\
  CosTypedEventComm \
  CosTypedEventChannelAdmin \
  CosTimerEvent
.endif

# Interfaces for Notification
#   DEPENDS_ON: TIMEBASE_INT, COS_EVT_INT
COS_NFY_INT = \
  CosNotification \
  CosNotifyComm \
  CosNotifyFilter \
  CosNotifyChannelAdmin

.ifdef OPTIMIZE_OMNINOTIFY
.else
COS_NFY_INT = $(COS_NFY_INT)\
  CosTypedNotifyComm \
  CosTypedNotifyChannelAdmin
.endif


# Interfaces for Relationships
COS_REL_INT = \
  CosObjectIdentity \
  CosRelationships \
  CosGraphs \
  CosContainment \
  CosReference

# Interfaces for Transactions and Concurrency
COS_TRX_INT = \
  CosTransactions \
  CosTSPortability \
  CosConcurrencyControl

# Interfaces for PropertyService
COS_PRP_INT = \
  CosPropertyService

# Interfaces for LicensingManager
#   DEPENDS_ON: CosEventComm       (=> TIMEBASE_INT, COS_EVT_INT)
#   DEPENDS_ON: CosPropertyService (=> COS_PRP_INT)
COS_LIC_INT = \
  CosLicensingManager

# Interfaces for Collection
#   DEPENDS_ON: CosEventComm (in TIMEBASE_INT, COS_EVT_INT)
COS_COL_INT = \
  CosCollection

# Interfaces for Security
#   DEPENDS_ON: TIMEBASE_INT
COS_SEC_INT = \
  DCE_CIOPSecurity \
  Security \
  SecurityLevel1 \
  SecurityLevel2 \
  SecurityAdmin \
  SecurityReplaceable \
  NRService \
  SECIOP \
  SSLIOP

# Interfaces for Externalization
#  DEPENDS_ON:  CosLifeCycle (COS_LIF_INT)
#  DEPENDS_ON:  several interfaces in COS_REL_INT
COS_EXT_INT = \
  CosStream \
  CosExternalization \
  CosExternalizationContainment \
  CosExternalizationReference

# Interfaces for LifeCycle basic
#  DEPENDS_ON:  CosNaming
COS_LCB_INT = \
   CosLifeCycle

# Interfaces for LifeCycle
#  DEPENDS_ON:  CosNaming
#  DEPENDS_ON:  several interfaces in COS_REL_INT
COS_LIF_INT = \
  $(COS_LCB_INT) \
  CosCompoundLifeCycle \
  CosLifeCycleReference \
  CosLifeCycleContainment \
  LifeCycleService

# Interfaces for Trading
COS_TRD_INT = \
  CosTrading \
  CosTradingDynamic \
  CosTradingRepos

# Interfaces for Persistence
COS_PER_INT = \
  CosPersistencePID \
  CosPersistencePDS \
  CosPersistencePDS_DA \
  CosPersistencePO \
  CosPersistencePOM \
  CosPersistenceDDO \
  CosPersistenceDS_CLI

# Interfaces for Query
COS_QRY_INT = \
  CosQueryCollection \
  CosQuery

# Note that we don't supply separate object libraries on VMS that
# include support for the BOA.  Instead, BOA support is included by
# default.  To eliminate the BOA overhead, comment out the following:

COS_IDL_OPT=-WbBOA

COSINTERFACES=TIMEBASE_INT\
	COS_REL_INT\
	COS_PRP_INT\
	COS_TRD_INT\
	COS_PER_INT\
	COS_QRY_INT\
	COS_EVT_INT\
	COS_NFY_INT\
	COS_COL_INT\
	COS_LIC_INT\
	COS_LIF_INT\
	COS_EXT_INT

# CosQuery stubs don't CXX compile when CosQuery.idl is omniidl
# compiled with -WbBOA, so override:
COS_QRY_INT_IDLOPT=

DIR_IDLFLAGS  = -Wbuse_quotes -I$(BASE_OMNI_TREE)/idl -Wba\
 -I. $(patsubst *,-I*/idl/COS,$(IMPORT_TREES))

DIR_CXXMACROS = _COS_LIBRARY ENABLE_CLIENT_IR_SUPPORT

DIR_CXXFLAGS=$(OMNIORB_LIB_CXXFLAGS) 
DIR_CXXINCLUDES=../include ../$(CURRENT)
DIR_CXXLINKFLAGS = /MAP/FULL

LIB_NAME		= COS
LIB_VERSION		= $(OMNIORB_VERSION)
LIB_IMPORTS		= OMNITHREAD$(OMNITHREAD_FILE_VERSION)\
	OMNIORB$(OMNIORB_FILE_VERSION)\
	OMNIDYNAMIC$(OMNIORB_FILE_VERSION)

extraheaders=COS_sysdep.h

COSInclude_V=$(SUBST ..,-,$(EXPORT_TREE)/include/omniORB4/COS)
COSInclude_V=$(SUBST /,.,$(COSInclude_V))
COSInclude_V=[$(SUBST .-,-,$(COSInclude_V))]

COSImport_V=$(SUBST ..,-,$(IMPORT_TREES)/idl/cos)
COSImport_V=$(SUBST /,.,$(COSImport_V))
COSImport_V=[$(SUBST .-,-,$(COSImport_V))]
