#!/bin/bash

################################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$2" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$2" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$2" = sfcb
then
	/etc/init.d/sfcb stop
fi

$4/registration/OpenDRIM_BIOSConcreteCollection-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSEnumeration-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSElement-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSString-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ServiceAffectsBIOSAttribute-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSInteger-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSServiceCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSConformsToProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSRegisteredProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_OrderedMemberOfBIOSCollection-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSConcreteComponent-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSHostedService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_OwningCollectionBIOS-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ServiceAffectsComputerSystem-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSPassword-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_BIOSConcreteDependency-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SystemBIOS-remove.sh $1 $2 $3 $4

if test "$2" = sfcb
then
	/etc/init.d/sfcb start
fi

