/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.shape;

/**
Builder class for javafx.scene.shape.Shape
@see javafx.scene.shape.Shape
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public abstract class ShapeBuilder<B extends javafx.scene.shape.ShapeBuilder<B>> extends javafx.scene.NodeBuilder<B> {
    protected ShapeBuilder() {
    }
    
    
    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.scene.shape.Shape x) {
        super.applyTo(x);
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setFill(this.fill); break;
                case 1: x.setSmooth(this.smooth); break;
                case 2: x.setStroke(this.stroke); break;
                case 3: x.getStrokeDashArray().addAll(this.strokeDashArray); break;
                case 4: x.setStrokeDashOffset(this.strokeDashOffset); break;
                case 5: x.setStrokeLineCap(this.strokeLineCap); break;
                case 6: x.setStrokeLineJoin(this.strokeLineJoin); break;
                case 7: x.setStrokeMiterLimit(this.strokeMiterLimit); break;
                case 8: x.setStrokeType(this.strokeType); break;
                case 9: x.setStrokeWidth(this.strokeWidth); break;
            }
        }
    }
    
    private javafx.scene.paint.Paint fill;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getFill() fill} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B fill(javafx.scene.paint.Paint x) {
        this.fill = x;
        __set(0);
        return (B) this;
    }
    
    private boolean smooth;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#isSmooth() smooth} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B smooth(boolean x) {
        this.smooth = x;
        __set(1);
        return (B) this;
    }
    
    private javafx.scene.paint.Paint stroke;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStroke() stroke} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B stroke(javafx.scene.paint.Paint x) {
        this.stroke = x;
        __set(2);
        return (B) this;
    }
    
    private java.util.Collection<? extends java.lang.Double> strokeDashArray;
    /**
    Add the given items to the List of items in the {@link javafx.scene.shape.Shape#getStrokeDashArray() strokeDashArray} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeDashArray(java.util.Collection<? extends java.lang.Double> x) {
        this.strokeDashArray = x;
        __set(3);
        return (B) this;
    }
    
    /**
    Add the given items to the List of items in the {@link javafx.scene.shape.Shape#getStrokeDashArray() strokeDashArray} property for the instance constructed by this builder.
    */
    public B strokeDashArray(java.lang.Double... x) {
        return strokeDashArray(java.util.Arrays.asList(x));
    }
    
    private double strokeDashOffset;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeDashOffset() strokeDashOffset} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeDashOffset(double x) {
        this.strokeDashOffset = x;
        __set(4);
        return (B) this;
    }
    
    private javafx.scene.shape.StrokeLineCap strokeLineCap;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeLineCap() strokeLineCap} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeLineCap(javafx.scene.shape.StrokeLineCap x) {
        this.strokeLineCap = x;
        __set(5);
        return (B) this;
    }
    
    private javafx.scene.shape.StrokeLineJoin strokeLineJoin;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeLineJoin() strokeLineJoin} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeLineJoin(javafx.scene.shape.StrokeLineJoin x) {
        this.strokeLineJoin = x;
        __set(6);
        return (B) this;
    }
    
    private double strokeMiterLimit;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeMiterLimit() strokeMiterLimit} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeMiterLimit(double x) {
        this.strokeMiterLimit = x;
        __set(7);
        return (B) this;
    }
    
    private javafx.scene.shape.StrokeType strokeType;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeType() strokeType} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeType(javafx.scene.shape.StrokeType x) {
        this.strokeType = x;
        __set(8);
        return (B) this;
    }
    
    private double strokeWidth;
    /**
    Set the value of the {@link javafx.scene.shape.Shape#getStrokeWidth() strokeWidth} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B strokeWidth(double x) {
        this.strokeWidth = x;
        __set(9);
        return (B) this;
    }
    
}
