/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.jdbc.kernel.exps;

/**
 * Simple listener which embeds the argument as an expression into the
 * where clause generated by the query. Listens on "ext:sqlExp".
 *  Example:<br />
 * <code>
 * "price &lt; 10 || ext:sqlExp (\"(SELECT AVG (PRICE) FROM PRODUCT_TABLE)
 * &gt; 100\")"
 * </code>
 *
 * @deprecated Use {@link SQLEmbed} directly
 */
public class SQLExpression
    extends SQLEmbed {

    public static final String TAG = "sqlExp";

    public String getTag() {
        return TAG;
    }
}
